% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covlmc_draw.R
\name{draw.covlmc}
\alias{draw.covlmc}
\title{Text based representation of a covlmc model}
\usage{
\method{draw}{covlmc}(
  ct,
  control = draw_control(),
  model = c("coef", "full"),
  p_value = TRUE,
  digits = 4,
  with_state = FALSE,
  ...
)
}
\arguments{
\item{ct}{a fitted covlmc model.}

\item{control}{a list of low level control parameters of the text
representation. See details and \code{\link[=draw_control]{draw_control()}}.}

\item{model}{this parameter controls the display of logistic models
associated to nodes. The default \code{model="coef"} represents the coefficients
of the logistic models associated to each context. \code{model="full"} includes
the name of the variables in the representation (see details). Setting
\code{model=NULL} removes the model representations. Additional parameters can
be used to tweak model representations (see details).}

\item{p_value}{specifies whether the p-values of the likelihood ratio tests
conducted during the covlmc construction must be included in the
representation.}

\item{digits}{numerical parameters and p-values are represented using the
\link[base:Round]{base::signif} function, using the number of significant digits specified
with this parameter.}

\item{with_state}{specifies whether to display the state associated to each
dimension of the logistic model (see details).}

\item{...}{additional arguments for draw.}
}
\value{
the context tree (invisibly).
}
\description{
This function 'draws' a context tree as a text.
}
\details{
The function uses basic "ascii art" to represent the context tree. Characters
used to represent the structure of the tree, e.g. branches, can be modified
using \code{\link[=draw_control]{draw_control()}}.

In addition to the structure of the context tree, \code{draw} can represent
information attached to the node (contexts and partial contexts). This is
controlled by additional parameters depending on the type of the context
tree.
}
\section{Tweaking model representation}{


Model representations are affected by the following additional parameter:
\itemize{
\item \code{time_sep}: character(s) used to split the coefficients list by blocks
associated to time delays in the covariate inclusion into the logistic
model. The first block contains the intercept(s), the second block the
covariate values a time t-1, the third block at time t-2, etc.
}
}

\section{Variable representation}{


When \code{model="full"}, the representation includes the names of the variables
used by the logistic models. Names are the one generated by the underlying
logistic model, e.g. \code{\link[stats:glm]{stats::glm()}}. Numerical variable names are used as
is, while factors have levels appended. The intercept is denoted \code{(I)} to
save space. The time delays are represented by an underscore followed by
the time delay. For instance if the model uses the numerical covariate \code{y}
with two delays, it will appear as to variables \code{y_1} and \code{y_2}.
}

\section{State representation}{


When \code{model} is not \code{NULL}, the coefficients of the logistic models are
presented, organized in rows associated to states. One state is used as the
reference state and the logistic model aims at predicting the ratio of
probability between another state and the reference one (in log scale).
When \code{with_state} is \code{TRUE}, the display includes for each row of
coefficients the target state. This is useful when using e.g. \code{VGAM::vglm}
as unused levels of the target variable will be automatically dropped from
the model, leading to a reduce number of rows. The reference state is
either shown on the first row if \code{model} is \code{"full"} or after the state on
each row if \code{model} is \code{"coef"}.
}

\examples{
pc <- powerconsumption[powerconsumption$week == 5, ]
dts <- cut(pc$active_power, breaks = c(0, quantile(pc$active_power, probs = c(0.5, 1))))
dts_cov <- data.frame(day_night = (pc$hour >= 7 & pc$hour <= 17))
m_cov <- covlmc(dts, dts_cov, min_size = 5)
draw(m_cov, digits = 3)
draw(m_cov, model = NULL)
draw(m_cov, p_value = FALSE)
draw(m_cov, p_value = FALSE, time_sep = " | ")
draw(m_cov, model = "full", time_sep = " | ")
}
