% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vlmc.R
\name{is_vlmc}
\alias{is_vlmc}
\title{Test if the object is a vlmc model}
\usage{
is_vlmc(x)
}
\arguments{
\item{x}{an R object.}
}
\value{
\code{TRUE} for VLMC models.
}
\description{
This function returns \code{TRUE} for VLMC models and \code{FALSE} for other objects.
}
\examples{
pc <- powerconsumption[powerconsumption$week == 5, ]
dts <- cut(pc$active_power, breaks = c(0, quantile(pc$active_power, probs = c(0.25, 0.5, 0.75, 1))))
model <- vlmc(dts)
# should be true
is_ctx_tree(model)
# should be true
is_vlmc(model)
# should be false
is_covlmc(model)
}
