% Generated by roxygen2 (4.0.1): do not edit by hand
\name{BayesianNormal}
\alias{BayesianNormal}
\title{Bayesian Estimation In Mixed Stochastic Differential Equations}
\usage{
BayesianNormal(times, X, model = c("OU", "CIR"), prior, start, random,
  nMCMC = 1000, propSd = 0.2)
}
\arguments{
\item{times}{vector of observation times}

\item{X}{matrix of the M trajectories (each row is a trajectory with \eqn{N= T/\Delta} column).}

\item{model}{name of the SDE: 'OU' (Ornstein-Uhlenbeck) or 'CIR' (Cox-Ingersoll-Ross).}

\item{prior}{list of prior parameters: mean and variance of the Gaussian prior on the mean mu, shape and scale of the inverse Gamma prior for the variances omega, shape and scale of the inverse Gamma prior for sigma}

\item{start}{list of starting values: mu, sigma}

\item{random}{random effects in the drift: 1 if one additive random effect, 2 if one multiplicative random effect or c(1,2) if 2 random effects.}

\item{nMCMC}{number of iterations of the MCMC algorithm}

\item{propSd}{proposal standard deviation of \eqn{\phi} is \eqn{|\mu|*}\code{propSd}\eqn{/\log(N)} at the beginning, is adjusted when acceptance rate is under 30\% or over 60\%}
}
\value{
\item{alpha}{posterior samples (Markov chain) of \eqn{\alpha}}
\item{beta}{posterior samples (Markov chain) of \eqn{\beta}}
\item{mu}{posterior samples (Markov chain) of \eqn{\mu}}
\item{omega}{posterior samples (Markov chain) of \eqn{\Omega}}
\item{sigma2}{posterior samples (Markov chain) of \eqn{\sigma^2}}
}
\description{
Gibbs sampler for Bayesian estimation of the random effects \eqn{(\alpha_j, \beta_j)} in the mixed SDE
 \eqn{dX_j(t)= (\alpha_j- \beta_j X_j(t))dt + \sigma a(X_j(t)) dW_j(t)}.
}
\references{
Hermann, S., Ickstadt, K. and C. Mueller (2016). Bayesian Prediction of Crack Growth Based on a Hierarchical Diffusion Model. \emph{Appearing in: Applied Stochastic Models in Business and Industry}.

Rosenthal, J. S. (2011). 'Optimal proposal distributions and adaptive MCMC.' Handbook of Markov Chain Monte Carlo (2011): 93-112.
}

