% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/viz_functions.R
\name{vizTheta}
\alias{vizTheta}
\title{Mixed Membership Visualization}
\usage{
vizTheta(model, compare = NULL, main = "Estimated Theta", varNames = NULL,
  groupNames = NULL, nrow = NULL, fitNames = NULL, indices = NULL)
}
\arguments{
\item{model}{the \code{mixedMemModel} object that will be plotted.}

\item{compare}{an array of the same dimensions as model$theta which contains values to compare against the fitted value.}

\item{main}{the main figure title.}

\item{varNames}{a vector of strings specifying labels for each variable.}

\item{groupNames}{a vector of strings specifying labels for each sub-population.}

\item{nrow}{the number of rows in each plot. If the argument is not specified, all variables will appear in one plot.}

\item{fitNames}{the names of the models plotted.}

\item{indices}{a vector which indicates specific variables to plot. If the argument is not specified, all variables will be plotted. If the number of variables
to plot is greater than nrow, then multiple plots will be produced.}
}
\description{
\code{vizTheta} plots \eqn{\theta}, the parameters which govern the sub-population distributions of variables in a mixed membership model.
 The parameter \eqn{\theta_{j,k}} specifies the distribution of variable j for complete members of sub-population k. The estimated
parameters from the given model are shown in black in each plot; the parameters from a comparison model (if available) are shown in red.
Each row of plots represents a single variable, and each column of the plots represents a sub-population.
}
\details{
This is the function called by the plot generic function for \code{mixedMemModel} objects.
}

