% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KendallTau.R
\name{KendallTau}
\alias{KendallTau}
\alias{Kendall_matrix}
\title{Kendall's tau correlation}
\usage{
KendallTau(x, y)

Kendall_matrix(X, Y = NULL)
}
\arguments{
\item{x}{A numeric vector.}

\item{y}{A numeric vector.}

\item{X}{A numeric matrix (n by p1).}

\item{Y}{A numeric matrix (n by p2).}
}
\value{
\code{KendallTau(x, y)} returns one Kendall's tau correlation value between two vectors, \code{x} and \code{y}.

\code{Kendall_matrix(X)} returns a p1 by p1 matrix of Kendall's tau correlation coefficients. \code{Kendall_matrix(X, Y)} returns a p1 by p2 matrix of Kendall's tau correlation coefficients.
}
\description{
Calculate Kendall's tau correlation.
\deqn{ \hat{\tau}_{jk} = \frac{2}{n(n-1)}\sum_{1\le i<i'\le n} sign(X_{ji}-X_{ji'}) sign(X_{ki}-X_{ki'}) }
The function \code{KendallTau} calculates Kendall's tau correlation between two variables, returning a single correlation value. The function \code{Kendall_matrix} returns a correlation matrix.
}
\examples{

n <- 100 # sample size
r <- 0.8 # true correlation

### vector input
# Data generation (X1: truncated continuous, X2: continuous)
Z <- mvrnorm(n, mu = c(0, 0), Sigma = matrix(c(1, r, r, 1), nrow = 2))
X1 <- Z[,1]
X1[Z[,1] < 1] <- 0
X2 <- Z[,2]

KendallTau(X1, X2)
Kendall_matrix(X1, X2)

### matrix data input
p1 <- 3; p2 <- 4 # dimension of X1 and X2
JSigma <- matrix(r, nrow = p1+p2, ncol = p1+p2); diag(JSigma) <- 1
Z <- mvrnorm(n, mu = rep(0, p1+p2), Sigma = JSigma)
X1 <- Z[,1:p1]
X1[Z[,1:p1] < 0] <- 0
X2 <- Z[,(p1+1):(p1+p2)]

Kendall_matrix(X1, X2)

}
