% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibullpar.R
\name{to_k_lambda_weibull}
\alias{to_k_lambda_weibull}
\title{Parameter Conversion for Weibull Distribution}
\usage{
to_k_lambda_weibull(mu, sd)
}
\arguments{
\item{mu}{a numeric vector representing the means of Weibull distributions}

\item{sd}{a numeric vector representing the standard deviations of Weibull distributions.
\code{mu} and \code{sd} should have the same length.}
}
\value{
a list of two items
\item{k}{a vector of the shapes of Weibull distributions}
\item{lambda}{a vector of the scales of Weibull distributions}
}
\description{
The function \code{to_k_lambda_weibull} converts the mean and standard deviation to the shape and scale for
the Weibull distributions.
}
\details{
The purpose of this function is to convert the parameterization of Weibull distribution in the form of
mean and standard deviation to the form of shape and scale. It can be used for specifying the initial
values for the EM algorithm when the first-hand initial values are in the form of mean and standard
deviation from K-means clustering algorithm.
}
\examples{
to_k_lambda_weibull(2, 1)
to_k_lambda_weibull(c(2, 5), c(1, 0.7))

}
\seealso{
\code{\link{to_mu_sd_weibull}}
}
