\name{rRotationMatrix}
\alias{rRotationMatrix}
\alias{C_RotationMatrix_R}
\title{
  Random rotation matrix
}
\description{
  Generate a random rotation matrix, i.e., a matrix
  \eqn{\boldsymbol{P} = (p_{i,j})_{i=1,\dots,p, j=1,\dots,p},}{%
    P = (p[i,j]), i=1,\ldots,p, j=1,\ldots,p,}
  which satisfies

  a) \eqn{\boldsymbol{P}\boldsymbol{P}' = \boldsymbol{I}}{P * P' = I},

  b) \eqn{\boldsymbol{P}'\boldsymbol{P} = \boldsymbol{I}}{P' * P = I},

  c) \eqn{\mbox{det}(\boldsymbol{P}) = 1}{det(P) = 1}.
}
\details{
  For \code{dim} = 2, \eqn{p_{2,1}}{p[2,1]}
  (\eqn{\sin(\theta)}{sin(theta)})
  is generated from Unif(0, 1) and the rest computed as follows:
  \eqn{p_{1,1} = p_{2,2} = \sqrt{1 - p_{2,1}^2}}{%
    p[1,1] = p[2,2] = sqrt(1 - p[2,1]^2)}
  (\eqn{\cos(\theta)}{cos(theta)}) and
  \eqn{p_{1,2} = -p_{2,1}}{p[1,2] = p[2,1]}
  (\eqn{-\sin(\theta)}{-sin(theta)}).

  For \code{dim} \eqn{>} 2, the matrix \eqn{\boldsymbol{P}}{P} is generated
  in the following steps:
  
  1) Generate a \eqn{p\times p}{p x p} matrix \eqn{\boldsymbol{A}}{A} with
  independent Unif(0, 1) elements and check whether \eqn{\boldsymbol{A}}{A}
  is of full rank \eqn{p}.

  2) Computes a QR decomposition of \eqn{\boldsymbol{A}}{A}, i.e.,
  \eqn{\boldsymbol{A} = \boldsymbol{Q}\boldsymbol{R}}{A = QR} where
  \eqn{\boldsymbol{Q}}{Q} satisfies
  \eqn{\boldsymbol{Q}\boldsymbol{Q}' = \boldsymbol{I}}{Q * Q' = I},
  \eqn{\boldsymbol{Q}'\boldsymbol{Q} = \boldsymbol{I}}{Q' * Q = I},
  \eqn{\mbox{det}(\boldsymbol{Q}) = (-1)^{p+1}}{det(Q) = (-1)^{p+1}},
  and columns of \eqn{\boldsymbol{Q}}{Q} spans the linear space generated by
  the columns of \eqn{\boldsymbol{A}}{A}.

  3) For odd \code{dim}, return matrix \eqn{\boldsymbol{Q}}{Q}. For even
  \code{dim}, return corrected matrix \eqn{\boldsymbol{Q}}{Q} to satisfy the
  determinant condition.
}  
\usage{
rRotationMatrix(n, dim)
}
\arguments{
  \item{n}{number of matrices to generate.}
  \item{dim}{dimension of a generated matrix/matrices.}
}
\value{
  For \code{n}=1, a matrix is returned.

  For \code{n}>1, a list of matrices is returned.
}
\references{
  Golub, G. H. and Van Loan, C. F. (1996, Sec. 5.1).
  \emph{Matrix Computations. Third Edition}.
  Baltimore: The Johns Hopkins University Press.
}
%\seealso{
%}
\author{
  Arnošt Komárek \email{arnost.komarek[AT]mff.cuni.cz}
}  
\examples{
P <- rRotationMatrix(n=1, dim=5)
print(P)
round(P \%*\% t(P), 10)
round(t(P) \%*\% P, 10)
det(P)

n <- 10
P <- rRotationMatrix(n=n, dim=5)
for (i in 1:3){
  cat(paste("*** i=", i, "\n", sep=""))
  print(P[[i]])
  print(round(P[[i]] \%*\% t(P[[i]]), 10))
  print(round(t(P[[i]]) \%*\% P[[i]], 10))
  print(det(P[[i]]))
}
}
\keyword{array}
\keyword{distribution}
\keyword{multivariate}
