% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosstab.R
\name{crosstab}
\alias{crosstab}
\title{Cross Tabulation}
\usage{
crosstab(...,  data = NULL, print = c("no", "all", "row", "col", "total"),
         freq = TRUE, split = FALSE, na.omit = TRUE, digits = 2, as.na = NULL,
         write = NULL, append = TRUE, check = TRUE, output = TRUE)
}
\arguments{
\item{...}{ a matrix or data frame with two or three columns. Alternatively,
an expression indicating the variable names in \code{data}.
Note, variable names are specified without quotes \code{''} or
double quotes \code{""}, e.g., \code{crosstab(x1, x2, data = dat)}.
Note that the operators
\code{.}, \code{+}, \code{-}, \code{~}, \code{:}, \code{::},
and \code{!} can also be used to select variables, see 'Details'
in the \code{\link{df.subset}} function.}

\item{data}{a data frame when specifying one or more variables in the
argument \code{...}. Note that the argument is \code{NULL}
when specifying a matrix or data frame for the argument
\code{...}.}

\item{print}{a character string or character vector indicating which
percentage(s) to be printed on the console, i.e., no percentages
(\code{"no"}) (default), all percentages (\code{"all"}),
row-wise percentages (\code{"row"}), column-wise percentages
(\code{"col"}), and total percentages (\code{"total"}).}

\item{freq}{logical: if \code{TRUE} (default), absolute frequencies will be included
in the cross tabulation.}

\item{split}{logical: if \code{TRUE}, output table is split in absolute
frequencies and percentage(s).}

\item{na.omit}{logical: if \code{TRUE} (default), incomplete cases are removed before
conducting the analysis (i.e., listwise deletion).}

\item{digits}{an integer indicating the number of decimal places digits
to be used for displaying percentages.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting
the analysis.}

\item{write}{a character string naming a file for writing the output into
either a text file with file extension \code{".txt"} (e.g.,
\code{"Output.txt"}) or Excel file with file extension
\code{".xlsx"}  (e.g., \code{"Output.xlsx"}). If the file
name does not contain any file extension, an Excel file will
be written.}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}

\item{output}{logical: if \code{TRUE} (default), output is printed on the console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:
  \item{\code{call}}{function call}
  \item{\code{type}}{type of analysis}
  \item{\code{data}}{matrix or data frame specified in \code{...}}
  \item{\code{args}}{specification of function arguments}
  \item{\code{result}}{list with result tables, i.e., \code{crosstab} for the
                       cross tabulation, \code{freq.a} for the absolute frequencies,
                       \code{perc.r} for the row-wise percentages, \code{perc.c}
                       for the column-wise percentages, \code{perc.t} for the total
                       percentages}
}
\description{
This function creates a two-way and three-way cross tabulation with absolute
frequencies and row-wise, column-wise and total percentages.
}
\examples{
#----------------------------------------------------------------------------
# Two-Dimensional Table

# Example 1a: Cross Tabulation for 'vs' and 'am'
crosstab(mtcars[, c("vs", "am")])

# Example 1b: Alternative specification using the 'data' argument
crosstab(vs, am, data = mtcars)

# Example 2: Cross Tabulation, print all percentages
crosstab(mtcars[, c("vs", "am")], print = "all")

# Example 3: Cross Tabulation, print row-wise percentages
crosstab(mtcars[, c("vs", "am")], print = "row")

# Example 4: Cross Tabulation, print col-wise percentages
crosstab(mtcars[, c("vs", "am")], print = "col")

# Example 5: Cross Tabulation, print total percentages
crosstab(mtcars[, c("vs", "am")], print = "total")

# Example 6: Cross Tabulation, print all percentages, split output table
crosstab(mtcars[, c("vs", "am")], print = "all", split = TRUE)

#----------------------------------------------------------------------------
# Three-Dimensional Table

# Example 7a: Cross Tabulation for 'vs', 'am', ane 'gear'
crosstab(mtcars[, c("vs", "am", "gear")])

# Example 7b: Alternative specification using the 'data' argument
crosstab(vs:gear, data = mtcars)

# Example 8: Cross Tabulation, print all percentages
crosstab(mtcars[, c("vs", "am", "gear")], print = "all")

# Example 9: Cross Tabulation, print all percentages, split output table
crosstab(mtcars[, c("vs", "am", "gear")], print = "all", split = TRUE)

\dontrun{
# Example 10a: Write results into a text file
crosstab(mtcars[, c("vs", "am")], print = "all", write = "Crosstab.txt")

# Example 10b: Write results into an Excel file
crosstab(mtcars[, c("vs", "am")], print = "all", write = "Crosstab.xlsx")}
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology
- Using R and SPSS}. John Wiley & Sons.
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}

\code{\link{write.result}}, \code{\link{freq}}, \code{\link{descript}},
\code{\link{multilevel.descript}}, \code{\link{na.descript}}.
}
