% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chr.grep.R
\name{chr.grep}
\alias{chr.grep}
\alias{chr.grepl}
\title{Multiple Pattern Matching}
\usage{
chr.grep(pattern, x, ignore.case = FALSE, perl = FALSE, value = FALSE,
         fixed = FALSE, useBytes = FALSE, invert = FALSE, check = TRUE)

chr.grepl(pattern, x, ignore.case = FALSE, perl = FALSE, fixed = FALSE,
          useBytes = FALSE, check = TRUE)
}
\arguments{
\item{pattern}{a character vector with character strings to be matched.}

\item{x}{a character vector where matches are sought.}

\item{ignore.case}{logical: if \code{FALSE} (default), the pattern matching
is case sensitive and if \code{TRUE}, case is ignored during
matching.}

\item{perl}{logical: if \code{TRUE} Perl-compatible regexps are used.}

\item{value}{logical: if \code{FALSE} (default), a vector containing the
(integer) indices of the matches determined by grep is
returned, and if \code{TRUE}, a vector containing the
matching elements themselves is returned.}

\item{fixed}{logical: if \code{TRUE}, pattern is a string to be matched
as is. Overrides all conflicting arguments.}

\item{useBytes}{logical: if \code{TRUE}, the matching is done byte-by-byte
rather than character-by-character. See ‘Details’.}

\item{invert}{logical: if \code{TRUE}, function returns indices or values
for elements that do not match.}

\item{check}{logical: if \code{TRUE} (default), argument specification
is checked.}
}
\value{
Returns a integer vector with the indices of the mathces when \code{value = FALSE},
character vector containing the matching elements when \code{value = TRUE}, or
a logical vector when using the \code{chr.grepl} function.
}
\description{
This function searches for matches to the character vector specified in
\code{pattern} within each element of the character vector \code{x}.
}
\examples{
chr.vector <- c("James", "Mary", "Michael", "Patricia", "Robert", "Jennifer")

# Example 1: Indices of matching elements
chr.grep(c("am", "er"), chr.vector)

# Example 2: Values of matching elements
chr.grep(c("am", "er"), chr.vector, value = TRUE)

# Example 3: Matching element?
chr.grepl(c("am", "er"), chr.vector)
}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988) \emph{The New S Language}.
Wadsworth & Brooks/Cole
}
\seealso{
\code{\link{chr.gsub}}, \code{\link{chr.omit}}, \code{\link{chr.trim}}
}
\author{
Takuya Yanagida
}
