% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libraries.R
\name{libraries}
\alias{libraries}
\title{Load and Attach Multiple Packages}
\usage{
libraries(..., install = FALSE, quiet = TRUE, check = TRUE, output = TRUE)
}
\arguments{
\item{...}{the names of the packages to be loaded, given as names
(e.g., \code{misty, lavaan, lme4}), or  literal character
strings (e.g., \code{"misty", "lavaan", "lme4"}), or character
vector (e.g., \code{c("misty", "lavaan", "lme4")}).}

\item{install}{logical: if \code{TRUE}, missing packages and dependencies are
installed.}

\item{quiet}{logical: if \code{TRUE} (default), startup messages when loading
package are disabled.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: logical: if \code{TRUE}, output is shown on the console.}
}
\description{
This function loads and attaches multiple add-on packages at once.
}
\examples{
\dontrun{
# Example 1: Load packages using the names of the packages
misty::libraries(misty, lme4, lmerTest)

# Example 2: Load packages using literal character strings
misty::libraries("misty", "lme4", "lmerTest")

# Example 3: Load packages using a character vector
misty::libraries(c("misty", "lme4", "lmerTest"))

# Example 4: Check packages, i.e., TRUE = all depends/imports/suggests installed
misty::libraries(misty, lme4, lmerTest, output = FALSE)$result$restab

# Example 5: Depends, FALSE = not installed, TRUE = installed
misty::libraries(misty, lme4, lmerTest, output = FALSE)$result$depends

# Example 6: Imports, FALSE = not installed, TRUE = installed
misty::libraries(misty, lme4, lmerTest, output = FALSE)$result$imports

# Example 6: Suggests, FALSE = not installed, TRUE = installed
misty::libraries(misty, lme4, lmerTest, output = FALSE)$result$suggests
}
}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988) \emph{The New S Language}.
Wadsworth & Brooks/Cole.
}
\seealso{
\code{\link{library}}, \code{\link{require}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
