% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.var.R
\name{ci.var}
\alias{ci.var}
\title{Confidence Interval for the Variance}
\usage{
ci.var(x, method = c("chisq", "bonett"),
       alternative = c("two.sided", "less", "greater"), conf.level = 0.95,
       group = NULL, split = NULL, sort.var = FALSE, na.omit = FALSE,
       digits = 2, as.na = NULL, check = TRUE, output = TRUE)
}
\arguments{
\item{x}{a numeric vector, matrix or data frame with numeric variables, i.e.,
factors and character variables are excluded from \code{x} before conducting the analysis.}

\item{method}{a character string specifying the method for computing the confidence interval,
must be one of \code{"chisq"}, or \code{"bonett"} (default).}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of
\code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}

\item{conf.level}{a numeric value between 0 and 1 indicating the confidence level of the interval.}

\item{group}{a numeric vector, character vector or factor as grouping variable.}

\item{split}{a numeric vector, character vector or factor as split variable.}

\item{sort.var}{logical: if \code{TRUE}, output table is sorted by variables when specifying \code{group}.}

\item{na.omit}{logical: if \code{TRUE}, incomplete cases are removed before conducting the analysis
(i.e., listwise deletion) when specifying more than one outcome variable.}

\item{digits}{an integer value indicating the number of decimal places to be used.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.
Note that \code{as.na()} function is only applied to \code{x}, but
not to \code{group} or \code{split}.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is shown on the console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:
  \item{\code{call}}{function call}
  \item{\code{type}}{type of analysis}
  \item{\code{data}}{list with the input specified in \code{x}, \code{group},
                     and \code{split}}
  \item{\code{args}}{specification of function arguments}
  \item{\code{result}}{result table}
}
\description{
This function computes a confidence interval for the variance for one or more variables, optionally
by a grouping and/or split variable.
}
\details{
The confidence interval based on the chi-square distribution is computed by specifying \code{method = "chisq"},
while the Bonett (2006) confidence interval is requested by specifying \code{method = "bonett"}. By default,
the Bonett confidence interval interval is computed which performs well under moderate departure from
normality, while the confidence interval based on the chi-square distribution is highly sensitive to minor
violations of the normality assumption and its performance does not improve with increasing sample size.
Note that at least four valid observations are needed to compute the Bonett confidence interval.
}
\examples{
dat <- data.frame(group1 = c(1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2,
                             1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2),
                  group2 = c(1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2,
                             1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2),
                  x1 = c(3, 1, 4, 2, 5, 3, 2, 3, 6, 4, 3, NA, 5, 3,
                         3, 2, 6, 3, 1, 4, 3, 5, 6, 7, 4, 3, 5, 4),
                  x2 = c(4, NA, 3, 6, 3, 7, 2, 7, 3, 3, 3, 1, 3, 6,
                         3, 5, 2, 6, 8, 3, 4, 5, 2, 1, 3, 1, 2, NA),
                  x3 = c(7, 8, 5, 6, 4, 2, 8, 3, 6, 1, 2, 5, 8, 6,
                         2, 5, 3, 1, 6, 4, 5, 5, 3, 6, 3, 2, 2, 4))

# Two-Sided 95\% CI for x1
ci.var(dat$x1)

# Two-Sided 95\% CI for x1 using chi square distribution
ci.var(dat$x1, method = "chisq")

# One-Sided 95\% CI for x1
ci.var(dat$x1, alternative = "less")

# Two-Sided 99\% CI
ci.var(dat$x1, conf.level = 0.99)

# Two-Sided 95\% CI, print results with 3 digits
ci.var(dat$x1, digits = 3)

# Two-Sided 95\% CI for x1, convert value 4 to NA
ci.var(dat$x1, as.na = 4)

# Two-Sided 95\% CI for x1, x2, and x3,
# listwise deletion for missing data
ci.var(dat[, c("x1", "x2", "x3")], na.omit = TRUE)

# Two-Sided 95\% CI for x1, x2, and x3,
# analysis by group1 separately
ci.var(dat[, c("x1", "x2", "x3")], group = dat$group1)

# Two-Sided 95\% CI for x1, x2, and x3,
# analysis by group1 separately, sort by variables
ci.var(dat[, c("x1", "x2", "x3")], group = dat$group1, sort.var = TRUE)

# Two-Sided 95\% CI for x1, x2, and x3,
# split analysis by group1
ci.var(dat[, c("x1", "x2", "x3")], split = dat$group1)

# Two-Sided 95\% CI for x1, x2, and x3,
# analysis by group1 separately, split analysis by group2
ci.var(dat[, c("x1", "x2", "x3")],
       group = dat$group1, split = dat$group2)
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
John Wiley & Sons.

Bonett, D. G. (2006). Approximate confidence interval for standard deviation of nonnormal distributions.
\emph{Computational Statistics and Data Analysis, 50}, 775-782. https://doi.org/10.1016/j.csda.2004.10.003
}
\seealso{
\code{\link{ci.mean}}, \code{\link{ci.mean.diff}}, \code{\link{ci.median}},
\code{\link{ci.prop}}, \code{\link{ci.prop.diff}}, \code{\link{ci.sd}},
\code{\link{descript}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
