% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.prop.diff.R
\name{ci.prop.diff}
\alias{ci.prop.diff}
\alias{ci.prop.diff.default}
\alias{ci.prop.diff.formula}
\title{Confidence Interval for the Difference in Proportions}
\usage{
ci.prop.diff(x, ...)

\method{ci.prop.diff}{default}(x, y, method = c("wald", "newcombe"), paired = FALSE,
             alternative = c("two.sided", "less", "greater"), conf.level = 0.95,
             group = NULL, split = NULL, sort.var = FALSE, digits = 2,
             as.na = NULL, check = TRUE, output = TRUE, \dots)

\method{ci.prop.diff}{formula}(formula, data, method = c("wald", "newcombe"),
             alternative = c("two.sided", "less", "greater"), conf.level = 0.95,
             group = NULL, split = NULL, sort.var = FALSE, na.omit = FALSE,
             digits = 2, as.na = NULL, check = TRUE, output = TRUE, \dots)
}
\arguments{
\item{x}{a numeric vector with 0 and 1 values.}

\item{...}{further arguments to be passed to or from methods.}

\item{y}{a numeric vector with 0 and 1 values.}

\item{method}{a character string specifying the method for computing the confidence interval,
must be one of \code{"wald"}, or \code{"newcombe"} (default).}

\item{paired}{logical: if \code{TRUE}, confidence interval for the difference of proportions
in paired samples is computed.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of
\code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}

\item{conf.level}{a numeric value between 0 and 1 indicating the confidence level of the interval.}

\item{group}{a numeric vector, character vector or factor as grouping variable. Note that a grouping
variable can only be used when computing confidence intervals with unknown population
standard deviation and population variance.}

\item{split}{a numeric vector, character vector or factor as split variable. Note that a split
variable can only be used when computing confidence intervals with unknown population
standard deviation and population variance.}

\item{sort.var}{logical: if \code{TRUE}, output table is sorted by variables when specifying \code{group}.}

\item{digits}{an integer value indicating the number of decimal places to be used.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.
Note that \code{as.na()} function is only applied to \code{x}, but
not to \code{group} or \code{split}.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is shown on the console.}

\item{formula}{a formula of the form \code{y ~ group} for one outcome variable or
\code{cbind(y1, y2, y3) ~ group} for more than one outcome variable where
\code{y} is a numeric variable with 0 and 1 values and \code{group} a numeric
variable, character variable or factor with two values of factor levels given the corresponding group.}

\item{data}{a matrix or data frame containing the variables in the formula \code{formula}.}

\item{na.omit}{logical: if \code{TRUE}, incomplete cases are removed before conducting the analysis
(i.e., listwise deletion) when specifying more than one outcome variable.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following entries:
function call (\code{call}), type of analysis \code{type}, list with the input specified in \code{x},
\code{group}, and \code{split} (\code{data}), specification of function arguments (\code{args}),
and result table (\code{result}).
}
\description{
This function computes a confidence interval for the difference in proportions in a two-sample
and paired-sample design for one or more variables, optionally by a grouping and/or split variable.
}
\details{
The Wald confidence interval which is based on the normal approximation to the binomial distribution are
computed by specifying \code{method = "wald"}, while the Newcombe Hybrid Score interval (Newcombe, 1998a;
Newcombe, 1998b) is requested by specifying \code{method = "newcombe"}. By default, Newcombe Hybrid Score
interval is computed which have been shown to be reliable in small samples (less than n = 30 in each sample)
as well as moderate to larger samples(n > 30 in each sample) and with proportions close to 0 or 1, while the
Wald confidence intervals does not perform well unless the sample size is large (Fagerland, Lydersen & Laake, 2011).
}
\examples{
dat1 <- data.frame(group1 = c(1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2,
                              1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2),
                   group2 = c(1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2,
                              1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2),
                   group3 = c(1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
                              1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2),
                   x1 = c(0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, NA, 0, 0,
                          1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0, 0),
                   x2 = c(0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1,
                          1, 0, 1, 0, 1, 1, 1, NA, 1, 0, 0, 1, 1, 1),
                   x3 = c(1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0,
                          1, 0, 1, 1, 0, 1, 1, 1, 0, 1, NA, 1, 0, 1))

#--------------------------------------
# Two-sample design

# Two-Sided 95\% CI for x1 by group1
# Newcombes Hybrid Score interval
ci.prop.diff(x1 ~ group1, data = dat1)

# Two-Sided 95\% CI for x1 by group1
# Wald CI
ci.prop.diff(x1 ~ group1, data = dat1, method = "wald")

# One-Sided 95\% CI for x1 by group1
# Newcombes Hybrid Score interval
ci.prop.diff(x1 ~ group1, data = dat1, alternative = "less")

# Two-Sided 99\% CI for x1 by group1
# Newcombes Hybrid Score interval
ci.prop.diff(x1 ~ group1, data = dat1, conf.level = 0.99)

# Two-Sided 95\% CI for y1 by group1
# # Newcombes Hybrid Score interval, print results with 3 digits
ci.prop.diff(x1 ~ group1, data = dat1, digits = 3)

# Two-Sided 95\% CI for y1 by group1
# # Newcombes Hybrid Score interval, convert value 0 to NA
ci.prop.diff(x1 ~ group1, data = dat1, as.na = 0)

# Two-Sided 95\% CI for y1, y2, and y3 by group1
# Newcombes Hybrid Score interval
ci.prop.diff(cbind(x1, x2, x3) ~ group1, data = dat1)

# Two-Sided 95\% CI for y1, y2, and y3 by group1
# # Newcombes Hybrid Score interval, listwise deletion for missing data
ci.prop.diff(cbind(x1, x2, x3) ~ group1, data = dat1, na.omit = TRUE)

# Two-Sided 95\% CI for y1, y2, and y3 by group1
# Newcombes Hybrid Score interval, analysis by group2 separately
ci.prop.diff(cbind(x1, x2, x3) ~ group1, data = dat1, group = dat1$group2)

# Two-Sided 95\% CI for y1, y2, and y3 by group1
# Newcombes Hybrid Score interval, analysis by group2 separately, sort by variables
ci.prop.diff(cbind(x1, x2, x3) ~ group1, data = dat1, group = dat1$group2,
             sort.var = TRUE)

# Two-Sided 95\% CI for y1, y2, and y3 by group1
# split analysis by group2
ci.prop.diff(cbind(x1, x2, x3) ~ group1, data = dat1, split = dat1$group2)

# Two-Sided 95\% CI for y1, y2, and y3 by group1
# Newcombes Hybrid Score interval, analysis by group2 separately, split analysis by group3
ci.prop.diff(cbind(x1, x2, x3) ~ group1, data = dat1,
             group = dat1$group2, split = dat1$group3)

#-----------------

group1 <- c(0, 1, 1, 0, 0, 1, 0, 1)
group2 <- c(1, 1, 1, 0, 0)

# Two-Sided 95\% CI for the mean difference between group1 and group2
# Newcombes Hybrid Score interval
ci.prop.diff(group1, group2)

#--------------------------------------
# Paires-sample design

dat2 <- data.frame(pre = c(0, 1, 1, 0, 1),
                   post = c(1, 1, 0, 1, 1), stringsAsFactors = FALSE)

# Two-Sided 95\% CI for the mean difference in x1 and x2
# Newcombes Hybrid Score interval
ci.prop.diff(dat2$pre, dat2$post, paired = TRUE)

# Two-Sided 95\% CI for the mean difference in x1 and x2
# Wald CI
ci.prop.diff(dat2$pre, dat2$post, method = "wald", paired = TRUE)

# One-Sided 95\% CI for the mean difference in x1 and x2
# Newcombes Hybrid Score interval
ci.prop.diff(dat2$pre, dat2$post, alternative = "less", paired = TRUE)

# Two-Sided 99\% CI for the mean difference in x1 and x2
# Newcombes Hybrid Score interval
ci.prop.diff(dat2$pre, dat2$post, conf.level = 0.99, paired = TRUE)

# Two-Sided 95\% CI for for the mean difference in x1 and x2
# Newcombes Hybrid Score interval, print results with 3 digits
ci.prop.diff(dat2$pre, dat2$post, paired = TRUE, digits = 3)
}
\references{
Fagerland, M. W., Lydersen S., & Laake, P. (2011) Recommended confidence intervals for two independent binomial
proportions. \emph{Statistical Methods in Medical Research, 24}, 224-254.

Newcombe, R. G. (1998a). Interval estimation for the difference between independent proportions: Comparison of
eleven methods. \emph{Statistics in Medicine, 17}, 873-890.

Newcombe, R. G. (1998b). Improved confidence intervals for the difference between binomial proportions based on
paired data. \emph{Statistics in Medicine, 17}, 2635-2650.

Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
John Wiley & Sons.
}
\seealso{
\code{\link{ci.prop}}, \code{\link{ci.mean}}, \code{\link{ci.mean.diff}}, \code{\link{ci.median}},
\code{\link{ci.var}}, \code{\link{ci.sd}}, \code{\link{descript}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
