% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multilevel.descript.R
\name{multilevel.descript}
\alias{multilevel.descript}
\title{Multilevel Descriptive Statistics}
\usage{
multilevel.descript(x, cluster, print = c("all", "var", "sd"),
                    method = c("aov", "lme4", "nlme"), REML = TRUE,
                    digits = 2, icc.digits = 3, as.na = NULL, write = NULL,
                    check = TRUE, output = TRUE)
}
\arguments{
\item{x}{a vector, matrix or data frame.}

\item{cluster}{a vector representing the nested grouping structure (i.e.,
group or cluster variable).}

\item{print}{a character string or character vector indicating which results to
show on the console, i.e. \code{"all"} for variances and standard deviations,
\code{"var"} (default) for variances, or \code{"sd"} for standard deviations
within and between clusters.}

\item{method}{a character string indicating the method used to estimate
intraclass correlation coefficients, i.e., \code{"aov"} ICC
estimated using the \code{aov} function, \code{"lme4"} (default)
ICC estimated using the \code{lmer} function in the \pkg{lme4}
package, \code{"nlme"} ICC estimated using the \code{lme} function
in the \pkg{nlme} package.}

\item{REML}{logical: if \code{TRUE} (default), restricted maximum likelihood
is used to estimate the null model when using the \code{lmer()}
function in the \pkg{lme4} package or the \code{lme()} function in
the \pkg{nlme} package.}

\item{digits}{an integer value indicating the number of decimal places to
be used.}

\item{icc.digits}{an integer indicating the number of decimal places to be used
for displaying intraclass correlation coefficients.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting
the analysis. Note that \code{as.na()} function is only applied
to \code{x} but not to \code{cluster}.}

\item{write}{a character string for writing the results into a Excel file
naming a file with or without file extension '.xlsx', e.g.,
\code{"Results.xlsx"} or \code{"Results"}.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is shown on the console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:
  \item{\code{call}}{function call}
  \item{\code{type}}{type of analysis}
  \item{\code{data}}{data frame specified in \code{x} including the group variable
                     specified in \code{cluster}}
  \item{\code{args}}{specification of function arguments}
  \item{\code{model.fit}}{fitted lavaan object (\code{mod.fit})}
  \item{\code{result}}{list with result tables, i.e., \code{no.obs} for the
                       number of observations \code{no.no.miss} for the
                       number of missing value, \code{no.cluster} for the
                       number of clusters, \code{m.cluster.size} for the average
                       cluster size, \code{sd.cluster.size} for the standard
                       deviation of the cluster size, \code{min.cluster.size} for
                       the minimum cluster size, \code{max.cluster.size} for the
                       maximum cluster size, \code{mean.x} for the mean values,
                       \code{var.w} for the variance within clusters, \code{var.b}
                       for the variance between clusters, \code{icc1} for ICC(1),
                       \code{icc2} for ICC(2), \code{deff} for the design effect,
                       \code{deff.sqrt} for the square root of the design effect,
                       \code{n.effect} for the effective sample size}
}
\description{
This function computes descriptive statistics for multilevel data, e.g. average
cluster size, variance components, intraclass correlation coefficient,
design effect, and effective sample size.
}
\details{
Note that this function is restricted to two-level models.
}
\examples{
\dontrun{
# Load data set "Demo.twolevel" in the lavaan package
data("Demo.twolevel", package = "lavaan")

#---------------------------
# Cluster variable specification

# Cluster variable 'cluster' in 'x'
multilevel.descript(Demo.twolevel[, c("y1", "cluster")], cluster = "cluster")

# Cluster variable 'cluster' not in 'x'
multilevel.descript(Demo.twolevel$y1, cluster = Demo.twolevel$cluster)

#---------------------------

# Multilevel descriptive statistics for y1
multilevel.descript(Demo.twolevel$y1, cluster = Demo.twolevel$cluster)

# Multilevel descriptive statistics for y1, print variance and standard deviation
multilevel.descript(Demo.twolevel$y1, cluster = Demo.twolevel$cluster, print = "all")

# Multilevel descriptive statistics for y1, print ICC with 5 digits
multilevel.descript(Demo.twolevel$y1, cluster = Demo.twolevel$cluster, icc.digits = 5)

# Multilevel descriptive statistics for y1
# use lme() function in the nlme package to estimate ICC
multilevel.descript(Demo.twolevel$y1, cluster = Demo.twolevel$cluster, method = "nlme")

# Multilevel descriptive statistics for y1, y2, y3, w1, and w2
multilevel.descript(Demo.twolevel[, c("y1", "y2", "y3", "w1", "w2")],
                    cluster = Demo.twolevel$cluster)

# Write Results into a Excel file
multilevel.descript(Demo.twolevel[, c("y1", "y2", "y3", "w1", "w2")],
                    cluster = Demo.twolevel$cluster, write = "Multilevel_Descript.xlsx")

result <- multilevel.descript(Demo.twolevel[, c("y1", "y2", "y3", "w1", "w2")],
                              cluster = Demo.twolevel$cluster, output = FALSE)
write.result(result, "Multilevel_Descript.xlsx")
}
}
\references{
Hox, J., Moerbeek, M., & van de Schoot, R. (2018). \emph{Multilevel analysis:
Techniques and applications} (3rd. ed.). Routledge.

Snijders, T. A. B., & Bosker, R. J. (2012). \emph{Multilevel analysis: An
introduction to basic and advanced multilevel modeling} (2nd ed.). Sage Publishers.
}
\seealso{
\code{\link{write.result}}, \code{\link{multilevel.icc}}, \code{\link{descript}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
