% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.t.R
\name{test.t}
\alias{test.t}
\alias{test.t.default}
\alias{test.t.formula}
\title{t-Test}
\usage{
test.t(x, ...)

\method{test.t}{default}(x, y = NULL, mu = 0, paired = FALSE,
       alternative = c("two.sided", "less", "greater"), conf.level = 0.95,
       hypo = TRUE, descript = TRUE, effsize = FALSE, weighted = TRUE,
       cor = TRUE, ref = NULL, correct = FALSE, digits = 2, p.digits = 4,
       as.na = NULL, check = TRUE, output = TRUE, ...)

\method{test.t}{formula}(formula, data, alternative = c("two.sided", "less", "greater"),
       conf.level = 0.95, hypo = TRUE, descript = TRUE, effsize = FALSE,
       weighted = TRUE, cor = TRUE, ref = NULL, correct = FALSE, digits = 2,
       p.digits = 4, as.na = NULL, check = TRUE, output = TRUE, ...)
}
\arguments{
\item{x}{a numeric vector of data values.}
\item{y}{a numeric vector of data values.}
\item{mu}{a numeric value indicating the population mean under the null hypothesis. Note that the argument \code{mu} is only used when computing a one sample t-test.}
\item{paired}{logical: if \code{TRUE}, paired-samples t-test is computed.}
\item{alternative}{a character string specifying the alternative hypothesis, must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}
\item{conf.level}{a numeric value between 0 and 1 indicating the confidence level of the interval.}
\item{hypo}{logical: if \code{TRUE}, null and alternative hypothesis are shown on the console.}
\item{descript}{logical: if \code{TRUE}, descriptive statistics are shown on the console.}
\item{effsize}{logical: if \code{TRUE}, effect size measure Cohen's d is shown on the console, see \code{\link{cohens.d}} function.}
\item{weighted}{logical: if \code{TRUE} (default), the weighted pooled standard deviation is used to compute Cohen's d for a two-sample design (i.e., \code{paired = FALSE}), while standard deviation of the difference scores is used to compute Cohen's d for a paired-sample design (i.e., \code{paired = TRUE}).}
\item{cor}{logical: if \code{TRUE} (default), \code{paired = TRUE}, and \code{weighted = FALSE}, Cohen's d for a paired-sample design while controlling for the correlation between the two sets of measurement is computed. Note that this argument is only used in a paired-sample design (i.e., \code{paired = TRUE}) when specifying \code{weighted = FALSE}.}
\item{ref}{character string \code{"x"} or \code{"y"} for specifying the reference reference group when using the default \code{test.t()} function or a numeric value or character string indicating the reference group in a two-sample design when using the formula \code{test.t()} function. The standard deviation of the reference variable or reference group is used to standardized the mean difference to compute Cohen's d. Note that this argument is only used in a two-sample design (i.e., \code{paired = FALSE}).}
\item{correct}{logical: if \code{TRUE}, correction factor to remove positive bias in small samples is used.}
\item{digits}{an integer value indicating the number of decimal places to be used for displaying descriptive statistics and confidence interval.}
\item{p.digits}{an integer value indicating the number of decimal places to be used for displaying the \emph{p}-value.}
\item{as.na}{a numeric vector indicating user-defined missing values, i.e. these values are converted to \code{NA} before conducting the analysis.}
\item{check}{logical: if \code{TRUE}, argument specification is checked.}
\item{output}{logical: if \code{TRUE}, output is shown on the console.}
\item{formula}{in case of two sample t-test (i.e., \code{paired = FALSE}), a formula of the form \code{y ~ group} where \code{group} is a numeric variable, character variable or factor with two values or factor levels giving the corresponding groups.}
\item{data}{a matrix or data frame containing the variables in the formula \code{formula}.}
\item{...}{further arguments to be passed to or from methods.}}
\value{
Returns an object of class \code{misty.object}, which is a list with following entries:
function call (\code{call}), type of analysis \code{type}, list with the input specified in \code{x}
(\code{data}), specification of function arguments (\code{args}), and result table (\code{result}).
}
\description{
This function performs one-sample, two-sample, and paired-sample t-tests.
}
\examples{
dat1 <- data.frame(group = c(1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2),
                   x = c(3, 1, 4, 2, 5, 3, 2, 3, 6, 6, 3, NA))

#--------------------------------------
# One-Sample Design

# Two-sided one-sample t-test
# population mean = 3
test.t(dat1$x, mu = 3)

# One-sided one-sample t-test
# population mean = 3, population standard deviation = 1.2
test.t(dat1$x, mu = 3, alternative = "greater")

# Two-sided one-sample t-test
# population mean = 3, convert value 3 to NA
test.t(dat1$x, mu = 3, as.na = 3)

# Two-sided one-sample t-test
# population mean = 3, print Cohen's d
test.t(dat1$x, sigma = 1.2, mu = 3, effsize = TRUE)

# Two-sided one-sample t-test
# population mean = 3, print Cohen's d with small sample correction factor
test.t(dat1$x, sigma = 1.2, mu = 3, effsize = TRUE, correct = TRUE)

# Two-sided one-sample t-test
# population mean = 3,
# do not print hypotheses and descriptive statistics
test.t(dat1$x, sigma = 1.2, mu = 3, hypo = FALSE, descript = FALSE)

# Two-sided one-sample t-test
# print descriptive statistics with 3 digits and p-value with 5 digits
test.t(dat1$x,  mu = 3, digits = 3, p.digits = 5)

#--------------------------------------
# Two-Sample Design

# Two-sided two-sample t-test
test.t(x ~ group, data = dat1)

# One-sided two-sample t-test
test.t(x ~ group, data = dat1, alternative = "greater")

# Two-sided two-sample t-test
# print Cohen's d with weighted pooled SD
test.t(x ~ group, data = dat1, effsize = TRUE)

# Two-sided two-sample t-test
# print Cohen's d with unweighted pooled SD
test.t(x ~ group, data = dat1, effsize = TRUE, weighted = FALSE)

# Two-sided two-sample t-test
# print Cohen's d with weighted pooled SD and
# small sample correction factor
test.t(x ~ group, data = dat1, effsize = TRUE, correct = TRUE)

# Two-sided two-sample t-test
# print Cohen's d with SD of the reference group 1
test.t(x ~ group, data = dat1, effsize = TRUE,
       ref = 1)

# Two-sided two-sample t-test
# print Cohen's d with weighted pooled SD and
# small sample correction factor
test.t(x ~ group, data = dat1, effsize = TRUE,
       correct = TRUE)

# Two-sided two-sample t-test
# do not print hypotheses and descriptive statistics,
test.t(x ~ group, data = dat1, descript = FALSE, hypo = FALSE)

# Two-sided two-sample t-test
# print descriptive statistics with 3 digits and p-value with 5 digits
test.t(x ~ group, data = dat1, digits = 3, p.digits = 5)

#-----------------

group1 <- c(3, 1, 4, 2, 5, 3, 6, 7)
group2 <- c(5, 2, 4, 3, 1)

# Two-sided two-sample t-test
test.t(group1, group2)

#--------------------------------------
# Paired-Sample Design

dat2 <- data.frame(pre = c(1, 3, 2, 5, 7),
                   post = c(2, 2, 1, 6, 8), stringsAsFactors = FALSE)

# Two-sided paired-sample t-test
test.t(dat2$pre, dat2$post, paired = TRUE)

# One-sided paired-sample t-test
test.t(dat2$pre, dat2$post, paired = TRUE,
       alternative = "greater")

# Two-sided paired-sample t-test
# convert value 1 to NA
test.t(dat2$pre, dat2$post, as.na = 1, paired = TRUE)

# Two-sided paired-sample t-test
# print Cohen's d based on the standard deviation of the difference scores
test.t(dat2$pre, dat2$post, paired = TRUE, effsize = TRUE)

# Two-sided paired-sample t-test
# print Cohen's d based on the standard deviation of the difference scores
# with small sample correction factor
test.t(dat2$pre, dat2$post, paired = TRUE, effsize = TRUE,
       correct = TRUE)

# Two-sided paired-sample t-test
# print Cohen's d controlling for the correlation between measures
test.t(dat2$pre, dat2$post, paired = TRUE, effsize = TRUE,
       weighted = FALSE)

# Two-sided paired-sample t-test
# print Cohen's d controlling for the correlation between measures
# with small sample correction factor
test.t(dat2$pre, dat2$post, paired = TRUE, effsize = TRUE,
       weighted = FALSE, correct = TRUE)

# Two-sided paired-sample t-test
# print Cohen's d ignoring the correlation between measures
test.t(dat2$pre, dat2$post, paired = TRUE, effsize = TRUE,
       weighted = FALSE, cor = FALSE)

# Two-sided paired-sample t-test
# do not print hypotheses and descriptive statistics
test.t(dat2$pre, dat2$post, paired = TRUE, hypo = FALSE, descript = FALSE)

# Two-sided paired-sample t-test
# population standard deviation of difference score = 1.2
# print descriptive statistics with 3 digits and p-value with 5 digits
test.t(dat2$pre, dat2$post, paired = TRUE, digits = 3,
       p.digits = 5)
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
John Wiley & Sons.
}
\seealso{
\code{\link{test.welch}}, \code{\link{test.z}}, \code{\link{test.levene}}, \code{\link{cohens.d}},
\code{\link{ci.mean.diff}}, \code{\link{ci.mean}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
