% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.freq.R
\name{print.freq}
\alias{print.freq}
\title{Print freq object}
\usage{
\method{print}{freq}(x, print = x$args$print, freq = x$args$freq, digits = x$args$digits,
      check = TRUE, ...)
}
\arguments{
\item{x}{\code{freq} object.}

\item{print}{a character string indicating which percentage(s) to be printed on the console, i.e.,
no percentages (\code{"no"}), all percentages (\code{"all"}), percentage frequencies
(\code{"print"}), and valid percentage frequencies (\code{"v.perc"}).}

\item{freq}{logical: if \code{TRUE}, absolute frequencies will be shown on the console.}

\item{digits}{an integer value indicating the number of decimal places to be used for displaying
percentages.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{freq} object
}
\examples{
\dontrun{
dat <- data.frame(x1 = c(3, 3, 2, 3, 2, 3, 3, 2, 1, -99),
                  x2 = c(2, 2, 1, 3, 1, 1, 3, 3, 2, 2),
                  y1 = c(1, 4, NA, 5, 2, 4, 3, 5, NA, 1),
                  y2 = c(2, 3, 4, 3, NA, 4, 2, 3, 4, 5),
                  z = c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10))

# Frequency table for one variable
# convert value -99 into NA
dat.freq <- freq(dat$x1, as.na = -99, output = FALSE)

# Print freq object with 3 digits for displaying percentages
print(dat.freq, digits = 3)
}
}
\seealso{
\code{\link{freq}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
