% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmm.R
\name{pmm}
\alias{pmm}
\title{Predictive Mean Matching}
\usage{
pmm(xtrain, xtest, ytrain, k = 1L, seed = NULL)
}
\arguments{
\item{xtrain}{Vector with predicted values in the training data. Can be of type logical, numeric, character, or factor.}

\item{xtest}{Vector as \code{xtrain} with predicted values in the test data. Missing values are not allowed.}

\item{ytrain}{Vector of the observed values in the training data. Must be of same length as \code{xtrain}. Missing values in either of \code{xtrain} or \code{ytrain} will be dropped in a pairwise manner.}

\item{k}{Number of nearest neighbours to sample from.}

\item{seed}{Integer random seed.}
}
\value{
Vector of the same length as \code{xtest} with values from \code{xtrain}.
}
\description{
For each value in the prediction vector \code{xtest}, one of the closest \code{k} values in the prediction vector \code{xtrain} is randomly chosen and its observed value in \code{ytrain} is returned.
}
\examples{
pmm(xtrain = c(0.2, 0.2, 0.8), xtest = 0.3, ytrain = c(0, 0, 1)) # 0
pmm(xtrain = c(TRUE, FALSE, TRUE), xtest = FALSE, ytrain = c(2, 0, 1)) # 0
pmm(xtrain = c(0.2, 0.8), xtest = 0.3, ytrain = c("A", "B"), k = 2) # "A" or "B"
pmm(xtrain = c("A", "A", "B"), xtest = "A", ytrain = c(2, 2, 4), k = 2) # 2
pmm(xtrain = factor(c("A", "B")), xtest = factor("C"), ytrain = 1:2) # 2
}
