% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/klPIE.R
\name{klPIE}
\alias{klPIE}
\title{Calculate Kullback-Leibler Divergence with Base 10 Logarithm}
\usage{
klPIE(P, Q, min_value = 1e-12)
}
\arguments{
\item{P}{A numeric matrix representing the first probability distribution.
The entire matrix should sum to 1.}

\item{Q}{A numeric matrix representing the second probability distribution.
The entire matrix should sum to 1.}

\item{min_value}{A numeric value representing the minimum value to replace
any zero probabilities. Defaults to \code{1e-12}.}
}
\value{
A named numeric vector with two elements:
\describe{
\item{"P || Q"}{The KL divergence from P to Q (P || Q).}
\item{"Q || P"}{The KL divergence from Q to P (Q || P).}
}
}
\description{
This function computes the Kullback-Leibler (KL) divergence between two
probability distributions represented by matrices, using a base 10 logarithm.
The function calculates KL divergence in both directions (P || Q and Q || P)
and handles zero probabilities by replacing them with a minimum value to avoid
undefined logarithms.
}
