% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-management.R
\name{gtrack.dataset}
\alias{gtrack.dataset}
\title{Returns the database/dataset path for a track}
\usage{
gtrack.dataset(track = NULL)
}
\arguments{
\item{track}{track name or a vector of track names}
}
\value{
Character vector of database/dataset paths. Returns NA for non-existent tracks.
}
\description{
Returns the path of the database or dataset containing a track.
}
\details{
When datasets are loaded, tracks can come from either the working database
or from loaded datasets. This function returns the source path for each track.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gtrack.dataset("dense_track")

}
\seealso{
\code{\link{gtrack.dbs}}, \code{\link{gtrack.exists}},
\code{\link{gtrack.ls}}, \code{\link{gdataset.ls}}
}
\keyword{~database}
\keyword{~path}
\keyword{~track}
