% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals-utils.R
\name{gintervals.coverage_fraction}
\alias{gintervals.coverage_fraction}
\title{Calculate fraction of genomic space covered by intervals}
\usage{
gintervals.coverage_fraction(intervals1 = NULL, intervals2 = NULL)
}
\arguments{
\item{intervals1}{set of one-dimensional intervals (the covering set)}

\item{intervals2}{set of one-dimensional intervals to be covered (default:
NULL, meaning the entire genome)}
}
\value{
A single numeric value between 0 and 1 representing the fraction of
'intervals2' (or the genome) covered by 'intervals1'.
}
\description{
Returns the fraction of a genomic space that is covered by a set of intervals.
}
\details{
This function calculates what fraction of 'intervals2' is covered by
'intervals1'. If 'intervals2' is NULL, it calculates the fraction of the
entire genome that is covered by 'intervals1'. Overlapping intervals in
either set are automatically unified before calculation.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()

# Create some intervals
intervs1 <- gscreen("dense_track > 0.15")
intervs2 <- gintervals(c("chr1", "chr2"), 0, c(100000, 100000))

# Calculate fraction of intervs2 covered by intervs1
gintervals.coverage_fraction(intervs1, intervs2)

# Calculate fraction of entire genome covered by intervs1
gintervals.coverage_fraction(intervs1)

}
\seealso{
\code{\link{gintervals}}, \code{\link{gintervals.intersect}},
\code{\link{gintervals.covered_bp}}, \code{\link{gintervals.all}}
}
\keyword{~coverage}
\keyword{~genomics}
