% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.R
\name{gscreen}
\alias{gscreen}
\title{Finds intervals that match track expression}
\usage{
gscreen(
  expr = NULL,
  intervals = NULL,
  iterator = NULL,
  band = NULL,
  intervals.set.out = NULL
)
}
\arguments{
\item{expr}{logical track expression}

\item{intervals}{genomic scope for which the function is applied}

\item{iterator}{track expression iterator. If 'NULL' iterator is determined
implicitly based on track expression.}

\item{band}{track expression band. If 'NULL' no band is used.}

\item{intervals.set.out}{intervals set name where the function result is
optionally outputted}
}
\value{
If 'intervals.set.out' is 'NULL' a set of intervals that match track
expression.
}
\description{
Finds all intervals where track expression is 'TRUE'.
}
\details{
This function finds all intervals where track expression's value is 'TRUE'.

If 'intervals.set.out' is not 'NULL' the result is saved as an intervals
set. Use this parameter if the result size exceeds the limits of the
physical memory.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gscreen("dense_track > 0.2 & sparse_track < 0.4",
    iterator = "dense_track"
)

}
\seealso{
\code{\link{gsegment}}, \code{\link{gextract}}
}
\keyword{~interval}
\keyword{~intervals}
\keyword{~screen}
