% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/KFadvanceAR2.R
\name{KFadvanceAR2}
\alias{KFadvanceAR2}
\title{KFadvanceAR2 function}
\usage{
KFadvanceAR2(obs, oldmean, oldermean, oldvar, oldervar, A, A1, B, C, D, E, F, W,
  V, marglik = FALSE, log = TRUE, na.rm = FALSE)
}
\arguments{
\item{obs}{Y_t}

\item{oldmean}{mu_{t-1}}

\item{oldermean}{mu_{t2}}

\item{oldvar}{Sigma_{t-1}}

\item{oldervar}{Sigma_{t-2}}

\item{A}{A matrix A}

\item{A1}{A matrix A1}

\item{B}{column vector B}

\item{C}{matrix C}

\item{D}{matrix D}

\item{E}{column vector E}

\item{F}{matrix F}

\item{W}{state noise covariance}

\item{V}{observation noise covariance}

\item{marglik}{logical, whether to return the marginal likelihood contribution from this observation}

\item{log}{whether or not to return the log of the likelihood contribution.}

\item{na.rm}{na.rm logical, whether or not to handle NAs. Defult is FALSE. Set to TRUE if there are any missing values in the observed data.}
}
\value{
list containing the new mean and variance, and if specified, the likelihood
}
\description{
A function to compute one step of the Kalman filter with second order AR state evolution.
Embed in a loop to run the filter on a set of data.
}
\details{
The model is: (note that Y and theta are COLUMN VECTORS)

theta_t = A*theta_{t-1} + A1*theta_{t-2} + B + C*W (state equation)

Y_t = D*theta_t + E + F*V         (observation equation)

W and V are the covariance matrices of the state and observation noise. Priors are normal,

N(mu_{t-1},Sigma_{t-1}) and N(mu_{t-2},Sigma_{t-2})

Result is the posterior, N(mu_t,Sigma_t), together with the likelihood contribution Prob(Y_t|Y_{t-1})
}

