% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_pattern.R
\name{generate_pattern}
\alias{generate_pattern}
\title{Generate a CAT patterns}
\usage{
generate_pattern(mo, Theta, df = NULL)
}
\arguments{
\item{mo}{single group object defined by the \code{mirt} package}

\item{Theta}{a numeric vector indicating the latent theta values for a single person}

\item{df}{(optional) data.frame object containing questions, options, and scoring
keys. See \code{\link{mirtCAT}} for details}
}
\description{
Generate a CAT pattern given various inputs. Returns a character vector or numeric matrix 
(depending on whether a \code{df} input was supplied) with columns equal to the test size and
rows equal to the number of rows in \code{Theta}. For simulation studies, supplying a 
\code{Theta} input with more than 1 row will generate a matrix of responses for
running independent CAT session when passed to \code{mirtCAT(..., local_pattern)}. When
the returned object is an integer vector then the \code{Theta} values will be stored 
as an attribute \code{'Theta'} to be automatically used in Monte Carlo simulations.
}
\examples{
\dontrun{

# return real response vector given choices and (optional) answers 
pat <- generate_pattern(mod, Theta = 0, df=df)
# mirtCAT(df, mo=mod, local_pattern = pat)

# generate single pattern observed in dataset used to define mod
pat2 <- generate_pattern(mod, Theta = 0)
# mirtCAT(mo=mod, local_pattern = pat2)

# generate multiple patterns to be analyzed independently 
pat3 <- generate_pattern(mod, Theta = matrix(c(0, 2, -2), 3))
# mirtCAT(mo=mod, local_pattern = pat3)

}
}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}

Chalmers, R. P. (2016). Generating Adaptive and Non-Adaptive Test Interfaces for 
Multidimensional Item Response Theory Applications. \emph{Journal of Statistical Software, 71}(5), 
1-39. \doi{10.18637/jss.v071.i05}
}
\seealso{
\code{\link{mirtCAT}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
