% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/generate.mirt_object.R
\name{generate.mirt_object}
\alias{generate.mirt_object}
\title{Generate a mirt object from population parameters}
\usage{
generate.mirt_object(parameters, itemtype, latent_means = NULL,
  latent_covariance = NULL, key = NULL)
}
\arguments{
\item{parameters}{a matrix or data.frame of parameters corresponding to the model definitions
  listed in \code{\link{mirt}}. Each row represents a unqiue item, while the
  column names correspond to the respective parameter names. If a parameter is not relavent
  for a particular item/row then use \code{NA}'s as placeholders}

\item{itemtype}{a character vector indiciating the type of item to which the parameters
  refer. See the \code{itemtype} arguement in \code{\link{mirt}}. Note that this input
  is only used to determine the relavent item class for the rows in \code{parameters},
  therefore many inputs are interchangable (e.g., '2PL' generates the same model as '3PL').
  If only a single value is provided then all items types will be assumed identical}

\item{latent_means}{(optional) a numeric vector used to define the population latent mean
  structure. By default the mean structure is centered at a 0 centroid}

\item{latent_covariance}{(optional) a covariance matrix used to define the population
  variance-covariance structure between the latent traits. By default the relationship is
  assumed to be standard normal (i.e., and identity matrix)}

\item{key}{scoring key required for nested-logit models. See \code{\link{mirt}} for details}
}
\description{
This function generate a \code{mirt} object from known population parameters, which is
then passed to \code{\link{mirtCAT}} function for running CAT applications.
}
\examples{
\dontrun{

### build a unidimensional test with all 3PL items

nitems <- 50
a1 <- rlnorm(nitems, .2,.2)
d <- rnorm(nitems)
g <- rbeta(nitems, 20, 80)

pars <- data.frame(a1=a1, d=d, g=g)
head(pars)

obj <- generate.mirt_object(pars, '3PL')
coef(obj, simplify = TRUE)
plot(obj, type = 'trace')

### build a two-dimensional test
## all graded items with 5 response categories

nitems <- 30
as <- matrix(rlnorm(nitems*2, .2, .2), nitems)
diffs <- t(apply(matrix(runif(nitems*4, .3, 1), nitems), 1, cumsum))
diffs <- -(diffs - rowMeans(diffs))
ds <- diffs + rnorm(nitems)
pars2 <- data.frame(as, ds)
colnames(pars2) <- c('a1', 'a2', paste0('d', 1:4))
head(pars2)

obj <- generate.mirt_object(pars2, 'graded')
coef(obj, simplify = TRUE)

### unidimensional mixed-item test

library(plyr)
pars3 <- rbind.fill(pars, pars2) #notice the NA's where parmeters do not exist
obj <- generate.mirt_object(pars3, itemtype = c(rep('2PL', 50), rep('graded', 30)))
coef(obj)
itemplot(obj, 51)
itemplot(obj, 1, drop.zeros=TRUE)

}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\seealso{
\code{\link{mirt}}, \code{\link{mirtCAT}}, \code{\link{generate_pattern}}
}

