% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.mirt.R
\name{read.mirt}
\alias{read.mirt}
\title{Translate mirt parameters into suitable structure for plink package}
\usage{
read.mirt(x, as.irt.pars = TRUE, ...)
}
\arguments{
\item{x}{a single object (or list of objects) returned from \code{mirt, bfactor}, or a
single object returned by \code{multipleGroup}}

\item{as.irt.pars}{if \code{TRUE}, the parameters will be output as an \code{irt.pars} object}

\item{...}{additional arguments to be passed to \code{coef()}}
}
\description{
This function exports item parameters from the \code{mirt} package to the
\code{plink} package.
}
\examples{

\dontrun{

## unidimensional
library(plink)

data <- expand.table(LSAT7)
(mod1 <- mirt(data, 1))
plinkpars <- read.mirt(mod1)
plot(plinkpars)
plot(mod1, type = 'trace')

# graded
mod2 <- mirt(Science, 1)
plinkpars <- read.mirt(mod2)
plot(plinkpars)
plot(mod2, type = 'trace')

# gpcm
mod3 <- mirt(Science, 1, itemtype = 'gpcm')
plinkpars <- read.mirt(mod3)
plot(plinkpars)
plot(mod3, type = 'trace')

# nominal
mod4 <- mirt(Science, 1, itemtype = 'nominal')
plinkpars <- read.mirt(mod4)
plot(plinkpars)
plot(mod4, type = 'trace')

## multidimensional

data <- expand.table(LSAT7)
(mod1 <- mirt(data, 2))
plinkpars <- read.mirt(mod1)
plinkpars
plot(plinkpars)
plot(mod1, type = 'trace')

cmod <- mirt.model('
   F1 = 1,4,5
   F2 = 2-4')
model <- mirt(data, cmod)
plot(read.mirt(model))
itemplot(model, 1)

# graded
mod2 <- mirt(Science, 2)
plinkpars <- read.mirt(mod2)
plinkpars
plot(plinkpars)
plot(mod2, type = 'trace')

### multiple group equating example
set.seed(1234)
dat <- expand.table(LSAT7)
group <- sample(c('g1', 'g2'), nrow(dat), TRUE)
dat1 <- dat[group == 'g1', ]
dat2 <- dat[group == 'g2', ]
mod1 <- mirt(dat1, 1)
mod2 <- mirt(dat2, 1)

# convert and combine pars
plinkMG <- read.mirt(list(g1=mod1, g2=mod2))

# equivalently:
# mod <- multipleGroup(dat, 1, group)
# plinkMG <- read.mirt(mod)

combine <- matrix(1:5, 5, 2)
comb <- combine.pars(plinkMG, combine, grp.names=unique(group))
out <- plink(comb, rescale="SL")
equate(out)
equate(out, method = 'OSE')

}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{plink}
