% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.table.R
\name{expand.table}
\alias{expand.table}
\title{Expand summary table of patterns and frequencies}
\usage{
expand.table(tabdata, sample = FALSE)
}
\arguments{
\item{tabdata}{An object of class \code{data.frame} or \code{matrix}
with the unique response patterns and the number of frequencies
in the rightmost column}

\item{sample}{logical; randomly switch the rows in the expanded table? This does not change the
expanded data, only the row locations}
}
\value{
Returns a numeric matrix with all the response patterns.
}
\description{
The \code{expand.table} function expands a summary table of unique response
patterns to a full sized data-set. The response frequencies must be on the
rightmost column of the input data.
}
\examples{

\dontrun{
data(LSAT7)
head(LSAT7)
LSAT7full <- expand.table(LSAT7)
head(LSAT7full)

LSAT7full <- expand.table(LSAT7, sample = TRUE)
head(LSAT7full)

}

}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{data}
