context("association and output test")

skip('association tests mipred.cv')

cll <- readRDS("CLL_BMJ.rds")

cll_bin<-cll

cll_bin$srv5y_s[cll_bin$srv5y>12] <- 0  # Apply an administrative censorship at t=84 months
cll_bin$srv5y[cll_bin$srv5y>12]  <- 12

cll_bin$Status[cll_bin$srv5y_s==1]<- 1  # Define the "Status" variable
cll_bin$Status[cll_bin$srv5y_s==0] <- 0  # Ss numeric -> 1:Dead, 0:Alive

cll_bin$Censor <- NULL
cll_bin$srv5y <- NULL
cll_bin$srv5y_s <- NULL

# first check use of dot notation for both averaging and rubin method
# compare directly between full formula and dot notation calculation

# check for averaging method
# by comparing output between two distinct analyses
seeds <- c(7350, 5880, 2571, 3887, 9745, 5608, 3468, 2711, 3448, 4676,
  1627, 5087, 6479, 3901, 1037, 6622, 4832, 3382, 8515, 268, 3210,
  5944, 3380, 3646, 9188, 2750, 7987, 466, 2981, 136, 5134, 8476,
  5618, 8948, 1590, 5281, 2551, 2052, 1444, 8688, 1691, 6398, 4728,
  8267, 5274, 4154, 982, 7540, 3081, 5286, 6405, 1238, 5589, 8221,
  6026, 1922, 7651, 3100, 4341, 2134, 9685, 4524, 9750, 7618, 8211,
  2438, 824, 6982, 6548, 9743, 4302, 9038, 185, 4418, 1306, 6643,
  9865, 3436, 6151, 9647, 4261, 8109, 7573, 127, 571, 4545, 7245,
  4764, 5038, 9037, 6085, 1459, 5124, 9463, 942, 2241, 6492, 3190,
  8229, 7099)+10000
seed <- as.vector(matrix(seeds,ncol=1,nrow=5*5))[1:4]
set.seed(46409)
output1<-mipred.cv(Status~.,family=binomial,data=cll_bin[1:694,-1], nimp=2, folds=2, mice.options=list(maxit=2, printFlag=FALSE, seed=seed))
set.seed(46409)
output2<-mipred.cv(Status~age10+perfstat+remstat+cyto+asct+donor+sex_match+cond,family=binomial,data=cll_bin[1:694,-1], nimp=2, folds=2, mice.options=list(maxit=2, printFlag=FALSE, seed=seed))

test_that("mipred.cv results correct when using dot notation in predictor for averaging method",{
  expect_identical(output1[2:3],output2[2:3])
})


# check for rubin method
# by comparing output between two distinct analyses
seeds <- c(7350, 5880, 2571, 3887, 9745, 5608, 3468, 2711, 3448, 4676,
  1627, 5087, 6479, 3901, 1037, 6622, 4832, 3382, 8515, 268, 3210,
  5944, 3380, 3646, 9188, 2750, 7987, 466, 2981, 136, 5134, 8476,
  5618, 8948, 1590, 5281, 2551, 2052, 1444, 8688, 1691, 6398, 4728,
  8267, 5274, 4154, 982, 7540, 3081, 5286, 6405, 1238, 5589, 8221,
  6026, 1922, 7651, 3100, 4341, 2134, 9685, 4524, 9750, 7618, 8211,
  2438, 824, 6982, 6548, 9743, 4302, 9038, 185, 4418, 1306, 6643,
  9865, 3436, 6151, 9647, 4261, 8109, 7573, 127, 571, 4545, 7245,
  4764, 5038, 9037, 6085, 1459, 5124, 9463, 942, 2241, 6492, 3190,
  8229, 7099)+10001
seed <- as.vector(matrix(seeds,ncol=1,nrow=5*5))[1:4]
set.seed(45759)
output1<-mipred.cv(Status~.,family=binomial,data=cll_bin[1:694,-1], nimp=2, folds=2, mice.options=list(maxit=2, printFlag=FALSE, seed=seed), method="rubin")
set.seed(45759)
output2<-mipred.cv(Status~age10+perfstat+remstat+cyto+asct+donor+sex_match+cond,family=binomial,data=cll_bin[1:694,-1], nimp=2, folds=2, mice.options=list(maxit=2, printFlag=FALSE, seed=seed), method="rubin")

test_that("mipred.cv results correct when using dot notation in predictor for rubin method",{
  expect_identical(output1[2:3],output2[2:3])
})




# compare with saved results calculated from full formula
# based on: nimp=2, folds=2, mice.options=list(maxit=2, seed=seed) and seeds as below
# check for averaging method
preds <- structure(c(0.0913113982504282, 0.205002832411828, 0.235307753915466,
  0.130833369412761, 0.319891395664755, 0.413835233202078, 0.236344745128168,
  0.392046756922078, 0.264200646968459, 0.0772351029224595, 0.568917819972382,
  0.687785293948044, 0.319214856617008, 0.15487284715132, 0.145904144299823,
  0.0810923429069689, 0.0965360789590202, 0.545152140368265, 0.081994607086966,
  0.259873991202174, 0.338679002660538, 0.204087759931697, 0.315857454154808,
  0.243941811290267, 0.368990811322329, 0.377200109384867, 0.308414481997353,
  0.228459150501422, 0.323093985746204, 0.298826440413221, 0.330047776418152,
  0.151842578234661, 0.191419742683409, 0.23706732823784, 0.169729350412035,
  0.0990633395058016, 0.133251523440481, 0.100116154226906, 0.511138294559638,
  0.191705034407303, 0.297530636580443, 0.161762718389096, 0.243211039228653,
  0.245464776726281, 0.0491236604579135, 0.32234937345363, 0.426249681139407,
  0.259259736936139, 0.203364349892342, 0.206163879401658, 0.218196260387408,
  0.524342095569456, 0.307321840257096, 0.244507591094041, 0.0887639415190514,
  0.242688343448125, 0.11662653266584, 0.100097912347356, 0.484725694308464,
  0.165031354830531, 0.0841623230567649, 0.116974223431149, 0.558778531676977,
  0.209119493805785, 0.464177513783235, 0.239058713037548, 0.237683868841706,
  0.429513427704064, 0.180762257376498, 0.149169709418061, 0.30225122346481,
  0.201594283600267, 0.116986480237119, 0.252101634084587, 0.352275150192243,
  0.370772672400803, 0.316203935921901, 0.859546396955811, 0.365233550684307,
  0.240831531041877, 0.0918174522684127, 0.141506266644884, 0.0528347220955928,
  0.398520837467129, 0.190297167645349, 0.123522923207211, 0.127464627870317,
  0.395203908392914, 0.0869446168630749, 0.344548540783511, 0.167296508325157,
  0.198576943306381, 0.45788949892489, 0.288506739935992, 0.184533770940436,
  0.0553301989015827, 0.132880059042904, 0.187607721196768, 0.181747021755588,
  0.612135135665185, 0.321753854824794, 0.0490432503631617, 0.572619652077137,
  0.111464253200017, 0.251272587779984, 0.202412299007124, 0.345207017706479,
  0.289022736188874, 0.348644308147579, 0.222564494415229, 0.254858730172056,
  0.0550961636060158, 0.107730724305283, 0.366665418320996, 0.532006106764718,
  0.485684983922859, 0.0816121537299415, 0.13734029284154, 0.193004298159619,
  0.220630147964959, 0.324408101027024, 0.195529821072278, 0.192478978319568,
  0.157969224582182, 0.132669286738705, 0.0471418821922543, 0.129918578206572,
  0.27806798193113, 0.240541008837948, 0.283757777701297, 0.354605479086721,
  0.418171974881824, 0.311960603211056, 0.135152132774603, 0.285771695153382,
  0.172900037061388, 0.164197171820738, 0.105992684479298, 0.105725564999195,
  0.463763575088482, 0.186590468714341, 0.237961143306151, 0.278888829515329,
  0.689875204327845, 0.224072837960336, 0.483576081747667, 0.586351529180403,
  0.0795097024100417, 0.214720252675324, 0.484170936280297, 0.121472610875174,
  0.21430174127306, 0.0576060477060866, 0.118569003526581, 0.338714807316809,
  0.118903412143218, 0.0764112271500755, 0.0997845783687272, 0.25161826201572,
  0.114578295199989, 0.57434106494888, 0.3289518997789, 0.285230258274293,
  0.228774932691599, 0.0535670170066243, 0.183721210771269, 0.406632843837022,
  0.19860211153078, 0.122899662172889, 0.610878583352401, 0.508642129930739,
  0.234496750310723, 0.298640272842297, 0.114655222184175, 0.25994313293533,
  0.261861241448966, 0.439142254879224, 0.212035101505423, 0.0649605393137098,
  0.120066837044841, 0.269503278694515, 0.352640269571813, 0.189705351946428,
  0.174280694089135, 0.147530550220686, 0.187147133787329, 0.126377208146948,
  0.0849568133655036, 0.361924502503413, 0.194950885797577, 0.565500624582376,
  0.626757216993373, 0.280996998258359, 0.467373589234425, 0.089123016741405,
  0.160811937382287, 0.241120652619818, 0.093101126573148, 0.596296190651742,
  0.638358966881976, 0.143503176309917, 0.264720025633886, 0.177463324376691,
  0.458149589386367, 0.167864124437393, 0.0866715110428221, 0.118996197942772,
  0.522391688354131, 0.160377062510365, 0.272849246118406, 0.150109988826045,
  0.0910543221001234, 0.390184108307785, 0.242385145123559, 0.114782432232922,
  0.13663952861347, 0.228270313470934, 0.39006380808953, 0.146513359579913,
  0.235004173393785, 0.557703650607244, 0.142471192223014, 0.453087897635295,
  0.152930060686964, 0.0723649724685446, 0.135956229349844, 0.202819836121764,
  0.503100708371882, 0.253950777098664, 0.0639327236859717, 0.102075681079699,
  0.108828083651577, 0.147606315408737, 0.0839489440523298, 0.396978429618175,
  0.43980785099197, 0.295741952968536, 0.24866910935347, 0.0442467487809289,
  0.335596563093868, 0.233228866477628, 0.133393318755783, 0.284416207171384,
  0.29140518658153, 0.234880226397143, 0.457838300826364, 0.085230830081924,
  0.423792672995716, 0.290795292528064, 0.0475246191577339, 0.182186335835526,
  0.0688766646362923, 0.219799288309372, 0.177225736452385, 0.214875117617374,
  0.148250107443774, 0.205771584644564, 0.137090663919187, 0.356839693410918,
  0.0735180962587929, 0.264633845299221, 0.205826996579185, 0.425245070405229,
  0.633954688139198, 0.29016632329167, 0.0765409371741137, 0.134470496708206,
  0.100724087501366, 0.355784892571077, 0.78477762599775, 0.230576639362723,
  0.302412966289922, 0.504181632055426, 0.309466340699462, 0.191066673047739,
  0.08004651339456, 0.288757012835596, 0.285042629519114, 0.112755987625244,
  0.267087791856027, 0.0508230077902539, 0.345929716560103, 0.637125966042463,
  0.180899944820286, 0.215332187714617, 0.251182879706532, 0.319201486399136,
  0.367696438151064, 0.180788629752681, 0.13849551153464, 0.666105739245672,
  0.244973476068862, 0.111196694120228, 0.294620201386095, 0.227131143776411,
  0.0729252481424116, 0.133122735769919, 0.492318629494797, 0.24576521392074,
  0.115089280792056, 0.310689889215603, 0.135301319268956, 0.367358683333803,
  0.219365120052191, 0.221021672619675, 0.279014472009185, 0.139560855135115,
  0.424644897533196, 0.381278983854846, 0.134110214153216, 0.0428133011354741,
  0.245011035601121, 0.102771641756052, 0.248637079011597, 0.173037250737929,
  0.345878030376164, 0.214376464837771, 0.189603551924222, 0.326773800666793,
  0.524773362585224, 0.264061093723736, 0.306529390368926, 0.391848286436733,
  0.168395429160241, 0.0758089753003229, 0.114146280894431, 0.226801443836648,
  0.0554744498338692, 0.228945339608141, 0.342728148402927, 0.193992218315681,
  0.138015739480982, 0.18904233547156, 0.265549405496245, 0.20662261872852,
  0.194439085207122, 0.117931050755386, 0.172984547683882, 0.252764307026127,
  0.311889340153156, 0.168566354554529, 0.557329086228746, 0.182674721644917,
  0.673084666967589, 0.624187398889372, 0.152907852484893, 0.24314427234538,
  0.371549977832408, 0.457162672888384, 0.282009360894751, 0.332935058258114,
  0.251857551463725, 0.0977398147049661, 0.211409042482686, 0.364224634090945,
  0.104513312355488, 0.300544245312882, 0.178321376256338, 0.517639890333677,
  0.493602740959582, 0.280036333329485, 0.230387868264402, 0.113566308691069,
  0.220093592507994, 0.119667102465718, 0.11504603472064, 0.229525065523036,
  0.31490482762451, 0.345816848192173, 0.17096777786469, 0.219064212708181,
  0.229432146138801, 0.177657689259584, 0.247591407305576, 0.13337884626296,
  0.458063906787344, 0.331114877414042, 0.240317861817291, 0.339960357056532,
  0.545767518637878, 0.18725793569201, 0.119496763903982, 0.423091807446278,
  0.11523136494277, 0.567143061660015, 0.0891710608000222, 0.126508591439415,
  0.0777685654120489, 0.0907845300095188, 0.344395477361394, 0.281451720758527,
  0.180428587976545, 0.196907760642303, 0.220040922678855, 0.18707271401047,
  0.182398239854685, 0.126366363019106, 0.127072044570986, 0.172802094924319,
  0.146227698004899, 0.270492016607713, 0.0902702916258461, 0.502518911445529,
  0.0676751103009319, 0.174024819716251, 0.308818261209151, 0.720883857145448,
  0.111559122767685, 0.0450180696736589, 0.108568911367224, 0.470875767358886,
  0.120426625869443, 0.204232430446914, 0.138865217691712, 0.135456499730774,
  0.366848267494218, 0.159522697795129, 0.381985464346371, 0.254248924083192,
  0.094714786389224, 0.230247225223519, 0.166588055419856, 0.287335240403618,
  0.162134781793027, 0.391957439202835, 0.425879768542346, 0.196206290267708,
  0.317084891801645, 0.456955210437812, 0.227279079030685, 0.567114834015989,
  0.253224670964436, 0.18681936028823, 0.423220227345402, 0.248464785400088,
  0.201387616631655, 0.120694316639532, 0.140721846805348, 0.298664156805977,
  0.118560054851627, 0.423414884105196, 0.178188532292091, 0.504044273527292,
  0.0928328546386995, 0.119023537478376, 0.259594679855513, 0.375101334709114,
  0.262973025792769, 0.265419326918385, 0.326828524935383, 0.357610671217977,
  0.556851012318009, 0.171489828167945, 0.136095745834668, 0.22518089606037,
  0.408152792552408, 0.383670915938559, 0.104731963250329, 0.143014711003034,
  0.0476981310349838, 0.258729119158675, 0.380102789485347, 0.14472919311365,
  0.718453981152899, 0.165336894691386, 0.0784445051363759, 0.611740908630542,
  0.912177598332412, 0.464479408377262, 0.109967038248552, 0.165658032796299,
  0.121427484106928, 0.0928550504394927, 0.212826832597724, 0.404399132293809,
  0.126417316843584, 0.157765691677212, 0.369384153812414, 0.521978834903081,
  0.154751049304921, 0.251605045918669, 0.284407175159018, 0.318607285045871,
  0.111213222563865, 0.252128130407287, 0.345903918225985, 0.109280653842136,
  0.143847886800702, 0.330733738533509, 0.377762701210803, 0.121453040985855,
  0.202692601806098, 0.281466696597781, 0.101343152808714, 0.450332864930032,
  0.124563381546268, 0.112092856459778, 0.425380247881575, 0.126548528805419,
  0.236580582063558, 0.236325531509843, 0.304212906081115, 0.0801580611894228,
  0.204146574563675, 0.231019143393011, 0.351515216109353, 0.174190620461814,
  0.814877562045752, 0.353645115693258, 0.210299704669149, 0.221153575860223,
  0.138088567056913, 0.28978188036918, 0.50890588304673, 0.650501358452738,
  0.219194824192814, 0.276256919205932, 0.50908595568707, 0.0979887580940381,
  0.18998502020697, 0.0637587448327273, 0.0969295104799318, 0.254525307568576,
  0.51845894627634, 0.120735739814527, 0.405061713304344, 0.336803522747783,
  0.584181858093491, 0.190468074103071, 0.231992189839932, 0.142280682213972,
  0.348950079387825, 0.170358991454347, 0.279693934268447, 0.348029313296706,
  0.545545513510235, 0.243349595659853, 0.350281419395326, 0.296985588279843,
  0.643622447364597, 0.320860151619112, 0.160253214280881, 0.1508066959225,
  0.231021668624016, 0.279374764846501, 0.31400745516935, 0.279273329324567,
  0.15498778125385, 0.584547033865361, 0.342763983153863, 0.636696254190685,
  0.05015647932367, 0.239823593553613, 0.355351462380841, 0.573770188830531,
  0.223127982833766, 0.785711179572969, 0.209701287034622, 0.210112568704491,
  0.158257013822331, 0.436189581817938, 0.315954854234834, 0.232897292344854,
  0.294608897329287, 0.615220298063564, 0.0798398787888387, 0.286971038872373,
  0.16350758114904, 0.0750407965009879, 0.0485962060697613, 0.0690300636435896,
  0.239074133082004, 0.144252290346907, 0.067693050795437, 0.280545929555769,
  0.184016806927258, 0.283375359624723, 0.310925424853714, 0.120250597747177,
  0.266957296717525, 0.226975845196336, 0.224886506991441, 0.169581533599969,
  0.111597281384711, 0.163398468442692, 0.162423294288742, 0.418989849063349,
  0.114611583738079, 0.292032825554381, 0.154760883524282, 0.217141003768901,
  0.395126223151355, 0.296424948072875, 0.629432942351849, 0.181908635269365,
  0.452722894349088, 0.382664272148636, 0.134777282861283, 0.124089981363944,
  0.331665821232587, 0.113047411497392, 0.299552685994648, 0.271382957280138,
  0.304954289409157, 0.22721015138244, 0.361136673483373, 0.126169860556222,
  0.377658827497434, 0.220170293768653, 0.390515749919441, 0.189690696406203,
  0.519981267904706, 0.235513855074397, 0.0845486794285862, 0.0969166416751591,
  0.324086044707592, 0.348557069925494, 0.262413234517427, 0.23175948330358,
  0.466947456552209, 0.128866735172348, 0.0616271482554991, 0.258323207884626,
  0.542839200645912, 0.058406201176512, 0.215105713022866, 0.624748145169947,
  0.138402901620757, 0.169525642838603, 0.143032134061664, 0.444679282133824,
  0.615751463794729, 0.229693322637031, 0.0822145751538435, 0.147834189809372,
  0.178518767811984, 0.221717023407101, 0.0709843360645516, 0.29724801913432,
  0.289392745445476, 0.140585770763766, 0.657573005244883, 0.0825933523338267,
  0.0715372352430233, 0.323724812496346, 0.201275279361481, 0.308614782631764,
  0.209998741679632, 0.201107859977105, 0.255274522152144, 0.217312896669091,
  0.420375624106633, 0.087648996270793, 0.151800671743135, 0.127305258187266,
  0.142264890340562, 0.17417979748019, 0.0580195610175976, 0.256710900520631,
  0.222426161798108, 0.311576941824746, 0.418074844590349, 0.240369035374872,
  0.125361592645728, 0.111023545255329, 0.702430496175696, 0.0690710878252083,
  0.185383117920694, 0.132795642406174, 0.557215452673378, 0.285557942364516,
  0.124170115508712, 0.372030345096051, 0.507465408595058, 0.231885637961333,
  0.612634041507435, 0.139706874521024, 0.318352695274182, 0.188436039270042,
  0.234290599475208, 0.297220206461951, 0.071830992754425, 0.297902510404828,
  0.175189877974991, 0.654707241457483, 0.477258317417024, 0.293177321469336,
  0.570860765871392, 0.359681340713301, 0.396996931602666, 0.697948080310041,
  0.109479566557457, 0.244799820900717, 0.299778673185938, 0.0487024469953363,
  0.262850731139505, 0.138952267380177, 0.174674328729801, 0.328618549853212,
  0.485499235095506, 0.187913921009126, 0.438857976376059, 0.270420914765502,
  0.0855486624031753, 0.648412717417428, 0.838869560204062, 0.449010614269554,
  0.221363105596618, 0.0860036234545779, 0.120394002378899, 0.118682606301835,
  0.63508573820785, 0.160960523817172, 0.169875538855222, 0.422473360479948,
  0.173203189798299, 0.285167034273881, 0.215195919050333, 0.274774928233058,
  0.514555073956436, 0.253501705365588, 0.171016423143388, 0.369144654392305,
  0.222382982483146, 0.451027983870031, 0.100913105645068, 0.304471404004755,
  0.10965563819372, 0.267387494181161, 0.153855148321972, 0.146859317471395,
  0.148778676169523, 0.61956144411004, 0.189677441068301, 0.430700047287254,
  0.32021154174605, 0.162974129256453, 0.293413792319349, 0.107414721911782,
  0.350230264869497, 0.153186646043968, 0.19893933284385, 0.147232195102582,
  0.296989333527736, 0.13715816856258, 0.358905915475065, 0.285181545213493,
  0.412204271397783, 0.142089549431999, 0.236716363272825, 0.0703254267506453,
  0.154591815201403, 0.325150299669489, 0.176268556976388, 0.118569981426028,
  0.147132153670715, 0.539323196663292, 0.355076222723428, 0.461206648795527,
  0.174469758245712, 0.0843730206147395, 0.125956792215714, 0.121215549437958,
  0.532290374083946, 0.249540776278706, 0.305123556449776, 0.150673881843796,
  0.377530685179863, 0.39412347699194, 0.436525439368889, 0.225274149044514,
  0.505685612096658, 0.620584209626098, 0.303032575232488, 0.119435566594942,
  0.112197829772527, 0.0525979871942044, 0.442143525610368, 0.285865020384619,
  0.241837202024935, 0.0941431140229676, 0.25278588958329, 0.186072338413129,
  0.351130707667262, 0.226380044606795, 0.267404896298202, 0.610923170369696,
  0.725686141041682, 0.354000865177541, 0.0560990367506745, 0.158436202360432,
  0.108318777770328, 0.241363402932961, 0.429842981615107, 0.175817533332519,
  0.11566898332159, 0.391069334496984, 0.146246096044954, 0.337895058955494,
  0.173537407807111, 0.312436050789244, 0.235494042162135, 0.297678085755894,
  0.302747418472046, 0.321192560265907, 0.101314513176992, 0.116039628613161,
  0.303662538896907, 0.264387171887471, 0.335261815197669, 0.0755184359619597,
  0.168577118408759, 0.176149274611514, 0.159816162807762, 0.141942717048688,
  0.400533047705648, 0.127738038843647, 0.285526112871438, 0.107198185601371,
  0.0572369142933554, 0.105267948110871, 0.275949873828106, 0.248462304478657,
  0.334316362030269, 0.394276032927191, 0.449978580455414, 0.2579555063127,
  0.204824520541278, 0.393099682855916, 0.168648473463119, 0.34927194311687,
  0.156102796688728, 0.206557478340267, 0.47504212178275, 0.226393310936648,
  0.191174062432927, 0.19705553597681, 0.473385388382145, 0.104984423496112,
  0.522257138787053, 0.411527712681517, 0.184129964527809, 0.357985893460918,
  0.364194792554298, 0.0757523194544029, 0.174565073197502, 0.0902257247099621,
  0.0922292971313665, 0.261377840416207, 0.152250794843271, 0.120702348940171,
  0.181697640519982, 0.281610547195666, 0.287445008206331, 0.5267242986294,
  0.254035885264192, 0.127926976813978, 0.172017601494405, 0.105716352187641,
  0.130102362346087, 0.260950424674615, 0.19650617504737, 0.0664339348821719,
  0.815631748325153, 0.42407285339097, 0.34034498756634, 0.309930936229356,
  0.104926352352826, 0.12658534941717, 0.255515046920552, 0.239294442622875,
  0.0865419740506275, 0.092266472497849, 0.115059265485398, 0.347761855026358,
  0.28210583380515, 0.181142018819598, 0.132488473471878, 0.0821519884243012,
  0.279276503946708, 0.290563013381076, 0.127834596817461, 0.159068134406134,
  0.379521130026644, 0.502639011954134, 0.300510562692437, 0.135090574892674,
  0.340760126620218, 0.103745872061795, 0.127315789174575, 0.292261827360981,
  0.101910951053894, 0.348789259173291, 0.339207306524169, 0.0928991162988196,
  0.358833324875859, 0.281506688390931, 0.532774354070636, 0.281629525520365,
  0.183864698200219, 0.216649178161699, 0.337712301345453, 0.156700193411385,
  0.198374056478376, 0.305451372683529, 0.243401935182214, 0.237820440475367,
  0.32026100096174, 0.198840316553327, 0.119271497501509, 0.22331091109776,
  0.406513396094375, 0.121734709272293, 0.0743972642919846, 0.269841916361065,
  0.143863136673019, 0.344548796992196, 0.133540108055078, 0.079403445790349,
  0.162137277192976, 0.13802202018862, 0.641849841768124, 0.346368292853377,
  0.0419525680443117, 0.195334946895342, 0.174118342530751, 0.140146623805919,
  0.0899798830714312, 0.543309450792905, 0.350868426310713, 0.234203340780022,
  0.150987765033013, 0.0449127171428266, 0.426171140131942, 0.212956007529075,
  0.173140932181942, 0.388528843731156, 0.411700494339809, 0.360852107424865,
  0.677437077077209, 0.129124531841599, 0.485777661069395, 0.214418692873272,
  0.0367680037231833, 0.270940736528927, 0.111282279885975, 0.254402885036924,
  0.412086863967275, 0.261486300301775, 0.112992402134822, 0.217415575335818,
  0.263899403822795, 0.492091383575506, 0.160333133623573, 0.555550059725115,
  0.271797421838451, 0.287951535605681, 0.779343346762836, 0.198024724332675,
  0.112333318740878, 0.132785048703535, 0.149208328248682, 0.213232588237041,
  0.600394124266786, 0.112901248239545, 0.379095524707108, 0.472501752106831,
  0.36519788816736, 0.208322631229373, 0.174226568871523, 0.276941662338997,
  0.193807596479496, 0.0756537338987975, 0.211878900549542, 0.0498604930687596,
  0.329123068346691, 0.854993866193754, 0.138267098092464, 0.201430240212591,
  0.290319016093569, 0.232618612625421, 0.33083096939225, 0.243586764586197,
  0.143017571733691, 0.522103310612113, 0.58180932479869, 0.0982602847558484,
  0.279965108930672, 0.2526109147122, 0.170442430545698, 0.162031271883877,
  0.386062232858745, 0.265084202085827, 0.149932812843308, 0.26432054427694,
  0.0829262803022999, 0.490593160544828, 0.298680627057558, 0.286990891645896,
  0.274319597159926, 0.169310902470812, 0.584325607834787, 0.298302623703898,
  0.16073660908608, 0.0255553485245158, 0.156644447335698, 0.0898110419885936,
  0.116018905612586, 0.140141436671232, 0.565546654051041, 0.417733515181013,
  0.659829552730041, 0.173245109889666, 0.561332136817786, 0.320687824003421,
  0.202055215652473, 0.223721849633478, 0.206559922055821, 0.0676041242583574,
  0.164649105937665, 0.248536202819302, 0.0555537547806063, 0.166112040320501,
  0.270230534179355, 0.180235166818194, 0.114266172381057, 0.144559184414296,
  0.153046411475667, 0.332637402632814, 0.270953492788695, 0.096611398087746,
  0.421057646111155, 0.144867726140537, 0.319909732935835, 0.262108492177101,
  0.526614501883368, 0.179423781596603, 0.743406050632938, 0.739492760801808,
  0.19112158157967, 0.21048913109302, 0.400061277095777, 0.460558791532196,
  0.16657608911255, 0.273270671368763, 0.36677399350004, 0.142048199104452,
  0.246963093379277, 0.284543249616175, 0.093460918407779, 0.421468100399401,
  0.214318598454498, 0.577644240354503, 0.610901375200469, 0.349073750502545,
  0.150191823202789, 0.212135557786999, 0.324668276467657, 0.111224227409777,
  0.0963831057472194, 0.329680259125305, 0.222772522180276, 0.28734741423739,
  0.16712218109497, 0.387633622796812, 0.315482944379966, 0.0809817252092881,
  0.215971497761129, 0.136087178137874, 0.173279186446516, 0.522777644039318,
  0.221957417106975, 0.175782626129694, 0.269692993661859, 0.191543446902164,
  0.0786940356409682, 0.373342905845094, 0.277822304758925, 0.800703398859232,
  0.128923247924784, 0.214074958598684, 0.146695114415805, 0.0790430491726119,
  0.251397758637001, 0.259979530033387, 0.141267438976769, 0.109510890454968,
  0.183606964961467, 0.268358957677131, 0.228116142138638, 0.166303086398731,
  0.136106438917456, 0.182525014916925, 0.157795008256408, 0.243311751633195,
  0.129686251404307, 0.287408486589772, 0.0945985387159668, 0.185532265698869,
  0.195925640158261, 0.414986265212218, 0.163918866826333, 0.0685928064570908,
  0.058207138168702, 0.568763986485366, 0.0578214743073369, 0.124401521898412,
  0.212011635435856, 0.257491749673343, 0.368711455954124, 0.151703373890402,
  0.23613261896099, 0.244468476574183, 0.0998659723754629, 0.235354282672145,
  0.155990636120692, 0.322691635638864, 0.407251720419318, 0.345618731501226,
  0.32378356067842, 0.223280644572839, 0.496939145771972, 0.359549547749266,
  0.380149829625672, 0.406478967532758, 0.424486183198858, 0.295972669281249,
  0.124627566482217, 0.217727608532779, 0.399165350588412, 0.151832431798249,
  0.149208519412964, 0.365924369283274, 0.13585195655344, 0.443699647595179,
  0.234258985626196, 0.356869918975696, 0.0495697635014182, 0.13656187156207,
  0.358098378005625, 0.241187432637382, 0.221589294762502, 0.340627259915204,
  0.188905662401661, 0.172354288080389, 0.650032130395832, 0.142563012137752,
  0.147229329948355, 0.11759335925056, 0.341114517803806, 0.463660707488231,
  0.1657986045285, 0.196559111668603, 0.101434866183027, 0.286540265809398,
  0.202563906713152, 0.0648204850380626, 0.713149870633657, 0.081455705553167,
  0.110810050233884, 0.595752147972781, 0.946346479914499, 0.39702193017459,
  0.118404470144631, 0.128137479154425, 0.101636870458552, 0.142991036146998,
  0.293533077151678, 0.348090630605658, 0.149363997697624, 0.278781632548942,
  0.304363134620675, 0.482169438996801, 0.142679209438114, 0.180746153042597,
  0.230495980079259, 0.201538457652378, 0.126269686594111, 0.243426845986725,
  0.513314066905782, 0.121557020322771, 0.195292590795141, 0.175574121493912,
  0.383922707121505, 0.279603149195503, 0.228294965576653, 0.227981817328736,
  0.0941998460649045, 0.513454377910747, 0.206765335271172, 0.0984385583701289,
  0.465765520960247, 0.125510811805571, 0.260221006635011, 0.143562709641588,
  0.323561064611268, 0.12071185005964, 0.336542550498673, 0.192375331621498,
  0.607692112114681, 0.151145192279557, 0.548661844794151, 0.284198008623012,
  0.179411958249566, 0.172557113175563, 0.182359779361263, 0.0679873085809483,
  0.350053688249724, 0.399557873236557, 0.34545735867605, 0.39614826129246,
  0.373651554065292, 0.0844085533400874, 0.130931711351755, 0.0636110024457409,
  0.25328447039861, 0.344605514086772, 0.414592065858745, 0.0751012674186698,
  0.240153051822173, 0.246688574559708, 0.403209791966714, 0.145197172757454,
  0.246786346271312, 0.230042495693672, 0.443448932435214, 0.16097054249035,
  0.154849544117823, 0.37540952920205, 0.306932365869988, 0.239084953157525,
  0.27822691308208, 0.196832171735941, 0.46813757857496, 0.308347767449057,
  0.122464703018403, 0.215685392505511, 0.271138411977688, 0.344714480118858,
  0.377007581787051, 0.353065426047005, 0.258333875376607, 0.66251612193555,
  0.235371967955554, 0.831532238857172, 0.228744857017488, 0.262684411699238,
  0.571667999697416, 0.399060193182111, 0.402090885296922, 0.727758901037159,
  0.223072220503534, 0.160639731700679, 0.24838880763586, 0.287939760236807,
  0.363277193442347, 0.315610244994608, 0.31034236106603, 0.520694988946231,
  0.108677504004796, 0.22672935108635, 0.403228726647555, 0.0463153904677519,
  0.0688874596902513, 0.0745408558684253, 0.123893127420134, 0.113650001434341,
  0.057445368364428, 0.272675681565674, 0.232113622572551, 0.386551725243867,
  0.231614081840363, 0.0613814710233969, 0.504968797933226, 0.180213204740256,
  0.13132850282909, 0.218986453464104, 0.225388007022921, 0.0906724509167993,
  0.146836559838841, 0.283400487843917, 0.0928752222396047, 0.261592699494964,
  0.0782197490322401, 0.146277823868774, 0.369471157008938, 0.208561909201513,
  0.432421849658763, 0.279527482410434, 0.477705939748113, 0.364000818602448,
  0.0673076535451444, 0.190393815976152, 0.331460413617761, 0.0869883592818242,
  0.213552880100067, 0.318024145837896, 0.279559628523956, 0.230962608394488,
  0.398398494913823, 0.148984252338289, 0.368879032811522, 0.305728213776419,
  0.300089341657284, 0.287659160038267, 0.336168371092073, 0.371334682388303,
  0.071849954921748, 0.094854924007952, 0.391990706336242, 0.256786510259797,
  0.17723086166837, 0.546674667230998, 0.535956949989709, 0.110209124943736,
  0.0864422188034832, 0.245652518918746, 0.669217300769759, 0.0876989725518047,
  0.230713854577945, 0.318739397492744, 0.0900362283304399, 0.107411235701111,
  0.267569444099303, 0.367032825534198, 0.326343910622406, 0.374045126727724,
  0.0567889636790336, 0.272200945621812, 0.173469369324679, 0.226466348302605,
  0.16342340226568, 0.242412337519681, 0.579263429707889, 0.165488328937577,
  0.561064885585334, 0.219103669891417, 0.112022793032566, 0.306640668057556,
  0.246980163191118, 0.368519939491224, 0.140858102999342, 0.282244281787563,
  0.208994209136405, 0.12757020338758, 0.201776952659701, 0.210873208430427,
  0.218040675611666, 0.195850289819497, 0.0985026768560458, 0.182222811085712,
  0.0787388045014663, 0.066145688396152, 0.295972669281249, 0.197109881614048,
  0.571633682860124, 0.235765911938788, 0.253321557990058, 0.0844299078005263,
  0.367527544586684, 0.150305632302774, 0.247745707900693, 0.250636052364929,
  0.683834978974092, 0.282071966807701, 0.129851607524542, 0.388854252279865,
  0.437753708288446, 0.294358418772466, 0.507021603410669, 0.458206439015258,
  0.314719111065036, 0.101825250937328, 0.272630197993144, 0.294919054703382,
  0.115630110092691, 0.424508706866446, 0.106143419476193, 0.524977267821378,
  0.244051462843824, 0.27452422037035, 0.403309852102364, 0.338619253308163,
  0.335394729389054, 0.447619879512788, 0.225321515774822, 0.238078242944384,
  0.210319648083009), .Dim = c(694L, 2L), .Dimnames = list(c("1",
    "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13",
    "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24",
    "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35",
    "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46",
    "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57",
    "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68",
    "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79",
    "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90",
    "91", "92", "93", "94", "95", "96", "97", "98", "99", "100",
    "101", "102", "103", "104", "105", "106", "107", "108", "109",
    "110", "111", "112", "113", "114", "115", "116", "117", "118",
    "119", "120", "121", "122", "123", "124", "125", "126", "127",
    "128", "129", "130", "131", "132", "133", "134", "135", "136",
    "137", "138", "139", "140", "141", "142", "143", "144", "145",
    "146", "147", "148", "149", "150", "151", "152", "153", "154",
    "155", "156", "157", "158", "159", "160", "161", "162", "163",
    "164", "165", "166", "167", "168", "169", "170", "171", "172",
    "173", "174", "175", "176", "177", "178", "179", "180", "181",
    "182", "183", "184", "185", "186", "187", "188", "189", "190",
    "191", "192", "193", "194", "195", "196", "197", "198", "199",
    "200", "201", "202", "203", "204", "205", "206", "207", "208",
    "209", "210", "211", "212", "213", "214", "215", "216", "217",
    "218", "219", "220", "221", "222", "223", "224", "225", "226",
    "227", "228", "229", "230", "231", "232", "233", "234", "235",
    "236", "237", "238", "239", "240", "241", "242", "243", "244",
    "245", "246", "247", "248", "249", "250", "251", "252", "253",
    "254", "255", "256", "257", "258", "259", "260", "261", "262",
    "263", "264", "265", "266", "267", "268", "269", "270", "271",
    "272", "273", "274", "275", "276", "277", "278", "279", "280",
    "281", "282", "283", "284", "285", "286", "287", "288", "289",
    "290", "291", "292", "293", "294", "295", "296", "297", "298",
    "299", "300", "301", "302", "303", "304", "305", "306", "307",
    "308", "309", "310", "311", "312", "313", "314", "315", "316",
    "317", "318", "319", "320", "321", "322", "323", "324", "325",
    "326", "327", "328", "329", "330", "331", "332", "333", "334",
    "335", "336", "337", "338", "339", "340", "341", "342", "343",
    "344", "345", "346", "347", "348", "349", "350", "351", "352",
    "353", "354", "355", "356", "357", "358", "359", "360", "361",
    "362", "363", "364", "365", "366", "367", "368", "369", "370",
    "371", "372", "373", "374", "375", "376", "377", "378", "379",
    "380", "381", "382", "383", "384", "385", "386", "387", "388",
    "389", "390", "391", "392", "393", "394", "395", "396", "397",
    "398", "399", "400", "401", "402", "403", "404", "405", "406",
    "407", "408", "409", "410", "411", "412", "413", "414", "415",
    "416", "417", "418", "419", "420", "421", "422", "423", "424",
    "425", "426", "427", "428", "429", "430", "431", "432", "433",
    "434", "435", "436", "437", "438", "439", "440", "441", "442",
    "443", "444", "445", "446", "447", "448", "449", "450", "451",
    "452", "453", "454", "455", "456", "457", "458", "459", "460",
    "461", "462", "463", "464", "465", "466", "467", "468", "469",
    "470", "471", "472", "473", "474", "475", "476", "477", "478",
    "479", "480", "481", "482", "483", "484", "485", "486", "487",
    "488", "489", "490", "491", "492", "493", "494", "495", "496",
    "497", "498", "499", "500", "501", "502", "503", "504", "505",
    "506", "507", "508", "509", "510", "511", "512", "513", "514",
    "515", "516", "517", "518", "519", "520", "521", "522", "523",
    "524", "525", "526", "527", "528", "529", "530", "531", "532",
    "533", "534", "535", "536", "537", "538", "539", "540", "541",
    "542", "543", "544", "545", "546", "547", "548", "549", "550",
    "551", "552", "553", "554", "555", "556", "557", "558", "559",
    "560", "561", "562", "563", "564", "565", "566", "567", "568",
    "569", "570", "571", "572", "573", "574", "575", "576", "577",
    "578", "579", "580", "581", "582", "583", "584", "585", "586",
    "587", "588", "589", "590", "591", "592", "593", "594", "595",
    "596", "597", "598", "599", "600", "601", "602", "603", "604",
    "605", "606", "607", "608", "609", "610", "611", "612", "613",
    "614", "615", "616", "617", "618", "619", "620", "621", "622",
    "623", "624", "625", "626", "627", "628", "629", "630", "631",
    "632", "633", "634", "635", "636", "637", "638", "639", "640",
    "641", "642", "643", "644", "645", "646", "647", "648", "649",
    "650", "651", "652", "653", "654", "655", "656", "657", "658",
    "659", "660", "661", "662", "663", "664", "665", "666", "667",
    "668", "669", "670", "671", "672", "673", "674", "675", "676",
    "677", "678", "679", "680", "681", "682", "683", "684", "685",
    "686", "687", "688", "689", "690", "691", "692", "693", "694"
  ), NULL))


seeds <- c(7350, 5880, 2571, 3887, 9745, 5608, 3468, 2711, 3448, 4676,
  1627, 5087, 6479, 3901, 1037, 6622, 4832, 3382, 8515, 268, 3210,
  5944, 3380, 3646, 9188, 2750, 7987, 466, 2981, 136, 5134, 8476,
  5618, 8948, 1590, 5281, 2551, 2052, 1444, 8688, 1691, 6398, 4728,
  8267, 5274, 4154, 982, 7540, 3081, 5286, 6405, 1238, 5589, 8221,
  6026, 1922, 7651, 3100, 4341, 2134, 9685, 4524, 9750, 7618, 8211,
  2438, 824, 6982, 6548, 9743, 4302, 9038, 185, 4418, 1306, 6643,
  9865, 3436, 6151, 9647, 4261, 8109, 7573, 127, 571, 4545, 7245,
  4764, 5038, 9037, 6085, 1459, 5124, 9463, 942, 2241, 6492, 3190,
  8229, 7099)
seed <- as.vector(matrix(seeds,ncol=1))
set.seed(54321)
# code shown how preds is generated
# output<-mipred.cv(Status~age10+perfstat+remstat+cyto+asct+donor+sex_match+cond,family=binomial(link="logit"),data=cll_bin[1:694,-1], nimp=2, folds=2, mice.options=list(maxit=2, seed=seed))
# now try replicate using dot notation
output<-mipred.cv(Status~.,family=binomial(link="logit"),data=cll_bin[1:694,-1], nimp=2, folds=2, mice.options=list(maxit=2, seed=seed))

test_that("predictions replicate from saved results generated with full formula when using dot notation for averaging approach in mipred.cv",{
  expect_equal(output$pred,preds)
})

# based on: nimp=2, folds=2, mice.options=list(maxit=2, seed=seed) and seeds as below
# check for rubin method
preds <- structure(c(0.112516236188612, 0.268729786968734, 0.229765573394903,
  0.123467553114857, 0.526660968626616, 0.316647944272368, 0.248045102969626,
  0.443563798460693, 0.239073489349524, 0.075790993993578, 0.556186320307558,
  0.644400737976303, 0.331901957618878, 0.256481033938746, 0.207746057428202,
  0.0883205037326528, 0.0836283671188999, 0.72374834964979, 0.123852768385256,
  0.171095232694986, 0.371179212762646, 0.169529079592908, 0.148641121251324,
  0.246124527159818, 0.204831978107602, 0.371469661868614, 0.29895072995226,
  0.24003539843697, 0.301911938764166, 0.268176132818944, 0.402730012515681,
  0.123203217690244, 0.175382813522824, 0.243787202935133, 0.154570743743053,
  0.11513382871577, 0.0892703602703067, 0.173503228668694, 0.586906287013078,
  0.190188017537089, 0.231439863206969, 0.148145045386993, 0.263867554763507,
  0.194147412810803, 0.0641298855195087, 0.274965081474535, 0.330360829599618,
  0.22228089900444, 0.196687309685874, 0.21355851029492, 0.253772310545182,
  0.552973717230694, 0.839524183217672, 0.248151740895107, 0.0799917039906281,
  0.292619523421717, 0.102061667471168, 0.116300739823087, 0.487271526250492,
  0.165294657729144, 0.0741457637995324, 0.132731037822674, 0.450259780331514,
  0.227589951441161, 0.415504677877886, 0.21841250553427, 0.245517243280248,
  0.267346300124381, 0.189617995152404, 0.15730277285272, 0.283507950836482,
  0.203256123932201, 0.101925471793757, 0.337603012030191, 0.306444145137839,
  0.322285342284345, 0.336062485191841, 0.884395859363546, 0.516983512562526,
  0.286248918825726, 0.0977350374316844, 0.111323613619882, 0.11037526042358,
  0.329995384151483, 0.188174243208545, 0.162051400659548, 0.128070231774751,
  0.347882605778437, 0.0921476034032863, 0.304594466552665, 0.149887438525528,
  0.216660507950277, 0.409577205955607, 0.227848593428249, 0.650247908088443,
  0.051437993418339, 0.139156836261922, 0.170901661442288, 0.20089854551342,
  0.628408478031471, 0.337719571874079, 0.0795358916256249, 0.54872462681998,
  0.112180332275013, 0.273454817692222, 0.213289145128453, 0.392271365686654,
  0.280456711214445, 0.192620593530291, 0.19103103729081, 0.1406732498904,
  0.0515938072536092, 0.0992236521220728, 0.297100582057062, 0.521855848286837,
  0.433083027837868, 0.149056845921899, 0.462806532181737, 0.308548605313264,
  0.179559883501593, 0.330925575740609, 0.219610123139958, 0.15879872770383,
  0.166895012300544, 0.121100499363444, 0.0772859235710661, 0.131860935844565,
  0.278070387872065, 0.21174300357043, 0.230132422760407, 0.326354232425632,
  0.370375111733958, 0.244755248962374, 0.126954461842776, 0.250371761861621,
  0.160219492798746, 0.231564519009254, 0.108545017286106, 0.1742806524866,
  0.516491510538509, 0.158205880878487, 0.29624527679747, 0.333596615741652,
  0.735711531383683, 0.228682172791014, 0.283636946264991, 0.523926223662838,
  0.0817930349482075, 0.355353636087258, 0.474565760327317, 0.107096478986007,
  0.198371964459408, 0.0626068163293693, 0.133606410695916, 0.318266704685804,
  0.150596295096059, 0.0952922359572668, 0.0921085213896791, 0.263785276551806,
  0.12465158729642, 0.557633890780449, 0.423992275157417, 0.238233511786778,
  0.11579783836653, 0.0636761955233425, 0.198019367085348, 0.22895634077193,
  0.269471034801686, 0.115986994435872, 0.803694979980046, 0.500143378133316,
  0.281386609351861, 0.331729922356322, 0.106677524215197, 0.272156575441057,
  0.204931195746242, 0.487782009319744, 0.140551843774873, 0.0616420415660063,
  0.252503544431739, 0.239510913524556, 0.307767356625899, 0.19121777178748,
  0.136762283339135, 0.157415476097511, 0.166864247519057, 0.133895671112361,
  0.0924450876046859, 0.32102858763536, 0.198895123946026, 0.527380390585718,
  0.585459540589679, 0.286672434945698, 0.505852630660537, 0.0821321454747653,
  0.181649432672358, 0.226487500756802, 0.147822753589431, 0.60158174893537,
  0.249533883109669, 0.263829435915395, 0.30709593026273, 0.139967519094007,
  0.42243543014036, 0.148522862226092, 0.0989773823239199, 0.116359333932108,
  0.463839925806043, 0.146782842329972, 0.267622375036728, 0.200363056364067,
  0.0857930601179574, 0.354460330559097, 0.231102616157033, 0.105913323480747,
  0.167158425717844, 0.178303701058023, 0.647966256774878, 0.124741103617379,
  0.232292520456271, 0.582934657835532, 0.127887054196021, 0.500799986958398,
  0.144106700014086, 0.0653016501695146, 0.151720165761754, 0.191985147537726,
  0.474596508907523, 0.254545759628035, 0.0763650291460135, 0.0415779169508906,
  0.105898133489484, 0.110183466703419, 0.109137695669127, 0.351594735987558,
  0.445828232051039, 0.189002510222596, 0.111066974140196, 0.0692409710447151,
  0.19031340965407, 0.258575911893777, 0.16675089027811, 0.282931007612389,
  0.228876648204738, 0.215928311370215, 0.423293992592713, 0.10015495383643,
  0.486496091019948, 0.337052467270748, 0.0571699897283551, 0.196677293947185,
  0.0927625753817313, 0.23717788867509, 0.206581860941913, 0.232189257685112,
  0.17568409275671, 0.284339636051452, 0.132429128154783, 0.32428200715764,
  0.0727979243370251, 0.237000421818326, 0.223728864510441, 0.373420309430876,
  0.660721085356123, 0.186863750505186, 0.091132421917107, 0.16580678654138,
  0.0913288672917396, 0.358202791896484, 0.801673150101103, 0.270463780334883,
  0.275575410882529, 0.511834470439226, 0.276829106009443, 0.178935709165406,
  0.0629845051086953, 0.296467111997119, 0.310813241871184, 0.0680707532238572,
  0.232492541797476, 0.0481822617476797, 0.423867968593386, 0.49365692565396,
  0.181202315668459, 0.561529634391357, 0.146844383988175, 0.392248045492012,
  0.323103499505407, 0.227478951627676, 0.113538103187433, 0.698995268580352,
  0.228061852040656, 0.0562052200744133, 0.278997780473528, 0.232584220044108,
  0.071237818425445, 0.203841300534297, 0.440749349043022, 0.302467959444009,
  0.145987578449451, 0.301612486577209, 0.13522783244574, 0.393858232834414,
  0.243014400924523, 0.190532298995412, 0.174201903130375, 0.157460385165891,
  0.436546378954301, 0.367697102815664, 0.151502862013241, 0.0511353950804288,
  0.236867879442464, 0.11295276423114, 0.295189817668446, 0.178573804972732,
  0.510465304323057, 0.201490070955628, 0.145143696925069, 0.32167765539439,
  0.524110663283354, 0.232266827394817, 0.328013022408512, 0.293712527336582,
  0.211508788090533, 0.0652301533116838, 0.111440953610875, 0.1387357635709,
  0.0742743722877095, 0.248372110342705, 0.315421215175118, 0.222695532719943,
  0.136071142522106, 0.18233424720613, 0.250645052698147, 0.374672699813666,
  0.112736302175182, 0.170273302109581, 0.368023528225431, 0.150567338296214,
  0.217661955698756, 0.167318983401564, 0.717328690714281, 0.167121180876574,
  0.646056030156436, 0.626022608416877, 0.154893111503759, 0.281114282804001,
  0.424111653814498, 0.43141697689482, 0.287103788312654, 0.293660813747509,
  0.215335276943176, 0.0900457197893125, 0.302105497336672, 0.402685473836314,
  0.144390793839118, 0.265994000074135, 0.155879545607843, 0.484200123795378,
  0.534680909274378, 0.389849315887292, 0.211587991920211, 0.110293428251396,
  0.190300641382238, 0.111328639513459, 0.107018210215805, 0.212592664659291,
  0.345709137496685, 0.349654322324745, 0.197355625608947, 0.216555102556539,
  0.19207816468319, 0.165487095550521, 0.242014589131367, 0.254935549287185,
  0.358189711667039, 0.284321125834299, 0.266078565513548, 0.312473094451968,
  0.535494604134233, 0.186301015388116, 0.104193277884679, 0.40816920551436,
  0.114518787849035, 0.456230552053034, 0.0812366919138023, 0.125802607443974,
  0.0748479651078767, 0.0985958498445323, 0.342635116755968, 0.308275450938105,
  0.207744472147645, 0.178899439953629, 0.20187611965575, 0.16458454203278,
  0.223628575981823, 0.10896076543035, 0.283505663228442, 0.15207002307647,
  0.120100329380833, 0.232293785200157, 0.0820104266502468, 0.569915722040811,
  0.0641967468580518, 0.0961920989024718, 0.332231256992119, 0.779756912195156,
  0.140796713130798, 0.0690189805781378, 0.0990481809626649, 0.411294165933223,
  0.0510308701366828, 0.175852301559115, 0.129647973591833, 0.174107105012571,
  0.160867391568342, 0.187466644505223, 0.350394544797665, 0.262167704886805,
  0.0881120683223164, 0.214777199326945, 0.154666597961513, 0.173236417067128,
  0.149490176049994, 0.347058983781692, 0.455667325246947, 0.235833538126638,
  0.297788964251613, 0.268779121953698, 0.242248195290756, 0.59405308088965,
  0.25135696005436, 0.171135905437018, 0.225881272216095, 0.227311242976418,
  0.173405157545255, 0.121349660070819, 0.1309505763681, 0.257585121593547,
  0.104871406076385, 0.445922466027239, 0.138425223965309, 0.354778760593099,
  0.101738670061933, 0.121169692688556, 0.229671360487009, 0.397907003984307,
  0.18638774363145, 0.214516272708446, 0.356950276707129, 0.396924565371843,
  0.545323331823296, 0.17168477799494, 0.127731555815848, 0.211116815135454,
  0.464564875582649, 0.336738406294208, 0.112258966096179, 0.120545083321058,
  0.0641527617905359, 0.25275940377204, 0.219192418537144, 0.148877271431529,
  0.666596222284862, 0.143850591547235, 0.075107576739202, 0.529828858680672,
  0.926182631405002, 0.4561467233398, 0.107680333522616, 0.187444174937931,
  0.0953297723022552, 0.174420650154519, 0.215225740212586, 0.372569378763346,
  0.153258717310835, 0.154056119571915, 0.339128760160127, 0.611301640228648,
  0.142663254709159, 0.283520767951581, 0.240311946533525, 0.333401466729235,
  0.129332569720283, 0.251619041068516, 0.319065275725201, 0.0984323703580657,
  0.132883564781241, 0.394841065808623, 0.378967495041443, 0.194103322039725,
  0.222317212264379, 0.316877936354251, 0.0904679210019801, 0.377922622806746,
  0.134447221323425, 0.0603240940379589, 0.591821152623729, 0.116530916224463,
  0.221975422387798, 0.1928709871634, 0.278780794668632, 0.0780863636286859,
  0.223509200764935, 0.210617074811263, 0.5688536857661, 0.173750059943887,
  0.753642994636191, 0.339588209585502, 0.192845016462929, 0.184653665183295,
  0.140361021063262, 0.258914349087863, 0.181272754370575, 0.577936567060824,
  0.199230497763062, 0.286606507281614, 0.517138488295141, 0.0923267986496501,
  0.200552739954884, 0.0727583894197602, 0.103201617918352, 0.233410922064624,
  0.436133308706401, 0.152054516832367, 0.462595750527968, 0.303707439480123,
  0.444411592108333, 0.158833665279712, 0.209483690113115, 0.150007011400914,
  0.535399882520869, 0.157384945690443, 0.263687539578082, 0.250372402921945,
  0.38742358371227, 0.253608161456461, 0.384684843039372, 0.358476311121773,
  0.673473449598278, 0.330426773741468, 0.15271050621903, 0.138226193993146,
  0.217486537506278, 0.222709744004075, 0.64746783699108, 0.30549310539986,
  0.254157995580281, 0.572865036858426, 0.206112256588373, 0.658330732439497,
  0.0850263228587371, 0.281576143560454, 0.565054060559363, 0.613750827056103,
  0.235974408925922, 0.823870351790048, 0.227056511235554, 0.179674175189532,
  0.158709267644306, 0.451963684530087, 0.356921477826286, 0.222119020624703,
  0.254266880006423, 0.653312352075134, 0.117775392233463, 0.322727368399823,
  0.150074658274539, 0.0641274094920296, 0.0589229160581964, 0.0917498435161754,
  0.191580426500388, 0.136160070279283, 0.067085170477643, 0.261285062784851,
  0.225607922433957, 0.274438431316578, 0.249506615540087, 0.109700223549661,
  0.304985085473018, 0.319452221636455, 0.215265872931467, 0.167686835774643,
  0.102503935863489, 0.169522333019384, 0.144601685444264, 0.399528640382457,
  0.130127484099828, 0.26814971063401, 0.17236970304124, 0.269411275366784,
  0.355877767624534, 0.491569504334774, 0.647993216419434, 0.158071831183367,
  0.306394635034829, 0.346394956284828, 0.14556237549644, 0.11649157807431,
  0.340985075481972, 0.090925594135918, 0.319568430889632, 0.244430096497871,
  0.354436990725822, 0.24080469611474, 0.435471830361624, 0.119060303387845,
  0.457166394866558, 0.23310444233737, 0.395136992134022, 0.313360782872604,
  0.51513350766401, 0.189054172235888, 0.0451937049153888, 0.134802702345713,
  0.293545411514895, 0.391758491552466, 0.13714062108195, 0.219536987773795,
  0.393593319996096, 0.132740570633474, 0.0540492168329556, 0.250178335919116,
  0.608343294640724, 0.0644514103157887, 0.232709209152671, 0.630982257947851,
  0.127830237201236, 0.105929833135589, 0.139773241886056, 0.469027674069095,
  0.681887060241992, 0.210839742833238, 0.086917707022965, 0.245069062733123,
  0.17443983347018, 0.269135170912751, 0.14271255832526, 0.320010071520905,
  0.301053718747215, 0.137280491861298, 0.65381470921346, 0.0569494151081259,
  0.0617933386453686, 0.250660428702629, 0.173398183543843, 0.301942109274266,
  0.247817288090198, 0.327994302105474, 0.264162806311564, 0.232051936834333,
  0.49179722968062, 0.0803662905573575, 0.127226841254906, 0.10996746376669,
  0.133947115539324, 0.181849842652262, 0.0603483171509145, 0.126948866624548,
  0.259047236724008, 0.304834253382922, 0.411652053971614, 0.234750894989931,
  0.132841218007169, 0.110989934932401, 0.474008493042585, 0.0952321613249919,
  0.169926300508719, 0.132982003459703, 0.56557304216225, 0.484882772531034,
  0.0628411551353598, 0.369690528702707, 0.541209530340721, 0.298594295956993,
  0.602723791106982, 0.395165192045409, 0.391134852683023, 0.229539087023776,
  0.202250463746677, 0.251959701176844, 0.0794635134524419, 0.315878264857548,
  0.169570771903896, 0.682302826550195, 0.467746325632325, 0.32260161357416,
  0.620710594713183, 0.356895956314686, 0.428584525492461, 0.681364575929945,
  0.188451077133416, 0.268914305170133, 0.307523966981175, 0.112516236188612,
  0.268729786968734, 0.229765573394903, 0.123467553114857, 0.304615472682978,
  0.316647944272368, 0.248045102969626, 0.443563798460693, 0.239073489349524,
  0.075790993993578, 0.724596164191908, 0.546243180064338, 0.277716381162065,
  0.141120195159352, 0.207746057428202, 0.0883205037326528, 0.0836283671188999,
  0.705582448644605, 0.123852768385256, 0.169693522775487, 0.371179212762646,
  0.169529079592908, 0.266959430414503, 0.246124527159818, 0.281418960239097,
  0.371469661868614, 0.29895072995226, 0.24003539843697, 0.294682045703718,
  0.14542346678045, 0.402730012515681, 0.123203217690244, 0.175382813522824,
  0.243787202935133, 0.154570743743053, 0.11513382871577, 0.106534697715712,
  0.0914508117751646, 0.586906287013078, 0.190188017537089, 0.314046388501619,
  0.148145045386993, 0.263867554763507, 0.194147412810803, 0.0641298855195087,
  0.441635343219122, 0.328170904969557, 0.22228089900444, 0.196687309685874,
  0.21355851029492, 0.253772310545182, 0.552973717230694, 0.57781557509298,
  0.194875312516723, 0.0799917039906281, 0.292619523421717, 0.102061667471168,
  0.116300739823087, 0.487271526250492, 0.165294657729144, 0.169029081072686,
  0.132731037822674, 0.450259780331514, 0.227589951441161, 0.415504677877886,
  0.21841250553427, 0.245517243280248, 0.148071696057107, 0.189617995152404,
  0.15730277285272, 0.283507950836482, 0.203256123932201, 0.145916096900561,
  0.27723791440162, 0.306444145137839, 0.322285342284345, 0.336062485191841,
  0.75074192421987, 0.194878346975954, 0.286248918825726, 0.0977350374316844,
  0.356471121721079, 0.0854013511886059, 0.329995384151483, 0.188174243208545,
  0.112848191728099, 0.128070231774751, 0.445382310007475, 0.0921476034032863,
  0.304594466552665, 0.149887438525528, 0.117089782292033, 0.662580923322035,
  0.233982722414595, 0.530385187541217, 0.051437993418339, 0.139156836261922,
  0.170901661442288, 0.20089854551342, 0.628408478031471, 0.337719571874079,
  0.10298770792773, 0.54872462681998, 0.112180332275013, 0.273454817692222,
  0.213289145128453, 0.392271365686654, 0.280456711214445, 0.513373508425122,
  0.329979746427479, 0.271791032749074, 0.0515938072536092, 0.0992236521220728,
  0.183522813145874, 0.521855848286837, 0.433083027837868, 0.160715950279701,
  0.236797881208973, 0.182405137324473, 0.179559883501593, 0.330925575740609,
  0.219610123139958, 0.160127799581627, 0.166895012300544, 0.121100499363444,
  0.0992564395447735, 0.131860935844565, 0.467570961804955, 0.21174300357043,
  0.230132422760407, 0.326354232425632, 0.370375111733958, 0.244755248962374,
  0.126954461842776, 0.250371761861621, 0.160219492798746, 0.231564519009254,
  0.108545017286106, 0.175236741956497, 0.516491510538509, 0.158205880878487,
  0.298316756984811, 0.333596615741652, 0.735711531383683, 0.195964932177231,
  0.245560483517786, 0.523926223662838, 0.118238566518397, 0.355353636087258,
  0.474565760327317, 0.152938825038354, 0.198371964459408, 0.227997948851298,
  0.133606410695916, 0.318266704685804, 0.150596295096059, 0.0952922359572668,
  0.0921085213896791, 0.263785276551806, 0.12465158729642, 0.557633890780449,
  0.39355387716175, 0.238233511786778, 0.115120781179526, 0.0636761955233425,
  0.198019367085348, 0.308914258279244, 0.269471034801686, 0.115308975504568,
  0.671797668832772, 0.500143378133316, 0.281386609351861, 0.331729922356322,
  0.106677524215197, 0.272156575441057, 0.204931195746242, 0.487782009319744,
  0.177056257963862, 0.0616420415660063, 0.147875358366913, 0.239510913524556,
  0.307767356625899, 0.19121777178748, 0.135981500447574, 0.157415476097511,
  0.166864247519057, 0.133895671112361, 0.0924450876046859, 0.32102858763536,
  0.198895123946026, 0.527380390585718, 0.585459540589679, 0.286672434945698,
  0.505852630660537, 0.0821321454747653, 0.181649432672358, 0.226487500756802,
  0.147822753589431, 0.60158174893537, 0.22495725129645, 0.246890463678425,
  0.30709593026273, 0.139967519094007, 0.42243543014036, 0.148522862226092,
  0.131257303974559, 0.116359333932108, 0.463839925806043, 0.146782842329972,
  0.285444627932411, 0.200363056364067, 0.0857930601179574, 0.354460330559097,
  0.231102616157033, 0.105913323480747, 0.167158425717844, 0.178303701058023,
  0.420176651980505, 0.124741103617379, 0.232292520456271, 0.582934657835532,
  0.127887054196021, 0.414812116440751, 0.144106700014086, 0.0951604666323766,
  0.151720165761754, 0.191985147537726, 0.474596508907523, 0.254545759628035,
  0.0763650291460135, 0.0798419887622357, 0.105898133489484, 0.198508058048287,
  0.109137695669127, 0.351594735987558, 0.445828232051039, 0.190020776833498,
  0.199940658476693, 0.0692409710447151, 0.19031340965407, 0.258575911893777,
  0.16675089027811, 0.282931007612389, 0.228876648204738, 0.215928311370215,
  0.423293992592713, 0.10015495383643, 0.486496091019948, 0.337052467270748,
  0.0571699897283551, 0.155591562733229, 0.0919314371684355, 0.383435576767526,
  0.284835218077913, 0.232189257685112, 0.17568409275671, 0.159999625142315,
  0.132429128154783, 0.32428200715764, 0.14150975900268, 0.237000421818326,
  0.223728864510441, 0.543800409639719, 0.824609376893653, 0.343809352720593,
  0.091132421917107, 0.16580678654138, 0.0913288672917396, 0.358202791896484,
  0.801673150101103, 0.270463780334883, 0.275575410882529, 0.511834470439226,
  0.275503883767843, 0.178935709165406, 0.0629845051086953, 0.174019823590444,
  0.310813241871184, 0.0659119402262487, 0.232492541797476, 0.0484872069932018,
  0.423867968593386, 0.530809461329857, 0.293860856467328, 0.561529634391357,
  0.283171439274123, 0.392248045492012, 0.323103499505407, 0.227478951627676,
  0.113538103187433, 0.502933375784182, 0.228061852040656, 0.0558545841209009,
  0.639151093839085, 0.232584220044108, 0.071237818425445, 0.161559993258827,
  0.440749349043022, 0.302467959444009, 0.145987578449451, 0.301612486577209,
  0.0693199677827025, 0.393858232834414, 0.243014400924523, 0.190532298995412,
  0.174201903130375, 0.157460385165891, 0.436546378954301, 0.367697102815664,
  0.151502862013241, 0.0511353950804288, 0.236867879442464, 0.11295276423114,
  0.295189817668446, 0.179548325094223, 0.446615538609851, 0.201490070955628,
  0.149482296062162, 0.32167765539439, 0.524110663283354, 0.232266827394817,
  0.328013022408512, 0.353628594033065, 0.211508788090533, 0.0652301533116838,
  0.111440953610875, 0.139529807101615, 0.0742743722877095, 0.265376916701045,
  0.315421215175118, 0.222695532719943, 0.171644234869539, 0.18233424720613,
  0.250645052698147, 0.374672699813666, 0.160558662099562, 0.133784751280325,
  0.225494583791645, 0.151417193725668, 0.295185597015897, 0.167318983401564,
  0.548893607602151, 0.167121180876574, 0.646056030156436, 0.626022608416877,
  0.154893111503759, 0.281114282804001, 0.424111653814498, 0.43141697689482,
  0.287103788312654, 0.293660813747509, 0.215335276943176, 0.165225061744507,
  0.362854089449205, 0.402685473836314, 0.133863131071794, 0.148017176870431,
  0.155879545607843, 0.484200123795378, 0.534680909274378, 0.459157217499076,
  0.226834410083853, 0.110293428251396, 0.190300641382238, 0.111328639513459,
  0.107018210215805, 0.212592664659291, 0.345709137496685, 0.349654322324745,
  0.197355625608947, 0.216555102556539, 0.19207816468319, 0.165487095550521,
  0.242014589131367, 0.12974172269225, 0.726541342280089, 0.284321125834299,
  0.266078565513548, 0.254872429990715, 0.535494604134233, 0.186301015388116,
  0.104193277884679, 0.40816920551436, 0.114518787849035, 0.456230552053034,
  0.0812366919138023, 0.125802607443974, 0.144389026446189, 0.0985958498445323,
  0.342635116755968, 0.308275450938105, 0.207744472147645, 0.331886093813819,
  0.20187611965575, 0.163675037207558, 0.223628575981823, 0.10896076543035,
  0.168934572536948, 0.15207002307647, 0.082382328768252, 0.232293785200157,
  0.0820104266502468, 0.569915722040811, 0.0641967468580518, 0.196315256324684,
  0.332231256992119, 0.779756912195156, 0.140796713130798, 0.0690189805781378,
  0.0990481809626649, 0.411294165933223, 0.0971129872819195, 0.309378204247512,
  0.129647973591833, 0.174107105012571, 0.536692350847625, 0.187466644505223,
  0.350394544797665, 0.260887348912398, 0.0881120683223164, 0.214777199326945,
  0.154666597961513, 0.174187986409973, 0.149490176049994, 0.444485191377052,
  0.455667325246947, 0.235833538126638, 0.297788964251613, 0.2707324297164,
  0.242248195290756, 0.59405308088965, 0.25135696005436, 0.171135905437018,
  0.225881272216095, 0.227311242976418, 0.173405157545255, 0.121349660070819,
  0.1309505763681, 0.257585121593547, 0.104871406076385, 0.445922466027239,
  0.138425223965309, 0.354778760593099, 0.144450933677985, 0.121169692688556,
  0.229671360487009, 0.338403746806927, 0.18638774363145, 0.214516272708446,
  0.356950276707129, 0.396924565371843, 0.545323331823296, 0.17168477799494,
  0.127731555815848, 0.211116815135454, 0.464564875582649, 0.336738406294208,
  0.112258966096179, 0.120545083321058, 0.0641527617905359, 0.25275940377204,
  0.219192418537144, 0.148877271431529, 0.666596222284862, 0.149993071027644,
  0.075107576739202, 0.529828858680672, 0.926182631405002, 0.4561467233398,
  0.107680333522616, 0.187444174937931, 0.0953297723022552, 0.174420650154519,
  0.215225740212586, 0.372569378763346, 0.153258717310835, 0.154056119571915,
  0.339128760160127, 0.611301640228648, 0.142663254709159, 0.283520767951581,
  0.240311946533525, 0.333401466729235, 0.129332569720283, 0.44542359478102,
  0.319065275725201, 0.0984323703580657, 0.132883564781241, 0.394841065808623,
  0.378967495041443, 0.194103322039725, 0.222317212264379, 0.181948011632726,
  0.0904679210019801, 0.377922622806746, 0.134447221323425, 0.0603240940379589,
  0.410065276136249, 0.116530916224463, 0.300445374849727, 0.1928709871634,
  0.278780794668632, 0.0780863636286859, 0.223509200764935, 0.37823300607073,
  0.385918438376043, 0.173750059943887, 0.875328983908873, 0.339588209585502,
  0.192845016462929, 0.184653665183295, 0.140361021063262, 0.258914349087863,
  0.181272754370575, 0.577936567060824, 0.199230497763062, 0.286606507281614,
  0.517138488295141, 0.0923267986496501, 0.200552739954884, 0.0727583894197602,
  0.103201617918352, 0.233410922064624, 0.436133308706401, 0.152054516832367,
  0.462595750527968, 0.303707439480123, 0.444411592108333, 0.158833665279712,
  0.209483690113115, 0.189949804010023, 0.535399882520869, 0.321768643103715,
  0.263687539578082, 0.458975614085739, 0.56907176691747, 0.253608161456461,
  0.384684843039372, 0.358476311121773, 0.673473449598278, 0.277695160666907,
  0.15271050621903, 0.138226193993146, 0.366949444547055, 0.222709744004075,
  0.64746783699108, 0.30549310539986, 0.140444179334032, 0.572865036858426,
  0.371831827392375, 0.629453290895474, 0.148752701002853, 0.281576143560454,
  0.383824049911877, 0.613750827056103, 0.414815443844164, 0.823870351790048,
  0.227056511235554, 0.179674175189532, 0.158709267644306, 0.451963684530087,
  0.356921477826286, 0.222119020624703, 0.254266880006423, 0.452512623632409,
  0.114233458120461, 0.185984818677693, 0.150074658274539, 0.0641274094920296,
  0.0589229160581964, 0.0917498435161754, 0.191580426500388, 0.136160070279283,
  0.067085170477643, 0.261285062784851, 0.225607922433957, 0.274438431316578,
  0.249506615540087, 0.109700223549661, 0.304985085473018, 0.319452221636455,
  0.215265872931467, 0.167686835774643, 0.102503935863489, 0.169522333019384,
  0.144601685444264, 0.399528640382457, 0.130127484099828, 0.26814971063401,
  0.17236970304124, 0.196766914518102, 0.355877767624534, 0.275701462264653,
  0.445083790413649, 0.158071831183367, 0.401768972568983, 0.346394956284828,
  0.14556237549644, 0.11649157807431, 0.340985075481972, 0.131992417504515,
  0.319568430889632, 0.244430096497871, 0.354436990725822, 0.24080469611474,
  0.435471830361624, 0.119060303387845, 0.457166394866558, 0.23310444233737,
  0.395136992134022, 0.294513934165989, 0.51513350766401, 0.189054172235888,
  0.0898471460424951, 0.074110058322888, 0.293545411514895, 0.573285365083268,
  0.241216488853668, 0.219536987773795, 0.393593319996096, 0.132740570633474,
  0.0799250334006417, 0.250178335919116, 0.608343294640724, 0.0644514103157887,
  0.232709209152671, 0.630982257947851, 0.127830237201236, 0.105929833135589,
  0.139773241886056, 0.469027674069095, 0.681887060241992, 0.210839742833238,
  0.086917707022965, 0.124636134228005, 0.17443983347018, 0.269135170912751,
  0.153965205677407, 0.320010071520905, 0.219738653114804, 0.137280491861298,
  0.681753500336373, 0.0569494151081259, 0.0617933386453686, 0.250660428702629,
  0.173398183543843, 0.301942109274266, 0.247817288090198, 0.327994302105474,
  0.264162806311564, 0.232051936834333, 0.464853308612685, 0.0803662905573575,
  0.127226841254906, 0.10996746376669, 0.133947115539324, 0.181849842652262,
  0.0603483171509145, 0.10677167675803, 0.259047236724008, 0.304834253382922,
  0.411652053971614, 0.234750894989931, 0.234541166312404, 0.110989934932401,
  0.695953040257886, 0.0952321613249919, 0.169926300508719, 0.132982003459703,
  0.56557304216225, 0.270389523888832, 0.133373081537162, 0.369690528702707,
  0.541209530340721, 0.225095514581954, 0.602723791106982, 0.217428939878615,
  0.391134852683023, 0.214161232063759, 0.202250463746677, 0.251959701176844,
  0.0794635134524419, 0.315878264857548, 0.169570771903896, 0.682302826550195,
  0.467746325632325, 0.32260161357416, 0.620710594713183, 0.356895956314686,
  0.428584525492461, 0.532089087583444, 0.353190308643947, 0.268914305170133,
  0.334983957242072), .Dim = c(694L, 2L), .Dimnames = list(c("1",
    "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13",
    "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24",
    "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35",
    "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46",
    "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57",
    "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68",
    "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79",
    "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90",
    "91", "92", "93", "94", "95", "96", "97", "98", "99", "100",
    "101", "102", "103", "104", "105", "106", "107", "108", "109",
    "110", "111", "112", "113", "114", "115", "116", "117", "118",
    "119", "120", "121", "122", "123", "124", "125", "126", "127",
    "128", "129", "130", "131", "132", "133", "134", "135", "136",
    "137", "138", "139", "140", "141", "142", "143", "144", "145",
    "146", "147", "148", "149", "150", "151", "152", "153", "154",
    "155", "156", "157", "158", "159", "160", "161", "162", "163",
    "164", "165", "166", "167", "168", "169", "170", "171", "172",
    "173", "174", "175", "176", "177", "178", "179", "180", "181",
    "182", "183", "184", "185", "186", "187", "188", "189", "190",
    "191", "192", "193", "194", "195", "196", "197", "198", "199",
    "200", "201", "202", "203", "204", "205", "206", "207", "208",
    "209", "210", "211", "212", "213", "214", "215", "216", "217",
    "218", "219", "220", "221", "222", "223", "224", "225", "226",
    "227", "228", "229", "230", "231", "232", "233", "234", "235",
    "236", "237", "238", "239", "240", "241", "242", "243", "244",
    "245", "246", "247", "248", "249", "250", "251", "252", "253",
    "254", "255", "256", "257", "258", "259", "260", "261", "262",
    "263", "264", "265", "266", "267", "268", "269", "270", "271",
    "272", "273", "274", "275", "276", "277", "278", "279", "280",
    "281", "282", "283", "284", "285", "286", "287", "288", "289",
    "290", "291", "292", "293", "294", "295", "296", "297", "298",
    "299", "300", "301", "302", "303", "304", "305", "306", "307",
    "308", "309", "310", "311", "312", "313", "314", "315", "316",
    "317", "318", "319", "320", "321", "322", "323", "324", "325",
    "326", "327", "328", "329", "330", "331", "332", "333", "334",
    "335", "336", "337", "338", "339", "340", "341", "342", "343",
    "344", "345", "346", "347", "348", "349", "350", "351", "352",
    "353", "354", "355", "356", "357", "358", "359", "360", "361",
    "362", "363", "364", "365", "366", "367", "368", "369", "370",
    "371", "372", "373", "374", "375", "376", "377", "378", "379",
    "380", "381", "382", "383", "384", "385", "386", "387", "388",
    "389", "390", "391", "392", "393", "394", "395", "396", "397",
    "398", "399", "400", "401", "402", "403", "404", "405", "406",
    "407", "408", "409", "410", "411", "412", "413", "414", "415",
    "416", "417", "418", "419", "420", "421", "422", "423", "424",
    "425", "426", "427", "428", "429", "430", "431", "432", "433",
    "434", "435", "436", "437", "438", "439", "440", "441", "442",
    "443", "444", "445", "446", "447", "448", "449", "450", "451",
    "452", "453", "454", "455", "456", "457", "458", "459", "460",
    "461", "462", "463", "464", "465", "466", "467", "468", "469",
    "470", "471", "472", "473", "474", "475", "476", "477", "478",
    "479", "480", "481", "482", "483", "484", "485", "486", "487",
    "488", "489", "490", "491", "492", "493", "494", "495", "496",
    "497", "498", "499", "500", "501", "502", "503", "504", "505",
    "506", "507", "508", "509", "510", "511", "512", "513", "514",
    "515", "516", "517", "518", "519", "520", "521", "522", "523",
    "524", "525", "526", "527", "528", "529", "530", "531", "532",
    "533", "534", "535", "536", "537", "538", "539", "540", "541",
    "542", "543", "544", "545", "546", "547", "548", "549", "550",
    "551", "552", "553", "554", "555", "556", "557", "558", "559",
    "560", "561", "562", "563", "564", "565", "566", "567", "568",
    "569", "570", "571", "572", "573", "574", "575", "576", "577",
    "578", "579", "580", "581", "582", "583", "584", "585", "586",
    "587", "588", "589", "590", "591", "592", "593", "594", "595",
    "596", "597", "598", "599", "600", "601", "602", "603", "604",
    "605", "606", "607", "608", "609", "610", "611", "612", "613",
    "614", "615", "616", "617", "618", "619", "620", "621", "622",
    "623", "624", "625", "626", "627", "628", "629", "630", "631",
    "632", "633", "634", "635", "636", "637", "638", "639", "640",
    "641", "642", "643", "644", "645", "646", "647", "648", "649",
    "650", "651", "652", "653", "654", "655", "656", "657", "658",
    "659", "660", "661", "662", "663", "664", "665", "666", "667",
    "668", "669", "670", "671", "672", "673", "674", "675", "676",
    "677", "678", "679", "680", "681", "682", "683", "684", "685",
    "686", "687", "688", "689", "690", "691", "692", "693", "694"
  ), NULL))


seeds <- c(7350, 5880, 2571, 3887, 9745, 5608, 3468, 2711, 3448, 4676,
  1627, 5087, 6479, 3901, 1037, 6622, 4832, 3382, 8515, 268, 3210,
  5944, 3380, 3646, 9188, 2750, 7987, 466, 2981, 136, 5134, 8476,
  5618, 8948, 1590, 5281, 2551, 2052, 1444, 8688, 1691, 6398, 4728,
  8267, 5274, 4154, 982, 7540, 3081, 5286, 6405, 1238, 5589, 8221,
  6026, 1922, 7651, 3100, 4341, 2134, 9685, 4524, 9750, 7618, 8211,
  2438, 824, 6982, 6548, 9743, 4302, 9038, 185, 4418, 1306, 6643,
  9865, 3436, 6151, 9647, 4261, 8109, 7573, 127, 571, 4545, 7245,
  4764, 5038, 9037, 6085, 1459, 5124, 9463, 942, 2241, 6492, 3190,
  8229, 7099)
seed <- as.vector(matrix(seeds,ncol=1))
set.seed(54321)
# code shown how preds is generated
# output<-mipred.cv(Status~age10+perfstat+remstat+cyto+asct+donor+sex_match+cond,family=binomial(link="logit"),data=cll_bin[1:694,-1], nimp=2, folds=2, mice.options=list(maxit=2, seed=seed), method="rubin")
# now try replicate using dot notation
output<-mipred.cv(Status~.,family=binomial(link="logit"),data=cll_bin[1:694,-1], nimp=2, folds=2, mice.options=list(maxit=2, seed=seed), method="rubin")

test_that("predictions replicate from saved results generated with full formula when using dot notation for rubin approach in mipred.cv",{
  #  expect_identical(abs(cor(apply(output$pred,1,mean),preds)-0.979144406319983)<1e-13)
  expect_equal(output$pred,preds)
})


