\name{GetConfInt}
\alias{GetConfInt}
\title{
Computing confidence intervals for the estimated counts and probabilities
(deprecated)
}
\description{
This function computes the (asymptotic) Wald confidence intervals at a given 
significance level for the results generated by \code{\link[mipfp:Ipfp]{Ipfp}}
and \code{\link[mipfp:ObtainModelEstimates]{ObtainModelEstimates}} (provided 
that their option \code{compute.cov} was set to \code{TRUE}).
}
\usage{
GetConfInt(list.est, alpha = 0.05)
}
\arguments{
  \item{list.est}{
    A list produced either by \code{\link[mipfp:Ipfp]{Ipfp}} or 
    \code{\link[mipfp:ObtainModelEstimates]{ObtainModelEstimates}} containing
    the estimated counts and probabilities as well as their associated
    standard deviations.
}
  \item{alpha}{
    Significance level of the confidence interval corresponding to the
    100(1 - \eqn{\alpha}{\alpha})\% confidence level.
}
}
\details{
The confidence interval of the estimates \eqn{\hat{X}}{X.hat}, at significance
level \eqn{\alpha}{\alpha} is given by
\deqn{\hat{X} \pm z \left( 1-\frac{\alpha}{2} \right) * 
\hat{\sigma}}{X.hat +/- z(1-\alpha/2) * \sigma.hat}
where \eqn{\hat{\sigma}}{\sigma.hat} is the standart deviations of 
\eqn{\hat{X}}{X.hat} and \eqn{z}{z} is the inverse of the cumulative 
distribution function of the standard normal distribution.
}
\value{
  A list of matrices containing the upper and lower bounds for the estimated
  counts and probabilities.
  \item{lower.x}{
    Lower bounds of the confidence interval for \code{list.est$x.hat}.
}
  \item{upper.x}{
    Upper bounds of the confidence interval for \code{list.est$x.hat}.
}
  \item{lower.p}{
    lower bounds of the confidence interval for \code{list.est$p.hat}.
}
  \item{upper.p}{
    upper bounds of the confidence interval for \code{list.est$p.hat}.
}
}
\references{
 Smithson, M. (2002).
 \emph{Confidence intervals}.
 Sage Publications.
}
\author{
Johan Barthelemy

Maintainer: Johan Barthelemy \email{johan@uow.edu.au}.
}
\section{Warning}{
Note: this function is deprecated, instead use
\code{\link[mipfp:confint.mipfp]{confint.mipfp}}.
}
\seealso{
\code{\link[mipfp:Estimate]{Estimate}}, \code{\link[mipfp:Ipfp]{Ipfp}} and 
\code{\link[mipfp:ObtainModelEstimates]{ObtainModelEstimates}} to generate the
inputs for this function.

The S3 method \code{\link[mipfp:confint.mipfp]{confint.mipfp}} for object of 
class \code{mipfp}.
}
\examples{
# true contingency (2-way) table
true.table <- array(c(43, 44, 9, 4), dim = c(2, 2))
# generation of sample, i.e. the seed to be updated
seed <- ceiling(true.table / 10)
# desired targets (margins)
target.row <- apply(true.table, 2, sum)
target.col <- apply(true.table, 1, sum)
# storing the margins in a list
target.data <- list(target.col, target.row)
# list of dimensions of each marginal constrain
target.list <- list(1, 2)
# calling the Ipfp function
res <- Ipfp(seed, target.list, target.data)
# addint the standart deviations to res (required by GetConfInt)
cov.res <- vcov(res, seed = seed, target.list = target.list, 
                target.data = target.data)
res$p.hat.se <- cov.res$p.hat.se
res$x.hat.se <- cov.res$x.hat.se
# computing and printing the confidence intervals
print(GetConfInt(res))
}
\concept{confidence interval}
\keyword{multivariate}
