% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimapR-main.R
\name{minimap2}
\alias{minimap2}
\title{minimap2}
\usage{
minimap2(
  reference,
  query_sequences,
  output_file_prefix = "minimap2_out",
  a = TRUE,
  preset_string = "map-hifi",
  threads = 1,
  return = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{reference}{Reference genome to align the query sequences}

\item{query_sequences}{Query sequences to align to the reference genome}

\item{output_file_prefix}{Output file to save the alignment results}

\item{a}{Logical value to use the preset string with the -a flag}

\item{preset_string}{Preset string to use with the -x flag}

\item{threads}{Number of threads to use}

\item{return}{Logical value to return the alignment results}

\item{verbose}{Logical value to print progress of the installation}

\item{...}{Additional arguments to pass to minimap2}
}
\value{
This function returns the line needed to add minimap2 to PATH
}
\description{
This function is a wrapper for the command line tool minimap2.
minimap2 is a long read sequencing alignment tool that is
used to align long reads to a reference genome.
}
\examples{
\dontrun{
reference <- system.file("extdata/S288C_ref_genome.fasta.gz", package = "minimapR")
query_sequences <- system.file("extdata/yeast_sample_hifi.fastq.gz", package = "minimapR")
# Warning: not setting output_file_prefix will generate the output in the current working directory
bam_out <- minimap2(reference, 
 query_sequences, 
 threads = 4,
 preset_string = "map-hifi", 
 return = TRUE, 
 verbose = TRUE)
}

\dontrun{
reference <- system.file("extdata/GRCh38_chr1_130k.fa.gz", package = "minimapR")
query_sequences <- system.file("extdata/ont_hs_sample.fastq.gz", package = "minimapR")
# Warning: not setting output_file_prefix will generate the output in the current working directory
bam_out <- minimap2(reference, 
 query_sequences, 
 threads = 4,
 preset_string = "map-hifi",
 return = TRUE, 
 verbose = TRUE)
}

}
