% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pch.R
\name{dpch}
\alias{dpch}
\alias{ppch}
\alias{qpch}
\alias{rpch}
\alias{hpch}
\alias{chpch}
\alias{spch}
\title{Survival Distributions with piece-wise Constant Hazards}
\usage{
dpch(x, t, lambda)

ppch(q, t, lambda)

qpch(p, t, lambda)

rpch(n, t, lambda, discrete = FALSE)

hpch(x, t, lambda)

chpch(x, t, lambda)

spch(q, t, lambda)
}
\arguments{
\item{x}{vector of quantiles}

\item{t}{vector of left interval borders}

\item{lambda}{vector of hazards}

\item{q}{vector of quantiles}

\item{p}{vector of probabilities}

\item{n}{number of random numbers}

\item{discrete}{round survival times to whole numbers}
}
\value{
\code{dpch} gives the density evaluated at \code{x}.

\code{ppch} gives the distribution function evaluated at \code{q}.

\code{qpch} gives the \code{p}-quantiles.

\code{rpch} gives \code{n} random numbers.

\code{hpch} gives the hazard function evaluated at \code{x}.

\code{chpch} gives the cumulative hazard function evaluated at \code{x}.

\code{dpch} gives the survival function evaluated at \code{q}.
}
\description{
Densitiy, distribution function, quantiles, random numbers, hazard function,
cumulative hazard function and survival function of survival distributions
with piece-wise constant hazards (picewise exponential distributions).
}
\section{Functions}{
\itemize{
\item \code{dpch()}: density of survival distributions with piece-wise constant hazards

\item \code{ppch()}: distribution function of survival distributions with piece-wise constant hazards

\item \code{qpch()}: quantiles of survival distributions with piece-wise constant hazards

\item \code{rpch()}: random samples of survival distributions with piece-wise constant hazards

\item \code{hpch()}: hazard of survival distributions with piece-wise constant hazards

\item \code{chpch()}: cumulative hazard of survival distributions with piece-wise constant hazards

\item \code{spch()}: survival function of survival distributions with piece-wise constant hazards

}}
\examples{
dpch(1:10, c(0, 3), c(2, 0.1))
ppch(1:10, c(0, 3), c(2, 0.1))
qpch(seq(0,1, by=0.1), c(0, 3), c(2, 0.1))
rpch(15, c(0, 3), c(2, 0.1))
rpch(15, c(0, 3), c(2, 0.1), discrete=TRUE)
hpch(1:10, c(0, 3), c(2, 0.1))
chpch(1:10, c(0, 3), c(2, 0.1))
ppch(1:10, c(0, 3), c(2, 0.1))
}
