
\docType{data}
\name{syn.data}
\alias{syn.data}
\title{Simulated Gene Expression Data}
\description{
 Dataset containing 100 samples and 50 genes generated by the publicly available SynTReN generator
 using a yeast source network - see \code{\link{syn.net}}}
\usage{data(syn.data)}
\format{
 \code{syn.data} is a data frame containing 100 rows and 50 columns. 
 Each row contains a microarray experiment and each column contains a gene.
}
\source{
 \item SynTReN 1.1.3
 \item source network : yeast\_nn.sif
}
\references{
Tim Van den Bulcke, Koenraad Van Leemput, Bart Naudts, Piet van Remortel, 
Hongwu Ma, Alain Verschoren, Bart De Moor, and Kathleen Marchal. 
Syntren : a generator of synthetic gene expression dataset for design
and analysis of structure learning algorithms. BMC Bioinformatics, 2006.
}
\examples{
data(syn.data)
data(syn.net)
syn.data <- disc(syn.data)
mim <- build.mim(syn.data)
infered.net <- mr.net(mim)
max(fscores(validate( infered.net, syn.net )))
}
\keyword{datasets}
