% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mimi.R
\name{mimi.cov}
\alias{mimi.cov}
\title{mimi.cov
Compute solution of mimi with covariates effects along regularization path}
\usage{
mimi.cov(y, x, var.type = c("gaussian", "binary", "poisson"), lambda1,
  lambda2, maxit = 100, alpha0 = NULL, theta0 = NULL,
  thresh = 1e-05, trace.it = F, max.rank = NULL)
}
\arguments{
\item{y}{nxp matrix of observations}

\item{x}{(np)xN matrix of covariates}

\item{var.type}{vector of length p indicating the data types of the columns of y (gaussian, binary or poisson)}

\item{lambda1}{positive number regularization parameter for nuclear norm penalty}

\item{lambda2}{positive number regularization parameter for l1 norm penalty}

\item{maxit}{integer maximum number of iterations}

\item{alpha0}{vector of length N: initial value of regression parameter (optional)}

\item{theta0}{matrix of size nxp: initial value of interactions (optional)}

\item{thresh}{positive number, convergence criterion}

\item{trace.it}{boolean indicating whether convergence information should be printed}

\item{max.rank}{integer, maximum rank of interaction matrix theta}
}
\value{
A list with the following elements
\item{yimputed}{imputed data set}
\item{param}{estimated parameter matrix}
\item{alpha}{estimated vector of main effects}
\item{theta}{estimated interaction matrix}
}
\description{
mimi.cov
Compute solution of mimi with covariates effects along regularization path
}
\examples{
n = 6; p = 2
x <- matrix(rnorm(6*6*2), nrow = 6*6)
param <- matrix(x\%*\%c(2,0), nrow=6)+matrix(rnorm(6*6), nrow=6)
y1 <- matrix(rnorm(mean = c(param[, 1:2]), n * p), nrow = n)
y2 <- matrix(rbinom(n * p, prob = c(exp(param[,3:4])/(1+exp(param[,3:4]))), size = 1), nrow = n)
y3 <- matrix(rpois(n * p, lambda = c(exp(param[,5:6]))), nrow = n)
y <- cbind(y1, y2, y3)
var.type <- c(rep("gaussian", p), rep("binary", p), rep("poisson", p))
idx_NA <- sample(1:(3 * n * p), size = round(0.1 * 3 * n * p))
y[idx_NA] <- NA
res <- mimi.cov(y, x, var.type = var.type, lambda1 = 1, lambda2 = 2, thresh=0.1)
}
