% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mimi-internal.R
\name{armijo.alpha}
\alias{armijo.alpha}
\title{armijo.alpha
Performs backtracking line search along a pre-specified search direction}
\usage{
armijo.alpha(y0, x, alpha, theta, alpha.tmp, theta.tmp, z, w, b = 0.5,
  lambda2, var.type, thresh = 1e-05, nu = 0.1, zeta = 0.9,
  th = 0.9, step = 1)
}
\arguments{
\item{y0}{nxp observations matrix}

\item{x}{(np)xN matrix of covariates}

\item{alpha}{direction of update for vector of regression parameters of length N}

\item{theta}{nxp matrix direction of update for matrix of interactions}

\item{alpha.tmp}{length N vector, current regression parameters}

\item{theta.tmp}{nxp matrix, current matrix of interactions}

\item{z}{matrix around which the quadratic approximation is done}

\item{w}{weights of the quadratic approximation}

\item{b}{positive number in (0,1) factor by which the step size is reduced}

\item{lambda2}{positive number, regularization parameter for l1 norm penalty}

\item{var.type}{vector of length p indicating column types for y (gaussian, binary, poisson)}

\item{thresh}{positive number, convergence criterion}

\item{nu}{positive number, backtracking line search parameter, default 0.01}

\item{zeta}{positive number, backtracking line search parameter, default 0.1}

\item{th}{positive number, backtracking line search parameter, default 0.1}

\item{step}{number in (0,1), initial backtracking line search step, default 1}
}
\value{
A list with the following elements
\item{alpha}{a (nb groups) x (nb variables) matrix containing the group effects}
\item{theta a}{(nb individuals) x (nb variables) matrix containing the individual effects}
\item{objective}{a vector containing the value of the objective function at every iteration}
\item{step}{the step size}
}
\description{
armijo.alpha
Performs backtracking line search along a pre-specified search direction
}
