% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_models.R
\name{permute_p_value}
\alias{permute_p_value}
\title{Calculated a permuted p-value comparing two models}
\usage{
permute_p_value(
  merged_data,
  metric,
  group_name,
  group_1,
  group_2,
  nperm = 10000
)
}
\arguments{
\item{merged_data}{the concatenated performance data from \code{run_ml}}

\item{metric}{metric to compare, must be numeric}

\item{group_name}{column with group variables to compare}

\item{group_1}{name of one group to compare}

\item{group_2}{name of other group to compare}

\item{nperm}{number of permutations, default=10000}
}
\value{
numeric p-value comparing two models
}
\description{
Calculated a permuted p-value comparing two models
}
\examples{
df <- dplyr::tibble(
  model = c("rf", "rf", "glmnet", "glmnet", "svmRadial", "svmRadial"),
  AUC = c(.2, 0.3, 0.8, 0.9, 0.85, 0.95)
)
set.seed(123)
permute_p_value(df, "AUC", "model", "rf", "glmnet", nperm = 100)
}
\author{
Begüm Topçuoğlu, \email{topcuoglu.begum@gmail.com}

Courtney R Armour, \email{armourc@umich.edu}
}
