% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_model.R
\name{train_model}
\alias{train_model}
\title{Train model}
\usage{
train_model(
  model_formula,
  train_data,
  method,
  cv,
  perf_metric_name,
  tune_grid,
  ntree
)
}
\arguments{
\item{model_formula}{Model formula.}

\item{train_data}{Training data.}

\item{method}{ML method.
Options: \code{c("glmnet", "rf", "rpart2", "svmRadial", "xgbTree")}.
\itemize{
\item glmnet: linear, logistic, or multiclass regression
\item rf: random forest
\item rpart2: decision tree
\item svmRadial: support vector machine
\item xgbTree: xgboost
}}

\item{cv}{Cross-validation caret scheme.}

\item{perf_metric_name}{The column name from the output of the function
provided to perf_metric_function that is to be used as the performance metric.
Defaults: binary classification = \code{"ROC"},
multi-class classification = \code{"logLoss"},
regression = \code{"RMSE"}.}

\item{tune_grid}{Tuning grid.}

\item{ntree}{For random forest, how many trees to use (default: 1000).
Note that caret doesn't allow this parameter to be tuned.}
}
\value{
Trained model from \code{\link[caret:train]{caret::train()}}.
}
\description{
Train model using \code{\link[caret:train]{caret::train()}}.
}
\details{
TODO: Add example.
}
\author{
Zena Lapp, \email{zenalapp@umich.edu}
}
