% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffs_demo.R
\name{ffs_demo}
\alias{ffs_demo}
\alias{ffs}
\title{Estimation of bilateral migrant flows from bilateral migrant stocks using demographic accounting approaches}
\usage{
ffs_demo(
  m1 = NULL,
  m2 = NULL,
  b_por = NULL,
  d_por = NULL,
  m = NULL,
  stayer_assumption = TRUE,
  match_global = "before-demo-adjust",
  match_pob_tot_method = "rescale",
  birth_non_negative = TRUE,
  death_method = "proportion",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{m1}{Matrix of migrant stock totals at time \emph{t}. Rows in the matrix correspond to place of birth and columns to place of residence at time \emph{t}}

\item{m2}{Matrix of migrant stock totals at time \emph{t}+1. Rows in the matrix correspond to place of birth and columns to place of residence at time \emph{t}+1.}

\item{b_por}{Vector of the number of births between time \emph{t} and \emph{t}+1 in each region.}

\item{d_por}{Vector of the number of deaths between time \emph{t} and \emph{t}+1 in each region.}

\item{m}{Matrix of auxiliary data. By default set to 1 for all origin-destination combinations.}

\item{stayer_assumption}{Logical value to indicate whether to use \code{\link{ipf3}} or \code{\link{ipf3_qi}} to estimate flows. By default uses \code{ipf3_qi}, i.e. is set to \code{TRUE}. The \code{ipf} function is useful for replicating method of Azoze and Raferty.}

\item{match_global}{Character string used to indicate whether to balance the change in stocks totals with the changes in births and deaths. Only applied when \code{match_pob_tot_method} is either \code{rescale} or \code{rescale-adjust-zero-fb}. By default uses \code{after-demo-adjust} rather than \code{before-demo-adjust} which I think minimises risk of negative values.}

\item{match_pob_tot_method}{Character string passed to \code{method} argument in \code{\link{match_pob_tot}} to ensure place of birth margins in stock tables match.}

\item{birth_non_negative}{Logical value passed to \code{non_negative} argument in \code{\link{birth_mat}}.}

\item{death_method}{Character string passed to \code{method} argument in \code{\link{death_mat}}.}

\item{verbose}{Logical value to indicate the print the parameter estimates at each iteration of the various IPF routines. By default \code{FALSE}.}

\item{...}{Additional arguments passes to \code{\link{ipf3_qi}} or \code{\link{ipf3}}.}
}
\value{
Estimates migrant transitions flows between two sequential migrant stock tables using various methods. See the example section for possible variations on estimation methods.

Returns a \code{list} object with:
\item{mu }{Array of indirect estimates of origin-destination matrices by place of birth.}
\item{it }{Iteration count.}
\item{tol }{Tolerance level at final iteration.}
\item{y }{Array of indirect estimates of origin-destination matrices by place of birth with additional rows and columns for births, deaths and moves to other regions.}
\item{...}{Slots to record which estimation method was used (as set by arguments above)}
\item{od_flow }{Matrix of estimated origin-destination flows}
}
\description{
Estimates migrant transitions flows between two sequential migrant stock tables. Replaces old \code{ffs}.
}
\examples{
##
## without births and deaths over period
##
# data as in papers
s1 <- matrix(data = c(1000, 100, 10, 0, 55, 555, 50, 5, 80, 40, 800, 40, 20, 25, 20, 200),
             nrow = 4, ncol = 4, byrow = TRUE)
s2 <- matrix(data = c(950, 100, 60, 0, 80, 505, 75, 5, 90, 30, 800, 40, 40, 45, 0, 180),
             nrow = 4, ncol = 4, byrow = TRUE)
b <- d <- rep(0, 4)
reg <- LETTERS[1:4]
dimnames(s1) <- dimnames(s2) <- list(pob = reg, por = reg)
names(b) <- names(d) <- reg
s1; s2; b; d

# demographic research and science paper example
ffs_demo(m1 = s1, m2 = s2, b_por = b, d_por = d)

# international migration review paper example
s1[,] <- c(100, 20, 10, 20, 10, 55, 40, 25, 10, 25, 140, 20, 0, 10, 65, 200)
s2[,] <- c(70, 25, 10, 40, 30, 60, 55, 45, 10, 10, 140, 0, 10, 15, 50, 180)
ffs_demo(m1 = s1, m2 = s2, b_por = b, d_por = d)

# international migration review supp. material example
dm <- matrix(data = c(0, 5, 50, 500, 5, 0, 45, 495, 50, 45, 0, 450, 500, 495, 450, 0), 
             nrow = 4, ncol = 4, byrow = TRUE)
dimnames(dm) <- list(orig = reg, dest = reg)
ffs_demo(m1 = s1, m2 = s2, b_por = b, d_por = d, m = dm)

##
## with births and deaths over period
##
# demographic research paper example
s1[,] <- c(1000, 55, 80, 20, 100, 555, 40, 25, 10, 50, 800, 20, 0, 5, 40, 200)
s2[,] <- c(1060, 45, 70, 30, 60, 540, 75, 30, 10, 40, 770, 20, 10, 0, 70, 230)
b[] <- c(80, 20, 40, 60)
d[] <- c(70, 30, 50, 10)
ffs_demo(m1 = s1, m2 = s2, b_por = b, d_por = d, match_pob_tot_method = "open-dr")
# makes more sense to use this method
ffs_demo(m1 = s1, m2 = s2, b_por = b, d_por = d, match_pob_tot_method = "open")

# science paper  supp. material example
b[] <- c(80, 20, 60, 60)
ffs_demo(m1 = s1, m2 = s2, b_por = b, d_por = d)

# international migration review supp. material example
s1[,] <- c(100, 20, 10, 20, 10, 55, 40, 25, 10, 25, 140, 20, 0, 10, 65, 200)
s2[,] <- c(75, 20, 30, 30, 25, 45, 40, 30, 5, 30, 150, 20, 0, 15, 60, 230)
b[] <- c(10, 50, 25, 60)
d[] <- c(30, 10, 40, 10)
ffs_demo(m1 = s1, m2 = s2, b_por = b, d_por = d)
}
\references{
Abel and Cohen (2019) Bilateral international migration flow estimates for 200 countries \emph{Scientific Data} 6 (1), 1-13

Azose & Raftery (2019) Estimation of emigration, return migration, and transit migration between all pairs of countries \emph{Proceedings of the National Academy of Sciences} 116 (1) 116-122

Abel, G. J. (2018). Estimates of Global Bilateral Migration Flows by Gender between 1960 and 2015. \emph{International Migration Review} 52 (3), 809–852.

Abel, G. J. and Sander, N. (2014). Quantifying Global International Migration Flows. \emph{Science}, 343 (6178) 1520-1522

Abel, G. J. (2013). Estimating Global Migration Flow Tables Using Place of Birth. \emph{Demographic Research} 28, (18) 505-546
}
\seealso{
\code{\link{ipf3_qi}}, \code{\link{ffs_diff}}, \code{\link{ffs_rates}}
}
\author{
Guy J. Abel
}
