% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MutatorDiscreteUniform.R
\name{dict_mutators_unif}
\alias{dict_mutators_unif}
\alias{MutatorDiscreteUniform}
\title{Uniform Discrete Mutator}
\description{
Discrete components are mutated by sampling from a uniform distribution, either from all possible
values of each component, or from all values except the original value.

Since the information loss is very high, this should in most cases be combined with \code{\link{MutatorCmpMaybe}}.
}
\section{Configuration Parameters}{

\itemize{
\item \code{can_mutate_to_same} :: \code{logical(1)}\cr
Whether to sample from entire range of each parameter (\code{TRUE}) or from all values except the
current value (\code{FALSE}). Initialized to \code{TRUE}.
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Domain]{Domain}} classes are: \code{\link[paradox:Domain]{p_lgl}} ('ParamLgl'), \code{\link[paradox:Domain]{p_fct}} ('ParamFct')
}

\section{Dictionary}{

This \code{\link{Mutator}} can be created with the short access form \code{\link[=mut]{mut()}}
(\code{\link[=muts]{muts()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_mutators}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
mut("unif")
muts("unif")  # takes vector IDs, returns list of Mutators

# long form:
dict_mutators$get("unif")
}\if{html}{\out{</div>}}
}

\examples{
set.seed(1)
mdu = mut("unif")
p = ps(x = p_lgl(), y = p_fct(c("a", "b", "c")))
data = data.frame(x = rep(TRUE, 5), y = rep("a", 5),
  stringsAsFactors = FALSE)  # necessary for R <= 3.6

mdu$prime(p)
mdu$operate(data)

mdu$param_set$values$can_mutate_to_same = FALSE
mdu$operate(data)
}
\seealso{
Other mutators: 
\code{\link{Mutator}},
\code{\link{MutatorDiscrete}},
\code{\link{MutatorNumeric}},
\code{\link{OperatorCombination}},
\code{\link{dict_mutators_cmpmaybe}},
\code{\link{dict_mutators_erase}},
\code{\link{dict_mutators_gauss}},
\code{\link{dict_mutators_maybe}},
\code{\link{dict_mutators_null}},
\code{\link{dict_mutators_proxy}},
\code{\link{dict_mutators_sequential}}
}
\concept{mutators}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Mutator]{miesmuschel::Mutator}} -> \code{\link[miesmuschel:MutatorDiscrete]{miesmuschel::MutatorDiscrete}} -> \code{MutatorDiscreteUniform}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MutatorDiscreteUniform-new}{\code{MutatorDiscreteUniform$new()}}
\item \href{#method-MutatorDiscreteUniform-clone}{\code{MutatorDiscreteUniform$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="prime"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-prime'><code>miesmuschel::MiesOperator$prime()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MutatorDiscreteUniform-new"></a>}}
\if{latex}{\out{\hypertarget{method-MutatorDiscreteUniform-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{MutatorDiscreteUniform} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MutatorDiscreteUniform$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MutatorDiscreteUniform-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MutatorDiscreteUniform-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MutatorDiscreteUniform$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
