% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiesOperator.R
\name{MiesOperator}
\alias{MiesOperator}
\title{Operator Base Class}
\description{
Base class representing MIES-operators: \code{\link{Recombinator}}, \code{\link{Mutator}}, and \code{\link{Selector}}.

Operators perform a specific function within ES algorithms, and by exchanging them, the character of ES
algorithms can be modified. Operators operate on collections of individuals and return
modified individuals (mutated or recombined) or indices of selected individuals. Operators can be combined using
\code{\link{MutatorCombination}} / \code{\link{RecombinatorCombination}} and other operators wrappers.

Before applying operators, they have to be \emph{primed} for the domain of the individuals which they are operating on;
this is done using the \verb{$prime()} function. Afterwards, the \verb{$operate()} function may be called with a \code{data.frame}
of individuals that fall into this domain. \verb{$operate()} may be called multiple times after priming, and a once
primed operator can be primed again for a different domain by calling \verb{$prime()} agian (which forgets the old priming).
}
\section{Inheriting}{

\code{MiesOperator} is an abstract base class and should be inherited from. Inheriting classes should implement the
private \verb{$.operate()} function. The user of the object calls \verb{$operate()}, and the arguments are passed on to
private \verb{$.operate()} after checking that the operator is primed, and that the \code{values} argument conforms to the
primed domain. Typically, the \verb{$initialize()} and \verb{$prime()} functions are also overloaded, but should call their
\code{super} equivalents.

In most cases, the \code{MiesOperator} class should not be inherited from, directly; instead, the operator classes
(\code{\link{Recombinator}}, \code{\link{Mutator}}, \code{\link{Selector}}) or their subclasses should be inherited.
}

\seealso{
Other base classes: 
\code{\link{Filtor}},
\code{\link{FiltorSurrogate}},
\code{\link{Mutator}},
\code{\link{MutatorDiscrete}},
\code{\link{MutatorNumeric}},
\code{\link{OperatorCombination}},
\code{\link{Recombinator}},
\code{\link{RecombinatorPair}},
\code{\link{Scalor}},
\code{\link{Selector}},
\code{\link{SelectorScalar}}
}
\concept{base classes}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
Configuration parameters of the \code{MiesOperator} object. Read-only.}

\item{\code{param_classes}}{(\code{character})\cr
Classes of parameters that the operator can handle, contains any of \code{"ParamLgl"}, \code{"ParamInt"}, \code{"ParamDbl"}, \code{"ParamFct"}. Read-only.}

\item{\code{packages}}{(\code{character})\cr
Packages needed for the operator. Read-only.}

\item{\code{dict_entry}}{(\code{character(1)} | \code{NULL})\cr
Key of this class in its respective \code{\link[mlr3misc:Dictionary]{Dictionary}}.
Is \code{NULL} if this class it not (known to be) in a \code{\link[mlr3misc:Dictionary]{Dictionary}}. Read-only.}

\item{\code{dict_shortaccess}}{(\code{character(1)} | \code{NULL})\cr
Name of \code{\link[mlr3misc:Dictionary]{Dictionary}} short-access function where an object of this class can be retrieved.
Is \code{NULL} if this class is not (known to be) in a \code{\link[mlr3misc:Dictionary]{Dictionary}}
with a short-access function. Read-only.}

\item{\code{endomorphism}}{(\code{logical(1)})\cr
Whether the output of \verb{$operate()} is a \code{data.frame} / \code{\link[data.table:data.table]{data.table}} in the same domain as its input. Read-only.}

\item{\code{primed_ps}}{(\code{\link[paradox:ParamSet]{ParamSet}} | \code{NULL})\cr
\code{\link[paradox:ParamSet]{ParamSet}} on which the \code{MiesOperator} is primed. Is \code{NULL} if it has not been primed.
Writing to this acrive binding calls \verb{$prime()}.}

\item{\code{is_primed}}{(\code{logical(1)})\cr
Whether the \code{MiesOperator} was primed before. Is \code{FALSE} exactly when \verb{$primed_ps} is \code{NULL}. Read-only.}

\item{\code{man}}{(\code{character(1)})\cr
Name of this class, in the form \verb{<package>::<classname>}. Used by the \verb{$help()} method.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MiesOperator-new}{\code{MiesOperator$new()}}
\item \href{#method-MiesOperator-repr}{\code{MiesOperator$repr()}}
\item \href{#method-MiesOperator-print}{\code{MiesOperator$print()}}
\item \href{#method-MiesOperator-prime}{\code{MiesOperator$prime()}}
\item \href{#method-MiesOperator-operate}{\code{MiesOperator$operate()}}
\item \href{#method-MiesOperator-help}{\code{MiesOperator$help()}}
\item \href{#method-MiesOperator-clone}{\code{MiesOperator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MiesOperator-new"></a>}}
\if{latex}{\out{\hypertarget{method-MiesOperator-new}{}}}
\subsection{Method \code{new()}}{
Initialize base class components of the \code{MiesOperator}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MiesOperator$new(
  param_classes = c("ParamLgl", "ParamInt", "ParamDbl", "ParamFct"),
  param_set = ps(),
  packages = character(0),
  dict_entry = NULL,
  dict_shortaccess = NULL,
  own_param_set = quote(self$param_set),
  endomorphism = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_classes}}{(\code{character})\cr
Classes of parameters that the operator can handle. May contain any of \code{"ParamLgl"}, \code{"ParamInt"}, \code{"ParamDbl"}, \code{"ParamFct"}.
Default is all of them.\cr
The \verb{$param_classes} field will reflect this value.}

\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}} | \code{list} of \code{expression})\cr
Strategy parameters of the operator. This should be created by the subclass and given to \code{super$initialize()}.
If this is a \code{\link[paradox:ParamSet]{ParamSet}}, it is used as the \code{MiesOperator}'s \code{\link[paradox:ParamSet]{ParamSet}}
directly. Otherwise it must be a \code{list} of expressions e.g. created by \code{alist()} that evaluate to \code{\link[paradox:ParamSet]{ParamSet}}s,
possibly referencing \code{self} and \code{private}.
These \code{\link[paradox:ParamSet]{ParamSet}} are then combined using a \code{\link[paradox:ParamSetCollection]{ParamSetCollection}}.
Default is the empty \code{\link[paradox:ParamSet]{ParamSet}}.\cr
The \verb{$param_set} field will reflect this value.}

\item{\code{packages}}{(\code{character})
Packages that need to be loaded for the operator to function. This should
be declared so these packages can be loaded when operators run on parallel
instances. Default is \code{character(0)}.\cr
The \verb{$packages} field will reflect this values.}

\item{\code{dict_entry}}{(\code{character(1)} | \code{NULL})\cr
Key of the class inside the \code{\link[mlr3misc:Dictionary]{Dictionary}} (usually one of
\code{\link{dict_mutators}}, \code{\link{dict_recombinators}}, \code{\link{dict_selectors}}), where it can
be retrieved using a \link[=mut]{short access function}. May be \code{NULL} if the operator
is not entered in a dictionary.\cr
The \verb{$dict_entry} field will reflect this value.}

\item{\code{dict_shortaccess}}{(\code{character(1)} | \code{NULL})\cr
Name of the \code{\link[mlr3misc:Dictionary]{Dictionary}} short access function in which the operator is registered.
This is used to inform the user about how to construct a given object. Should ordinarily be one of
\code{"mut"}, \code{"rec"}, \code{"sel"}.\cr
The \verb{$dict_shortaccess} field will reflect this value.}

\item{\code{own_param_set}}{(\code{language})\cr
An expression that evaluates to a \code{\link[paradox:ParamSet]{ParamSet}} indicating the configuration parameters that are entirely owned by
this operator class (and not proxied from a construction argument object). This should be \code{quote(self$param_set)} (the default) when
the \code{param_set} argument is not a list of expressions.}

\item{\code{endomorphism}}{(\code{logical(1)})\cr
Whether the private \verb{$.operate()} operation creates a \code{\link[data.table:data.table]{data.table}} with the same columns as the input
(i.e. conforming to the primed \code{\link[paradox:ParamSet]{ParamSet}}). If this is \code{TRUE} (default), then the return value of \verb{$.operate()}
is checked for this and columns are put in the correct order.\cr
The \verb{$endomorphsim} field will reflect this value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MiesOperator-repr"></a>}}
\if{latex}{\out{\hypertarget{method-MiesOperator-repr}{}}}
\subsection{Method \code{repr()}}{
Create a \code{\link[base:call]{call}} object representing this operator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MiesOperator$repr(
  skip_defaults = TRUE,
  show_params = TRUE,
  show_constructor_args = TRUE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{skip_defaults}}{(\code{logical(1)})\cr
Whether to skip construction arguments that have their default value. Default \code{TRUE}.}

\item{\code{show_params}}{(\code{logical(1)})\cr
Whether to show \code{\link[paradox:ParamSet]{ParamSet}} values. Default \code{TRUE}.}

\item{\code{show_constructor_args}}{(\code{logical(1)})\cr
Whether to show construction args that are not \code{\link[paradox:ParamSet]{ParamSet}} values. Default \code{TRUE}.}

\item{\code{...}}{(any)\cr
Ignored.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MiesOperator-print"></a>}}
\if{latex}{\out{\hypertarget{method-MiesOperator-print}{}}}
\subsection{Method \code{print()}}{
Print this operator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MiesOperator$print(verbose = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{(\code{logical(1)})\cr
Whether to show all construction arguments, even the ones at default values. Default \code{FALSE}.}

\item{\code{...}}{(any)\cr
Ignored.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MiesOperator-prime"></a>}}
\if{latex}{\out{\hypertarget{method-MiesOperator-prime}{}}}
\subsection{Method \code{prime()}}{
Prepare the \code{MiesOperator} to function on the given \code{\link[paradox:ParamSet]{ParamSet}}. This must be called before
\verb{$operate()}. It may be called multiple times in the lifecycle of the \code{MiesOperator} object, and prior primings are
forgotten when priming on a new \code{\link[paradox:ParamSet]{ParamSet}}. The \code{\link[paradox:ParamSet]{ParamSet}} on which
the \code{MiesOperator} was last primed can be read from \verb{$primed_ps}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MiesOperator$prime(param_set)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
The \code{\link[paradox:ParamSet]{ParamSet}} to which all \code{values} tables passed to \verb{$operate()} will need to conform to.
May only contiain \code{\link[paradox:Domain]{Domain}} objects that conform to the classes listed in \verb{$param_classes}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MiesOperator-operate"></a>}}
\if{latex}{\out{\hypertarget{method-MiesOperator-operate}{}}}
\subsection{Method \code{operate()}}{
Operate on the given individuals. This calls private \verb{$.operate()}, which must be overloaded by an inheriting class,
passing through all function arguments after performing some checks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MiesOperator$operate(values, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{(\code{data.frame})\cr
Individuals to operate on. Must pass the check of the \code{\link[paradox:ParamSet]{ParamSet}} given in the last \verb{$prime()} call
and may not have any missing components.}

\item{\code{...}}{(any)\cr
Depending on the concrete class, passed on to \verb{$.operate()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{data.frame}: the result of the operation. If the input was a \code{\link[data.table:data.table]{data.table}} instead of
a \code{data.frame}, the output is also \code{\link[data.table:data.table]{data.table}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MiesOperator-help"></a>}}
\if{latex}{\out{\hypertarget{method-MiesOperator-help}{}}}
\subsection{Method \code{help()}}{
Run \code{\link[utils:help]{utils::help()}} for this object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MiesOperator$help(help_type = getOption("help_type"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{help_type}}{(\code{character(1)})\cr
One of \code{"text"}, \code{"html"}, or \code{"pdf"}: The type of help page to open. Defaults to the \code{"help_type"} option.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{help_files_with_dopic} object, which opens the help page.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MiesOperator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MiesOperator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MiesOperator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
