% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScalorAggregate.R
\name{dict_scalors_aggregate}
\alias{dict_scalors_aggregate}
\alias{ScalorAggregate}
\title{Scalor giving Weighted Sum of Multiple Scalors}
\description{
\code{\link{Scalor}} that applies multiple other \code{\link{Scalor}}s and calculates their weighted sum.
}
\section{Configuration Parameters}{

This operation has the configuration parameters of the \code{\link{Scalor}}s that it wraps: The configuration
parameters of the operator given to the \code{scalors} construction argument are prefixed with \code{"scalor_1"},
\code{"scalor_2"}, ... up to \code{"scalor_#"}, where \verb{#} is \code{length(scalors)}.

Additional configuration parameters:
\itemize{
\item \code{weight_1}, \code{weight_2}, ... :: \code{numeric(1)}\cr
Weight factors of \code{scalors[[1]]}, \code{scalors[[2]]}, etc. Depending on \code{scaling}, the outputs of \code{scalors}
is multiplied with this (when \code{scaling} is \code{"linear"} or \code{"rank"}), or ties between ranks are broken
with it (when \code{scaling} is \code{"tiebreak"}). Initialized to 1.
\item \code{scaling} :: \code{character(1)}\cr
How to calculate output values, one of \code{"linear"}, \code{"rank"} or \code{"tiebreak"}. When \code{scaling} is \code{"linear"},
then the output is calculated as the weighted sum of the outputs of \code{scalors}, weighted by \code{weight_1},
\code{weight_2} etc. When \code{scaling} is \code{"rank"}, then the output is calculated as the weighted sum of the
\code{rank()} of \code{scalors}, weighted by \code{weight_1}, \code{weight_2} etc., with ties broken by average. When \code{scaling}
is \code{"tiebreak"}, then the output is calculated as the averaged \code{rank()} of the \code{scalors} with the
highest \code{weight_#}, with ties broken by the average \code{rank()} of the second highest \code{weight_#}, with
remaining ties broken by \code{scalors} with third highest \code{weight_#} etc. Initialized to \code{"linear"}.
\item \code{scale_output} :: \code{logical(1)}\cr
Whether to scale the output to lie between 0 and 1. Initialized to \code{FALSE}.
}
}

\section{Dictionary}{

This \code{\link{Scalor}} can be created with the short access form \code{\link[=scl]{scl()}}
(\code{\link[=scls]{scls()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_scalors}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
scl("aggregate", <scalors>)
scls("aggregate", <scalors>)  # takes vector IDs, returns list of Scalors

# long form:
dict_scalors$get("aggregate", <scalors>)
}\if{html}{\out{</div>}}
}

\examples{
p = ps(x = p_dbl(-5, 5))
data = data.frame(x = rep(0, 5))

sa = scl("aggregate", list(
    scl("one", objective = 1),
    scl("one", objective = 2)
))
sa$prime(p)

(fitnesses = matrix(c(1, 5, 2, 3, 0, 3, 1, 0, 10, 8), ncol = 2))

# to see the fitness matrix, use:
## plot(fitnesses, pch = as.character(1:5))

# default weight 1 -- sum of both objectives
sa$operate(data, fitnesses)

# only first objective
sa$param_set$values[c("weight_1", "weight_2")] = c(1, 0)
sa$operate(data, fitnesses)

# only 2 * second objective
sa$param_set$values[c("weight_1", "weight_2")] = c(0, 2)
sa$operate(data, fitnesses)
}
\seealso{
Other scalors: 
\code{\link{Scalor}},
\code{\link{dict_scalors_domcount}},
\code{\link{dict_scalors_fixedprojection}},
\code{\link{dict_scalors_hypervolume}},
\code{\link{dict_scalors_nondom}},
\code{\link{dict_scalors_one}},
\code{\link{dict_scalors_proxy}},
\code{\link{dict_scalors_single}}

Other scalor wrappers: 
\code{\link{dict_scalors_fixedprojection}},
\code{\link{dict_scalors_proxy}}
}
\concept{scalor wrappers}
\concept{scalors}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Scalor]{miesmuschel::Scalor}} -> \code{ScalorAggregate}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{scalors}}{(\code{list} of \code{\link{Scalor}})\cr
\code{\link{Scalor}}s being wrapped. These operators are run and their outputs weighted.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ScalorAggregate-new}{\code{ScalorAggregate$new()}}
\item \href{#method-ScalorAggregate-prime}{\code{ScalorAggregate$prime()}}
\item \href{#method-ScalorAggregate-clone}{\code{ScalorAggregate$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScalorAggregate-new"></a>}}
\if{latex}{\out{\hypertarget{method-ScalorAggregate-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{ScalorAggregate} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScalorAggregate$new(scalors)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scalors}}{(\code{list} of \code{\link{Scalor}})\cr
\code{\link{Scalor}}s to wrap. The operations are run and weighted by \code{weight_#} configuration parameters,
depending on the \code{scaling} configuration parameter.
The constructed object gets a \emph{clone} of this argument. The \verb{$scalors} field will reflect this value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScalorAggregate-prime"></a>}}
\if{latex}{\out{\hypertarget{method-ScalorAggregate-prime}{}}}
\subsection{Method \code{prime()}}{
See \code{\link{MiesOperator}} method. Primes both this operator, as well as the wrapped operators
given to \code{scalors} during construction.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScalorAggregate$prime(param_set)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
Passed to \code{\link{MiesOperator}}\verb{$prime()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScalorAggregate-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ScalorAggregate-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScalorAggregate$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
