% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FiltorProxy.R
\name{dict_filtors_proxy}
\alias{dict_filtors_proxy}
\alias{FiltorProxy}
\title{Proxy-Filtor that Filters According to its Configuration Parameter}
\description{
Filtor that performs the operation in its \code{operation} configuration parameter. This can be used to make filtor operations fully parametrizable.
}
\section{Configuration Parameters}{

\itemize{
\item \code{operation} :: \code{\link{Filtor}}\cr
Operation to perform. Must be set by the user.
This is primed when \verb{$prime()} of \code{SelectorProxy} is called, and also when \verb{$operate()} is called, to make changing
the operation as part of self-adaption possible. However, if the same operation gets used inside multiple \code{SelectorProxy}
objects, then it is recommended to \verb{$clone(deep = TRUE)} the object before assigning them to \code{operation} to avoid
frequent re-priming.
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Param]{Param}} classes are: \code{\link[paradox:ParamLgl]{ParamLgl}}, \code{\link[paradox:ParamInt]{ParamInt}}, \code{\link[paradox:ParamDbl]{ParamDbl}}, \code{\link[paradox:ParamFct]{ParamFct}}
}

\section{Dictionary}{

This \code{\link{Selector}} can be created with the short access form \code{\link[=sel]{sel()}}
(\code{\link[=sels]{sels()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_selectors}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
sel("proxy")
sels("proxy")  # takes vector IDs, returns list of Selectors

# long form:
dict_selectors$get("proxy")
}\if{html}{\out{</div>}}
}

\examples{
library("mlr3")
library("mlr3learners")
fp = ftr("proxy")
p = ps(x = p_dbl(-5, 5))
known_data = data.frame(x = 1:5)
fitnesses = 1:5
new_data = data.frame(x = c(2.5, 4.5))

fp$param_set$values$operation = ftr("null")
fp$prime(p)
fp$operate(new_data, known_data, fitnesses, 1)

fp$param_set$values$operation = ftr("surprog", lrn("regr.lm"), filter.pool_factor = 2)
fp$operate(new_data, known_data, fitnesses, 1)
}
\seealso{
Other filtors: 
\code{\link{FiltorSurrogate}},
\code{\link{Filtor}},
\code{\link{dict_filtors_maybe}},
\code{\link{dict_filtors_null}},
\code{\link{dict_filtors_surprog}},
\code{\link{dict_filtors_surtour}}

Other filtor wrappers: 
\code{\link{dict_filtors_maybe}}
}
\concept{filtor wrappers}
\concept{filtors}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Filtor]{miesmuschel::Filtor}} -> \code{FiltorProxy}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FiltorProxy-new}{\code{FiltorProxy$new()}}
\item \href{#method-FiltorProxy-prime}{\code{FiltorProxy$prime()}}
\item \href{#method-FiltorProxy-clone}{\code{FiltorProxy$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="Filtor" data-id="needed_input"><a href='../../miesmuschel/html/Filtor.html#method-Filtor-needed_input'><code>miesmuschel::Filtor$needed_input()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FiltorProxy-new"></a>}}
\if{latex}{\out{\hypertarget{method-FiltorProxy-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{FiltorProxy} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FiltorProxy$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FiltorProxy-prime"></a>}}
\if{latex}{\out{\hypertarget{method-FiltorProxy-prime}{}}}
\subsection{Method \code{prime()}}{
See \code{\link{MiesOperator}} method. Primes both this operator, as well as the operator given to the \code{operation} configuration parameter.
Note that this modifies the \verb{$param_set$values$operation} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FiltorProxy$prime(param_set)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
Passed to \code{\link{MiesOperator}}\verb{$prime()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FiltorProxy-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FiltorProxy-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FiltorProxy$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
