% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_sgl.R
\name{predict.reg_sgl}
\alias{predict.reg_sgl}
\title{Computes prediction for the sg-LASSO linear regression}
\usage{
\method{predict}{reg_sgl}(object, newX, ...)
}
\arguments{
\item{object}{fit object from sglassofit.}

\item{newX}{matrix of out-of-sample covariate observations.}

\item{...}{currently ignored optional parameters.}
}
\value{
a list of these variables:

pred - overall prediction.

predZ - intercept prediction.

predX - covariates prediction.
}
\description{
Computes prediction for the sg-LASSO linear regression
}
\examples{
set.seed(1)
x <- matrix(rnorm(100 * 20), 100, 20)
y <- rnorm(100)
index <- 1:20
fit <- reg_sgl(X = x, y = y, index = index, gamma_w = 1, method_choice = "ic", 
       num_cores = 2, verbose = FALSE)
predict.reg_sgl(object = fit, newX = x)
}
\author{
Jonas Striaukas
}
