% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gff.R
\name{gff2fasta}
\alias{gff2fasta}
\title{Retrieving annotated sequences}
\usage{
gff2fasta(gff.table, genome)
}
\arguments{
\item{gff.table}{A \code{gff.table} (\code{data.frame}) with genomic features information.}

\item{genome}{A \code{\link{Fasta}} object with the genome sequence(s).}
}
\value{
A \code{\link{Fasta}} object with one row for each row in \code{gff.table}. 
The \code{Header} for each sequence is a summary of the information in the
corresponding row of \code{gff.table}.
}
\description{
Retrieving from a genome the sequences specified in a \code{gff.table}.
}
\details{
Each row in \code{gff.table} (see \code{\link{readGFF}}) describes a genomic feature
in the \code{genome}. The information in the columns Seqid, Start, End and Strand are used to retrieve
the sequences from \code{genome$Sequence}. Every Seqid in the \code{gff.table}
must match the first token in one of the \code{genome$Header} texts.
}
\examples{
# Using two files in this package
xpth <- file.path(path.package("microseq"),"extdata")
gff.file <- file.path(xpth,"small.gff")
genome.file <- file.path(xpth,"small_genome.fasta")

# Reading
gff.table <- readGFF(gff.file)
genome <- readFasta(genome.file)

# Retrieving sequences
fasta.obj <- gff2fasta(gff.table,genome)
summary(fasta.obj)
plot(fasta.obj)

}
\seealso{
\code{\link{readGFF}}, \code{\link{findOrfs}}.
}
\author{
Lars Snipen and Kristian Hovde Liland.
}
