% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraintFunctions.R
\name{doAllSchemeChecks}
\alias{doAllSchemeChecks}
\title{check whether either a 1 subject or multiple subject microsampling scheme meets imposed constraints}
\usage{
doAllSchemeChecks(object, level, checks)
}
\arguments{
\item{object}{a logical vector or matrix, TRUE when a sample is taken for a subject (row) and time point (column) combination}

\item{level}{a character vector indicating either "subject" or "scheme" level}

\item{checks}{a dataframe with check definitions}
}
\value{
logical value TRUE when all checks are pasted and FALSE if at least one check fails
}
\description{
check whether either a 1 subject or multiple subject microsampling scheme meets imposed constraints
}
\examples{
  exampleChecks    <- getConstraintsExample()
  exampleSubject1  <-  c( TRUE  , TRUE  , TRUE , FALSE , FALSE , TRUE )
  exampleSubject2  <-  c( FALSE , FALSE , TRUE , FALSE , FALSE , TRUE )
  exampleScheme    <-  rbind( exampleSubject1, exampleSubject2 ) 
  doAllSchemeChecks( exampleSubject1 , "subject" , checks = exampleChecks )
  doAllSchemeChecks( exampleSubject2 , "subject" , checks = exampleChecks )
  doAllSchemeChecks( exampleScheme , "scheme" , checks = exampleChecks )
}
