% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_norm.R
\name{trans_norm}
\alias{trans_norm}
\title{Feature abundance normalization/transformation.}
\description{
Feature abundance normalization/transformation for a microtable object or data.frame object.
}
\examples{

## ------------------------------------------------
## Method `trans_norm$new`
## ------------------------------------------------

library(microeco)
data(dataset)
t1 <- trans_norm$new(dataset = dataset)

## ------------------------------------------------
## Method `trans_norm$norm`
## ------------------------------------------------

newdataset <- t1$norm(method = "log")
newdataset <- t1$norm(method = "clr")
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-trans_norm-new}{\code{trans_norm$new()}}
\item \href{#method-trans_norm-norm}{\code{trans_norm$norm()}}
\item \href{#method-trans_norm-clone}{\code{trans_norm$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_norm-new"></a>}}
\if{latex}{\out{\hypertarget{method-trans_norm-new}{}}}
\subsection{Method \code{new()}}{
Get a transposed abundance table if the input is microtable object. In the table, rows are samples, and columns are features. 
  This can make the further operations same with the traditional ecological methods.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_norm$new(dataset = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{the \code{\link{microtable}} object or \code{data.frame} object. 
If it is \code{data.frame} object, please make sure that rows are samples, and columns are features.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
data_table, stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(microeco)
data(dataset)
t1 <- trans_norm$new(dataset = dataset)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_norm-norm"></a>}}
\if{latex}{\out{\hypertarget{method-trans_norm-norm}{}}}
\subsection{Method \code{norm()}}{
Normalization/transformation methods.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_norm$norm(
  method = NULL,
  MARGIN = NULL,
  logbase = 2,
  Cmin = NULL,
  pseudocount = 1,
  intersect.no = 10,
  ct.min = 1,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{default NULL; See the following details and available options. \cr 
\cr 
Methods for normalization:
\itemize{
  \item \code{GMPR}: Geometric mean of pairwise ratios <doi: 10.7717/peerj.4600>. 
            For a given sample \eqn{i}, the size factor \eqn{s_i} is defined:
                \deqn{s_i = \lgroup {\displaystyle\prod_{j=1}^{n} r_{ij}} \rgroup ^{1/n}}
            where \eqn{r_{ij} = Median_{k|c_{ki}c_{kj} \ne 0} \lbrace \dfrac{c_{ki}}{c_{kj}} \rbrace}. 
            \eqn{r_{ij}} is the median count ratio of nonzero counts between sample \eqn{i} and \eqn{j}.
            \eqn{k} denotes all the features. For sample \eqn{i}, \eqn{GMPR = \frac{x_{i}}{s_i}}, where \eqn{x_i} is the feature abundances of sample \eqn{i}.
  \item \code{clr}: Centered log-ratio normalization <ISBN:978-0-412-28060-3> <doi: 10.3389/fmicb.2017.02224>. 
            It is defined:  \deqn{clr_{ki} = \log\frac{x_{ki}}{g(x_i)}}
            where \eqn{x_{ki}} is the abundance of \eqn{k}th feature in sample \eqn{i}, \eqn{g(x_i)} is the geometric mean of abundances for sample \eqn{i}.
            A pseudocount need to be added to deal with the zero. For more information, please see the 'clr' method in \code{decostand} function of vegan package.
  \item \code{rclr}: Robust centered log-ratio normalization <doi: doi:10.1128/msystems.00016-19>.
            It is defined:  \deqn{rclr_{ki} = \log\frac{x_{ki}}{g(x_i > 0)}}
            where \eqn{x_{ki}} is the abundance of \eqn{k}th feature in sample \eqn{i}, \eqn{g(x_i > 0)} is the geometric mean of abundances (> 0) for sample \eqn{i}.
            In rclr, zero values are kept as zeroes, and not taken into account.
  \item \code{CCS}: Cumulative sum scaling normalization based on the \code{metagenomeSeq} package <doi:10.1038/nmeth.2658>.
            For a given sample \eqn{j}, the scaling factor \eqn{s_{j}^{l}} is defined:
                \deqn{s_{j}^{l} = {\displaystyle\sum_{i|c_{ij} \leqslant q_{j}^{l}} c_{ij}}}
            where \eqn{q_{j}^{l}} is the \eqn{l}th quantile of sample \eqn{j}, that is, in sample \eqn{j} there are \eqn{l} features with counts smaller than \eqn{q_{j}^{l}}.
            \eqn{c_{ij}} denotes the count (abundance) of feature i in sample \eqn{j}.
            For \eqn{l} = 0.95\eqn{m} (feature number), \eqn{q_{j}^{l}} corresponds to the 95th percentile of the count distribution for sample \eqn{j}.
            Normalized counts \eqn{\tilde{c_{ij}} = (\frac{c_{ij}}{s_{j}^{l}})(N)}, where \eqn{N} is an appropriately chosen normalization constant.
  \item \code{TSS}: Total sum scaling, divided by the sequencing depth.
  \item \code{TMM}: Trimmed mean of M-values method based on the \code{normLibSizes} function of \code{edgeR} package <doi: 10.1186/gb-2010-11-3-r25>.
  \item \code{RLE}: Relative log expression. 
  \item \code{SRS}: scaling with ranked subsampling method based on the SRS package provided by Lukas Beule and Petr Karlovsky (2020) <DOI:10.7717/peerj.9593>.
}
Methods based on \code{\link{decostand}} function:
\itemize{
  \item \code{total}: divide by margin total (default MARGIN = 1, i.e. rows - samples).
  \item \code{max}: divide by margin maximum (default MARGIN = 2, i.e. columns - features).
  \item \code{normalize}:  make margin sum of squares equal to one (default MARGIN = 1).
  \item \code{range}: standardize values into range 0...1 (default MARGIN = 2). If all values are constant, they will be transformed to 0.
  \item \code{standardize}: scale x to zero mean and unit variance (default MARGIN = 2).
  \item \code{pa}: scale x to presence/absence scale (0/1).
  \item \code{log}: logarithmic transformation as suggested by Anderson et al. (2006): log_b (x) + 1 for x > 0, where b is the base of the logarithm; zeros are left as zeros. Higher bases give less weight to quantities and more to presences, and logbase = Inf gives the presence/absence scaling. Please note this is not log(x+1). Anderson et al. (2006) suggested this for their (strongly) modified Gower distance (implemented as method = "altGower" in vegdist), but the standardization can be used independently of distance indices.
}
Other methods for transformation:
\itemize{
  \item \code{AST}: Arc sine square root transformation.
}}

\item{\code{MARGIN}}{default NULL; 1 = samples, and 2 = features of abundance table; only available when method comes from \code{\link{decostand}} function.
If MARGIN is NULL, use the default value in decostand function.}

\item{\code{logbase}}{default exp(1); The logarithm base.}

\item{\code{Cmin}}{default NULL; see Cmin parameter in \code{SRS::SRS} function; Only available when \code{method = "SRS"}.
If not provided, use the minimum number across all the samples.}

\item{\code{pseudocount}}{default 1; add pseudocount for those features with 0 abundance when \code{method = "clr"}.}

\item{\code{intersect.no}}{default 10; the intersecting taxa number between paired sample for \code{method = "GMPR"}.}

\item{\code{ct.min}}{default 1; the minimum number of counts required to calculate ratios for \code{method = "GMPR"}.}

\item{\code{...}}{parameters pass to \code{\link{decostand}}, or \code{metagenomeSeq::cumNorm} when method = "CCS", or 
\code{edgeR::normLibSizes} when method = "TMM" or "RLE".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
new microtable object or data.frame object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{newdataset <- t1$norm(method = "log")
newdataset <- t1$norm(method = "clr")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_norm-clone"></a>}}
\if{latex}{\out{\hypertarget{method-trans_norm-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_norm$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
