% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_network.R
\name{trans_network}
\alias{trans_network}
\title{Create \code{trans_network} object for network analysis.}
\description{
This class is a wrapper for a series of network analysis methods, 
including the network construction, network attributes analysis,
eigengene analysis, network subsetting, node and edge properties, network visualization and other operations.
}
\examples{

## ------------------------------------------------
## Method `trans_network$new`
## ------------------------------------------------

\donttest{
data(dataset)
# for correlation network
t1 <- trans_network$new(dataset = dataset, cor_method = "pearson", 
		taxa_level = "OTU", filter_thres = 0.0002)
# for non-correlation network
t1 <- trans_network$new(dataset = dataset, cor_method = NULL)
}

## ------------------------------------------------
## Method `trans_network$cal_network`
## ------------------------------------------------

\dontrun{
# for correlation network
t1 <- trans_network$new(dataset = dataset, cor_method = "pearson", 
		taxa_level = "OTU", filter_thres = 0.001)
t1$cal_network(COR_p_thres = 0.05, COR_cut = 0.6)
t1 <- trans_network$new(dataset = dataset, cor_method = NULL, filter_thres = 0.003)
t1$cal_network(network_method = "SpiecEasi", SpiecEasi_method = "mb")
t1 <- trans_network$new(dataset = dataset, cor_method = NULL, filter_thres = 0.005)
t1$cal_network(network_method = "beemStatic")
t1 <- trans_network$new(dataset = dataset, cor_method = NULL, filter_thres = 0.001)
t1$cal_network(network_method = "FlashWeave")
}

## ------------------------------------------------
## Method `trans_network$cal_module`
## ------------------------------------------------

\donttest{
t1 <- trans_network$new(dataset = dataset, cor_method = "pearson", 
		taxa_level = "OTU", filter_thres = 0.0002)
t1$cal_network(COR_p_thres = 0.01, COR_cut = 0.6)
t1$cal_module(method = "cluster_fast_greedy")
}

## ------------------------------------------------
## Method `trans_network$save_network`
## ------------------------------------------------

\dontrun{
t1$save_network(filepath = "network.gexf")
}

## ------------------------------------------------
## Method `trans_network$cal_network_attr`
## ------------------------------------------------

\donttest{
t1$cal_network_attr()
}

## ------------------------------------------------
## Method `trans_network$get_node_table`
## ------------------------------------------------

\donttest{
t1$get_node_table(node_roles = TRUE)
}

## ------------------------------------------------
## Method `trans_network$get_edge_table`
## ------------------------------------------------

\donttest{
t1$get_edge_table()
}

## ------------------------------------------------
## Method `trans_network$get_adjacency_matrix`
## ------------------------------------------------

\donttest{
t1$get_adjacency_matrix(attr = "weight")
}

## ------------------------------------------------
## Method `trans_network$plot_network`
## ------------------------------------------------

\donttest{
t1$plot_network(method = "igraph", layout = layout_with_kk)
t1$plot_network(method = "ggraph", node_color = "module")
t1$plot_network(method = "networkD3", node_color = "module")
}

## ------------------------------------------------
## Method `trans_network$cal_eigen`
## ------------------------------------------------

\donttest{
t1$cal_eigen()
}

## ------------------------------------------------
## Method `trans_network$plot_taxa_roles`
## ------------------------------------------------

\donttest{
t1$plot_taxa_roles(roles_color_background = FALSE)
}

## ------------------------------------------------
## Method `trans_network$subset_network`
## ------------------------------------------------

\donttest{
t1$subset_network(node = t1$res_node_table \%>\% base::subset(module == "M1") \%>\% 
  rownames, rm_single = TRUE)
# return a sub network that contains all nodes of module M1
}

## ------------------------------------------------
## Method `trans_network$cal_powerlaw`
## ------------------------------------------------

\donttest{
t1$cal_powerlaw()
}

## ------------------------------------------------
## Method `trans_network$cal_sum_links`
## ------------------------------------------------

\donttest{
t1$cal_sum_links(taxa_level = "Phylum")
}

## ------------------------------------------------
## Method `trans_network$plot_sum_links`
## ------------------------------------------------

\dontrun{
test1$plot_sum_links(plot_pos = TRUE, plot_num = 10)
}

## ------------------------------------------------
## Method `trans_network$random_network`
## ------------------------------------------------

\dontrun{
t1$random_network(runs = 100)
}

## ------------------------------------------------
## Method `trans_network$trans_comm`
## ------------------------------------------------

\donttest{
t2 <- t1$trans_comm(use_col = "module")
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-trans_network-new}{\code{trans_network$new()}}
\item \href{#method-trans_network-cal_network}{\code{trans_network$cal_network()}}
\item \href{#method-trans_network-cal_module}{\code{trans_network$cal_module()}}
\item \href{#method-trans_network-save_network}{\code{trans_network$save_network()}}
\item \href{#method-trans_network-cal_network_attr}{\code{trans_network$cal_network_attr()}}
\item \href{#method-trans_network-get_node_table}{\code{trans_network$get_node_table()}}
\item \href{#method-trans_network-get_edge_table}{\code{trans_network$get_edge_table()}}
\item \href{#method-trans_network-get_adjacency_matrix}{\code{trans_network$get_adjacency_matrix()}}
\item \href{#method-trans_network-plot_network}{\code{trans_network$plot_network()}}
\item \href{#method-trans_network-cal_eigen}{\code{trans_network$cal_eigen()}}
\item \href{#method-trans_network-plot_taxa_roles}{\code{trans_network$plot_taxa_roles()}}
\item \href{#method-trans_network-subset_network}{\code{trans_network$subset_network()}}
\item \href{#method-trans_network-cal_powerlaw}{\code{trans_network$cal_powerlaw()}}
\item \href{#method-trans_network-cal_sum_links}{\code{trans_network$cal_sum_links()}}
\item \href{#method-trans_network-plot_sum_links}{\code{trans_network$plot_sum_links()}}
\item \href{#method-trans_network-random_network}{\code{trans_network$random_network()}}
\item \href{#method-trans_network-trans_comm}{\code{trans_network$trans_comm()}}
\item \href{#method-trans_network-print}{\code{trans_network$print()}}
\item \href{#method-trans_network-clone}{\code{trans_network$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_network-new"></a>}}
\if{latex}{\out{\hypertarget{method-trans_network-new}{}}}
\subsection{Method \code{new()}}{
Create the \code{trans_network} object, store the important intermediate data 
  and calculate correlations if \code{cor_method} parameter is not NULL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$new(
  dataset = NULL,
  cor_method = NULL,
  use_WGCNA_pearson_spearman = FALSE,
  use_NetCoMi_pearson_spearman = FALSE,
  use_sparcc_method = c("NetCoMi", "SpiecEasi")[1],
  taxa_level = "OTU",
  filter_thres = 0,
  nThreads = 1,
  SparCC_simu_num = 100,
  env_cols = NULL,
  add_data = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{default NULL; the object of \code{\link{microtable}} class. Default NULL means customized analysis.}

\item{\code{cor_method}}{default NULL; NULL or one of "bray", "pearson", "spearman", "sparcc", "bicor", "cclasso" and "ccrepe";
All the methods refered to \code{NetCoMi} package are performed based on \code{netConstruct} function of \code{NetCoMi} package and require
\code{NetCoMi} to be installed from Github (\href{https://github.com/stefpeschel/NetCoMi}{https://github.com/stefpeschel/NetCoMi});
For the algorithm details, please see Peschel et al. 2020 Brief. Bioinform <doi: 10.1093/bib/bbaa290>;
\describe{
  \item{\strong{NULL}}{NULL denotes non-correlation network, i.e. do not use correlation-based network. 
    If so, the return res_cor_p list will be NULL.}
  \item{\strong{'bray'}}{1-B, where B is Bray–Curtis dissimilarity; based on \code{vegan::vegdist} function}
  \item{\strong{'pearson'}}{Pearson correlation; If \code{use_WGCNA_pearson_spearman} and \code{use_NetCoMi_pearson_spearman} are both FALSE, 
    use the function \code{cor.test} in R; \code{use_WGCNA_pearson_spearman = TRUE} invoke \code{corAndPvalue} function of \code{WGCNA} package; 
    \code{use_NetCoMi_pearson_spearman = TRUE} invoke \code{netConstruct} function of \code{NetCoMi} package}
  \item{\strong{'spearman'}}{Spearman correlation; other details are same with the 'pearson' option}
  \item{\strong{'sparcc'}}{SparCC algorithm (Friedman & Alm, PLoS Comp Biol, 2012, <doi:10.1371/journal.pcbi.1002687>);
       use NetCoMi package when \code{use_sparcc_method = "NetCoMi"}; use \code{SpiecEasi} package when \code{use_sparcc_method = "SpiecEasi"} 
       and require \code{SpiecEasi} to be installed from Github
       (\href{https://github.com/zdk123/SpiecEasi}{https://github.com/zdk123/SpiecEasi})}
  \item{\strong{'bicor'}}{Calculate biweight midcorrelation efficiently for matrices based on \code{WGCNA::bicor} function; 
    This option can invoke \code{netConstruct} function of \code{NetCoMi} package;
    Make sure \code{WGCNA} and \code{NetCoMi} packages are both installed}
  \item{\strong{'cclasso'}}{Correlation inference of Composition data through Lasso method based on \code{netConstruct} function of \code{NetCoMi} package; 
       for details, see \code{NetCoMi::cclasso} function}
  \item{\strong{'ccrepe'}}{Calculates compositionality-corrected p-values and q-values for compositional data 
       using an arbitrary distance metric based on \code{NetCoMi::netConstruct} function; also see \code{NetCoMi::ccrepe} function}
}}

\item{\code{use_WGCNA_pearson_spearman}}{default FALSE; whether use WGCNA package to calculate correlation when \code{cor_method} = "pearson" or "spearman".}

\item{\code{use_NetCoMi_pearson_spearman}}{default FALSE; whether use NetCoMi package to calculate correlation when \code{cor_method} = "pearson" or "spearman".
The important difference between NetCoMi and others is the features of zero handling and data normalization; See <doi: 10.1093/bib/bbaa290>.}

\item{\code{use_sparcc_method}}{default \code{c("NetCoMi", "SpiecEasi")[1]}; 
use \code{NetCoMi} package or \code{SpiecEasi} package to perform SparCC when \code{cor_method = "sparcc"}.}

\item{\code{taxa_level}}{default "OTU"; taxonomic rank; 'OTU' denotes using feature abundance table; 
other available options should be one of the colnames of \code{tax_table} of input dataset.}

\item{\code{filter_thres}}{default 0; the relative abundance threshold.}

\item{\code{nThreads}}{default 1; the CPU thread number; available when \code{use_WGCNA_pearson_spearman = TRUE} or \code{use_sparcc_method = "SpiecEasi"}.}

\item{\code{SparCC_simu_num}}{default 100; SparCC simulation number for bootstrap when \code{use_sparcc_method = "SpiecEasi"}.}

\item{\code{env_cols}}{default NULL; numeric or character vector to select the column names of environmental data in dataset$sample_table;
the environmental data can be used in the correlation network (as the nodes) or \code{FlashWeave} network.}

\item{\code{add_data}}{default NULL; provide environmental variable table additionally instead of \code{env_cols} parameter; rownames must be sample names.}

\item{\code{...}}{parameters pass to \code{NetCoMi::netConstruct} for other operations, such as zero handling and/or data normalization 
when cor_method and other parameters refer to \code{NetCoMi} package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_cor_p} list with the correlation (association) matrix and p value matrix. Note that when \code{cor_method} and other parameters
   refer to \code{NetCoMi} package, the p value table are all zero as the significant associations have been selected.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
data(dataset)
# for correlation network
t1 <- trans_network$new(dataset = dataset, cor_method = "pearson", 
		taxa_level = "OTU", filter_thres = 0.0002)
# for non-correlation network
t1 <- trans_network$new(dataset = dataset, cor_method = NULL)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_network-cal_network"></a>}}
\if{latex}{\out{\hypertarget{method-trans_network-cal_network}{}}}
\subsection{Method \code{cal_network()}}{
Construct network based on the \code{igraph} package or \code{SpiecEasi} package or \code{julia FlashWeave} package or \code{beemStatic} package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$cal_network(
  network_method = c("COR", "SpiecEasi", "gcoda", "FlashWeave", "beemStatic")[1],
  COR_p_thres = 0.01,
  COR_p_adjust = "fdr",
  COR_weight = TRUE,
  COR_cut = 0.6,
  COR_optimization = FALSE,
  COR_optimization_low_high = c(0.01, 0.8),
  COR_optimization_seq = 0.01,
  SpiecEasi_method = "mb",
  FlashWeave_tempdir = NULL,
  FlashWeave_meta_data = FALSE,
  FlashWeave_other_para = "alpha=0.01,sensitive=true,heterogeneous=true",
  beemStatic_t_strength = 0.001,
  beemStatic_t_stab = 0.8,
  add_taxa_name = "Phylum",
  delete_unlinked_nodes = TRUE,
  usename_rawtaxa_when_taxalevel_notOTU = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{network_method}}{default "COR"; "COR", "SpiecEasi", "gcoda", "FlashWeave" or "beemStatic"; 
\code{network_method = NULL} means skipping the network construction for the customized use.
The option details: 
\describe{
  \item{\strong{'COR'}}{correlation-based network; use the correlation and p value matrices in \code{res_cor_p} list stored in the object; 
        See Deng et al. (2012) <doi:10.1186/1471-2105-13-113> for other details}
  \item{\strong{'SpiecEasi'}}{\code{SpiecEasi} network; relies on algorithms of sparse neighborhood and inverse covariance selection;
        belong to the category of conditional dependence and graphical models;
        see \href{https://github.com/zdk123/SpiecEasi}{https://github.com/zdk123/SpiecEasi} for installing the R package; 
        see Kurtz et al. (2015) <doi:10.1371/journal.pcbi.1004226> for the algorithm details}
  \item{\strong{'gcoda'}}{hypothesize the logistic normal distribution of microbiome data; use penalized maximum likelihood method to estimate
        the sparse structure of inverse covariance for latent normal variables to address the high dimensionality of the microbiome data;
        belong to the category of conditional dependence and graphical models;
        depend on the R \code{NetCoMi} package \href{https://github.com/stefpeschel/NetCoMi}{https://github.com/stefpeschel/NetCoMi}; 
        see FANG et al. (2017) <doi:10.1089/cmb.2017.0054> for the algorithm details}
  \item{\strong{'FlashWeave'}}{\code{FlashWeave} network; Local-to-global learning framework; belong to the category of conditional dependence and graphical models;
     good performance on heterogenous datasets to find direct associations among taxa;
     see \href{https://github.com/meringlab/FlashWeave.jl}{https://github.com/meringlab/FlashWeave.jl} for installing \code{julia} language and 
     \code{FlashWeave} package; julia must be in the computer system env path, otherwise the program can not find it;
     see Tackmann et al. (2019) <doi:10.1016/j.cels.2019.08.002> for the algorithm details}
  \item{\strong{'beemStatic'}}{\code{beemStatic} network;
     extend generalized Lotka-Volterra model to cases of cross-sectional datasets to infer interaction among taxa based on expectation-maximization algorithm;
     see \href{https://github.com/CSB5/BEEM-static}{https://github.com/CSB5/BEEM-static} for installing the R package;
     see Li et al. (2021) <doi:10.1371/journal.pcbi.1009343> for the algorithm details}
}}

\item{\code{COR_p_thres}}{default 0.01; the p value threshold for the correlation-based network.}

\item{\code{COR_p_adjust}}{default "fdr"; p value adjustment method, see \code{method} parameter of \code{p.adjust} function for available options,
in which \code{COR_p_adjust = "none"} means giving up the p value adjustment.}

\item{\code{COR_weight}}{default TRUE; whether use correlation coefficient as the weight of edges; FALSE represents weight = 1 for all edges.}

\item{\code{COR_cut}}{default 0.6; correlation coefficient threshold for the correlation network.}

\item{\code{COR_optimization}}{default FALSE; whether use random matrix theory (RMT) based method to determine the correlation coefficient; 
see https://doi.org/10.1186/1471-2105-13-113}

\item{\code{COR_optimization_low_high}}{default \code{c(0.01, 0.8)}; the low and high value threshold used for the RMT optimization; only useful when COR_optimization = TRUE.}

\item{\code{COR_optimization_seq}}{default 0.01; the interval of correlation coefficient used for RMT optimization; only useful when COR_optimization = TRUE.}

\item{\code{SpiecEasi_method}}{default "mb"; either 'glasso' or 'mb';see spiec.easi function in package SpiecEasi and https://github.com/zdk123/SpiecEasi.}

\item{\code{FlashWeave_tempdir}}{default NULL; The temporary directory used to save the temporary files for running FlashWeave; If not assigned, use the system user temp.}

\item{\code{FlashWeave_meta_data}}{default FALSE; whether use env data for the optimization, If TRUE, the function automatically find the \code{env_data} in the object and
generate a file for meta_data_path parameter of FlashWeave package.}

\item{\code{FlashWeave_other_para}}{default \code{"alpha=0.01,sensitive=true,heterogeneous=true"}; the parameters passed to julia FlashWeave package;
user can change the parameters or add more according to FlashWeave help document;
An exception is meta_data_path parameter as it is generated based on the data inside the object, see FlashWeave_meta_data parameter for the description.}

\item{\code{beemStatic_t_strength}}{default 0.001; for network_method = "beemStatic"; the threshold used to limit the number of interactions (strength);
same with the t.strength parameter in showInteraction function of beemStatic package.}

\item{\code{beemStatic_t_stab}}{default 0.8; for network_method = "beemStatic"; 
the threshold used to limit the number of interactions (stability); same with the t.stab parameter in showInteraction function of beemStatic package.}

\item{\code{add_taxa_name}}{default "Phylum"; one or more taxonomic rank name; used to add taxonomic rank name to network node properties.}

\item{\code{delete_unlinked_nodes}}{default TRUE; whether delete the nodes without any link.}

\item{\code{usename_rawtaxa_when_taxalevel_notOTU}}{default FALSE; whether replace the name of nodes using the taxonomic information.}

\item{\code{...}}{parameters pass to \code{SpiecEasi::spiec.easi} when \code{network_method = "SpiecEasi"};
pass to \code{NetCoMi::netConstruct} when \code{network_method = "gcoda"}; 
pass to \code{beemStatic::func.EM} when \code{network_method = "beemStatic"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_network} stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# for correlation network
t1 <- trans_network$new(dataset = dataset, cor_method = "pearson", 
		taxa_level = "OTU", filter_thres = 0.001)
t1$cal_network(COR_p_thres = 0.05, COR_cut = 0.6)
t1 <- trans_network$new(dataset = dataset, cor_method = NULL, filter_thres = 0.003)
t1$cal_network(network_method = "SpiecEasi", SpiecEasi_method = "mb")
t1 <- trans_network$new(dataset = dataset, cor_method = NULL, filter_thres = 0.005)
t1$cal_network(network_method = "beemStatic")
t1 <- trans_network$new(dataset = dataset, cor_method = NULL, filter_thres = 0.001)
t1$cal_network(network_method = "FlashWeave")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_network-cal_module"></a>}}
\if{latex}{\out{\hypertarget{method-trans_network-cal_module}{}}}
\subsection{Method \code{cal_module()}}{
Calculate network modules and add module names to the network node properties.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$cal_module(
  method = "cluster_fast_greedy",
  module_name_prefix = "M"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{default "cluster_fast_greedy"; the method used to find the optimal community structure of a graph;
the following are available functions (options) from igraph package: \cr
\code{"cluster_fast_greedy"}, \code{"cluster_walktrap"}, \code{"cluster_edge_betweenness"}, \cr
\code{"cluster_infomap"}, \code{"cluster_label_prop"}, \code{"cluster_leading_eigen"}, \cr
\code{"cluster_louvain"}, \code{"cluster_spinglass"}, \code{"cluster_optimal"}. \cr
For the details of these functions, please see the help document, such as \code{help(cluster_fast_greedy)};
Note that the default \code{"cluster_fast_greedy"} method can not be applied to directed network. 
If directed network is provided, the function can automatically switch the default method from \code{"cluster_fast_greedy"} to \code{"cluster_walktrap"}.}

\item{\code{module_name_prefix}}{default "M"; the prefix of module names; module names are made of the module_name_prefix and numbers;
numbers are assigned according to the sorting result of node numbers in modules with decreasing trend.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_network} with modules, stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1 <- trans_network$new(dataset = dataset, cor_method = "pearson", 
		taxa_level = "OTU", filter_thres = 0.0002)
t1$cal_network(COR_p_thres = 0.01, COR_cut = 0.6)
t1$cal_module(method = "cluster_fast_greedy")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_network-save_network"></a>}}
\if{latex}{\out{\hypertarget{method-trans_network-save_network}{}}}
\subsection{Method \code{save_network()}}{
Save network as gexf style, which can be opened by Gephi (\href{https://gephi.org/}{https://gephi.org/}).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$save_network(filepath = "network.gexf")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filepath}}{default "network.gexf"; file path to save the network.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
t1$save_network(filepath = "network.gexf")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_network-cal_network_attr"></a>}}
\if{latex}{\out{\hypertarget{method-trans_network-cal_network_attr}{}}}
\subsection{Method \code{cal_network_attr()}}{
Calculate network properties.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$cal_network_attr()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{res_network_attr} stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_network_attr()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_network-get_node_table"></a>}}
\if{latex}{\out{\hypertarget{method-trans_network-get_node_table}{}}}
\subsection{Method \code{get_node_table()}}{
Get the node property table. The properties may include the node names, modules allocation, degree, betweenness, abundance, 
  taxonomy, within-module connectivity and among-module connectivity <doi:10.1016/j.geoderma.2022.115866>.

Authors: Chi Liu, Umer Zeeshan Ijaz
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$get_node_table(node_roles = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{node_roles}}{default TRUE; whether calculate node roles, i.e. Module hubs, Network hubs, Connectors and Peripherals <doi:10.1016/j.geoderma.2022.115866>.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_node_table} in object; Abundance expressed as a percentage; z denotes within-module connectivity;
  p denotes among-module connectivity.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$get_node_table(node_roles = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_network-get_edge_table"></a>}}
\if{latex}{\out{\hypertarget{method-trans_network-get_edge_table}{}}}
\subsection{Method \code{get_edge_table()}}{
Get the edge property table, including connected nodes, label and weight.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$get_edge_table()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{res_edge_table} in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$get_edge_table()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_network-get_adjacency_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-trans_network-get_adjacency_matrix}{}}}
\subsection{Method \code{get_adjacency_matrix()}}{
Get the adjacency matrix from the network graph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$get_adjacency_matrix(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{parameters passed to as_adjacency_matrix function of \code{igraph} package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_adjacency_matrix} in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$get_adjacency_matrix(attr = "weight")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_network-plot_network"></a>}}
\if{latex}{\out{\hypertarget{method-trans_network-plot_network}{}}}
\subsection{Method \code{plot_network()}}{
Plot the network based on a series of methods from other packages, such as \code{igraph}, \code{ggraph} and \code{networkD3}. 
The networkD3 package provides dynamic network. It is especially useful for a glimpse of the whole network structure and finding 
the interested nodes and edges in a large network. In contrast, the igraph and ggraph methods are suitable for relatively small network.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$plot_network(
  method = c("igraph", "ggraph", "networkD3")[1],
  node_label = "name",
  node_color = NULL,
  ggraph_layout = "fr",
  ggraph_node_size = 2,
  ggraph_node_text = TRUE,
  ggraph_text_color = NULL,
  ggraph_text_size = 3,
  networkD3_node_legend = TRUE,
  networkD3_zoom = TRUE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{default "igraph"; The available options:
\describe{
  \item{\strong{'igraph'}}{call \code{plot.igraph} function in \code{igraph} package for a static network; see plot.igraph for the parameters}
  \item{\strong{'ggraph'}}{call \code{ggraph} function in \code{ggraph} package for a static network}
  \item{\strong{'networkD3'}}{use forceNetwork function in \code{networkD3} package for a dynamic network; see forceNetwork function for the parameters}
}}

\item{\code{node_label}}{default "name"; node label shown in the plot for \code{method = "ggraph"} or \code{method = "networkD3"}; 
Please see the column names of object$res_node_table, which is the returned table of function object$get_node_table;
User can select other column names in res_node_table.}

\item{\code{node_color}}{default NULL; node color assignment for \code{method = "ggraph"} or \code{method = "networkD3"}; 
Select a column name of \code{object$res_node_table}, such as "module".}

\item{\code{ggraph_layout}}{default "fr"; for \code{method = "ggraph"}; see \code{layout} parameter of \code{create_layout} function in \code{ggraph} package.}

\item{\code{ggraph_node_size}}{default 2; for \code{method = "ggraph"}; the node size.}

\item{\code{ggraph_node_text}}{default TRUE; for \code{method = "ggraph"}; whether show the label text of nodes.}

\item{\code{ggraph_text_color}}{default NULL; for \code{method = "ggraph"}; a column name of object$res_node_table used to assign label text colors.}

\item{\code{ggraph_text_size}}{default 3; for \code{method = "ggraph"}; the node label text size.}

\item{\code{networkD3_node_legend}}{default TRUE; used for \code{method = "networkD3"}; logical value to enable node colour legends;
Please see the legend parameter in networkD3::forceNetwork function.}

\item{\code{networkD3_zoom}}{default TRUE; used for \code{method = "networkD3"}; logical value to enable (TRUE) or disable (FALSE) zooming;
Please see the zoom parameter in networkD3::forceNetwork function.}

\item{\code{...}}{parameters passed to \code{plot.igraph} function when \code{method = "igraph"} or forceNetwork function when \code{method = "networkD3"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
network plot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_network(method = "igraph", layout = layout_with_kk)
t1$plot_network(method = "ggraph", node_color = "module")
t1$plot_network(method = "networkD3", node_color = "module")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_network-cal_eigen"></a>}}
\if{latex}{\out{\hypertarget{method-trans_network-cal_eigen}{}}}
\subsection{Method \code{cal_eigen()}}{
Calculate eigengenes of modules, i.e. the first principal component based on PCA analysis, and the percentage of variance <doi:10.1186/1471-2105-13-113>.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$cal_eigen()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{res_eigen} and \code{res_eigen_expla} in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_eigen()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_network-plot_taxa_roles"></a>}}
\if{latex}{\out{\hypertarget{method-trans_network-plot_taxa_roles}{}}}
\subsection{Method \code{plot_taxa_roles()}}{
Plot the classification and importance of nodes, see object$res_node_table for the variable names used in the parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$plot_taxa_roles(
  use_type = c(1, 2)[1],
  roles_color_background = FALSE,
  roles_color_values = NULL,
  add_label = FALSE,
  add_label_group = "Network hubs",
  add_label_text = "name",
  label_text_size = 4,
  label_text_color = "grey50",
  label_text_italic = FALSE,
  plot_module = FALSE,
  x_lim = c(0, 1),
  use_level = "Phylum",
  show_value = c("z", "p"),
  show_number = 1:10,
  plot_color = "Phylum",
  plot_shape = "taxa_roles",
  plot_size = "Abundance",
  color_values = RColorBrewer::brewer.pal(12, "Paired"),
  shape_values = c(16, 17, 7, 8, 15, 18, 11, 10, 12, 13, 9, 3, 4, 0, 1, 2, 14),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_type}}{default 1; 1 or 2; 1 represents taxa roles area plot; 2 represents the layered plot with taxa as x axis.}

\item{\code{roles_color_background}}{default FALSE; for use_type=1; TRUE: use background colors for each area; FALSE: use classic point colors.}

\item{\code{roles_color_values}}{default NULL; for use_type=1; color palette for background or points.}

\item{\code{add_label}}{default FALSE; for use_type = 1; whether add labels for the points.}

\item{\code{add_label_group}}{default "Network hubs"; If add_label = TRUE; which part of tax_roles is used to show labels; character vectors.}

\item{\code{add_label_text}}{default "name"; If add_label = TRUE; which column of object$res_node_table is used to label the text.}

\item{\code{label_text_size}}{default 4; The text size of the label.}

\item{\code{label_text_color}}{default "grey50"; The text color of the label.}

\item{\code{label_text_italic}}{default FALSE; whether use italic style for the label text.}

\item{\code{plot_module}}{default FALSE; for use_type=1; whether plot the modules information.}

\item{\code{x_lim}}{default c(0, 1); for use_type=1; x axis range when roles_color_background = FALSE.}

\item{\code{use_level}}{default "Phylum"; for use_type=2; used taxonomic level in x axis.}

\item{\code{show_value}}{default c("z", "p"); for use_type=2; used variable in y axis.}

\item{\code{show_number}}{default 1:10; for use_type=2; showed number in x axis, sorting according to the nodes number.}

\item{\code{plot_color}}{default "Phylum"; for use_type=2; used variable for color.}

\item{\code{plot_shape}}{default "taxa_roles"; for use_type=2; used variable for shape.}

\item{\code{plot_size}}{default "Abundance"; for use_type=2; used for point size; a fixed number (e.g. 5) is also available.}

\item{\code{color_values}}{default RColorBrewer::brewer.pal(12, "Paired"); for use_type=2; color vector}

\item{\code{shape_values}}{default c(16, 17, 7, 8, 15, 18, 11, 10, 12, 13, 9, 3, 4, 0, 1, 2, 14); for use_type=2; shape vector, see ggplot2 tutorial for the shape meaning.}

\item{\code{...}}{parameters pass to geom_point.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_taxa_roles(roles_color_background = FALSE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_network-subset_network"></a>}}
\if{latex}{\out{\hypertarget{method-trans_network-subset_network}{}}}
\subsection{Method \code{subset_network()}}{
Subset of the network.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$subset_network(node = NULL, edge = NULL, rm_single = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{node}}{default NULL; provide the node names that you want to use in the sub-network.}

\item{\code{edge}}{default NULL; provide the edge name needed; must be one of "+" or "-".}

\item{\code{rm_single}}{default TRUE; whether remove the nodes without any edge in the sub-network.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new network
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$subset_network(node = t1$res_node_table \%>\% base::subset(module == "M1") \%>\% 
  rownames, rm_single = TRUE)
# return a sub network that contains all nodes of module M1
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_network-cal_powerlaw"></a>}}
\if{latex}{\out{\hypertarget{method-trans_network-cal_powerlaw}{}}}
\subsection{Method \code{cal_powerlaw()}}{
Fit degrees to a power law distribution. First, perform a bootstrapping hypothesis test to determine whether degrees follow a power law distribution.
If the distribution follows power law, then fit degrees to power law distribution and return the parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$cal_powerlaw(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{parameters pass to bootstrap_p function in poweRlaw package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_powerlaw_p} and \code{res_powerlaw_fit}; see \code{poweRlaw::bootstrap_p} function for the bootstrapping p value details;
  see \code{igraph::fit_power_law} function for the power law fit return details.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_powerlaw()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_network-cal_sum_links"></a>}}
\if{latex}{\out{\hypertarget{method-trans_network-cal_sum_links}{}}}
\subsection{Method \code{cal_sum_links()}}{
This function is used to sum the links number from one taxa to another or in the same taxa, for example, at Phylum level.
This is very useful to fast see how many nodes are connected between different taxa or within the taxa.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$cal_sum_links(taxa_level = "Phylum")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{taxa_level}}{default "Phylum"; taxonomic rank.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_sum_links_pos} and \code{res_sum_links_neg} in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_sum_links(taxa_level = "Phylum")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_network-plot_sum_links"></a>}}
\if{latex}{\out{\hypertarget{method-trans_network-plot_sum_links}{}}}
\subsection{Method \code{plot_sum_links()}}{
Plot the summed linkages among taxa using chorddiag package <https://github.com/mattflor/chorddiag>.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$plot_sum_links(
  plot_pos = TRUE,
  plot_num = NULL,
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_pos}}{default TRUE; If TRUE, plot the summed positive linkages; If FALSE, plot the summed negative linkages.}

\item{\code{plot_num}}{default NULL; number of taxa presented in the plot.}

\item{\code{color_values}}{default RColorBrewer::brewer.pal(8, "Dark2"); colors palette for taxa.}

\item{\code{...}}{parameters pass to \code{chorddiag::chorddiag} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
chorddiag plot
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
test1$plot_sum_links(plot_pos = TRUE, plot_num = 10)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_network-random_network"></a>}}
\if{latex}{\out{\hypertarget{method-trans_network-random_network}{}}}
\subsection{Method \code{random_network()}}{
Generate random networks, compare them with the empirical network and get the p value of topological properties.
The generation of random graph is based on the \code{erdos.renyi.game} function of igraph package.
The numbers of vertices and edges in the random graph are same with the empirical network stored in the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$random_network(runs = 100, output_sim = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{runs}}{default 100; simulation number of random network.}

\item{\code{output_sim}}{default FALSE; whether output each simulated network result.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a data.frame with the following components:
\describe{
  \item{\code{Observed}}{Topological properties of empirical network}
  \item{\code{Mean_sim}}{Mean of properties of simulated networks}
  \item{\code{SD_sim}}{SD of properties of simulated networks}
  \item{\code{p_value}}{Significance, i.e. p values}
}
When \code{output_sim = TRUE}, the columns from the five to the last are each simulated result.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
t1$random_network(runs = 100)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_network-trans_comm"></a>}}
\if{latex}{\out{\hypertarget{method-trans_network-trans_comm}{}}}
\subsection{Method \code{trans_comm()}}{
Transform classifed features to community-like microtable object for further analysis, such as module-taxa table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$trans_comm(use_col = "module", abundance = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_col}}{default "module"; which column to use as the 'community'; must be one of the name of res_node_table from function \code{get_node_table}.}

\item{\code{abundance}}{default TRUE; whether sum abundance of taxa. TRUE: sum the abundance for a taxon across all samples; 
FALSE: sum the frequency for a taxon across all samples.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new \code{\link{microtable}} class.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t2 <- t1$trans_comm(use_col = "module")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_network-print"></a>}}
\if{latex}{\out{\hypertarget{method-trans_network-print}{}}}
\subsection{Method \code{print()}}{
Print the trans_network object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_network-clone"></a>}}
\if{latex}{\out{\hypertarget{method-trans_network-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
