% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_alpha.R
\name{trans_alpha}
\alias{trans_alpha}
\title{Create \code{trans_alpha} object for alpha diversity statistics and plotting.}
\description{
This class is a wrapper for a series of alpha diversity related analysis, including the statistics and plotting based on 
An et al. (2019) <doi:10.1016/j.geoderma.2018.09.035> and Paul et al. (2013) <doi:10.1371/journal.pone.0061217>.
}
\examples{

## ------------------------------------------------
## Method `trans_alpha$new`
## ------------------------------------------------

\donttest{
data(dataset)
t1 <- trans_alpha$new(dataset = dataset, group = "Group")
}

## ------------------------------------------------
## Method `trans_alpha$cal_diff`
## ------------------------------------------------

\donttest{
t1$cal_diff(method = "KW")
t1$cal_diff(method = "anova")
t1 <- trans_alpha$new(dataset = dataset, group = "Type", by_group = "Group")
t1$cal_diff(method = "anova")
}

## ------------------------------------------------
## Method `trans_alpha$plot_alpha`
## ------------------------------------------------

\donttest{
t1 <- trans_alpha$new(dataset = dataset, group = "Group")
t1$cal_diff(method = "wilcox")
t1$plot_alpha(measure = "Shannon", add_sig = TRUE)
t1 <- trans_alpha$new(dataset = dataset, group = "Type", by_group = "Group")
t1$cal_diff(method = "wilcox")
t1$plot_alpha(measure = "Shannon", add_sig = TRUE)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-trans_alpha-new}{\code{trans_alpha$new()}}
\item \href{#method-trans_alpha-cal_diff}{\code{trans_alpha$cal_diff()}}
\item \href{#method-trans_alpha-plot_alpha}{\code{trans_alpha$plot_alpha()}}
\item \href{#method-trans_alpha-print}{\code{trans_alpha$print()}}
\item \href{#method-trans_alpha-clone}{\code{trans_alpha$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_alpha-new"></a>}}
\if{latex}{\out{\hypertarget{method-trans_alpha-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$new(
  dataset = NULL,
  group = NULL,
  by_group = NULL,
  by_ID = NULL,
  order_x = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{the object of \code{\link{microtable}} Class.}

\item{\code{group}}{default NULL; a column of sample_table used for the statistics; If provided, can return \code{data_stat}.}

\item{\code{by_group}}{default NULL; a column of sample_table used to perform the differential test 
among groups (\code{group} parameter) for each group (\code{by_group} parameter). So \code{by_group} has a larger scale than \code{group} parameter.}

\item{\code{by_ID}}{default NULL; a column of sample_table used to perform paired t test or paired wilcox test for the paired data,
such as the data of plant compartments for different plant species (ID). 
So \code{by_ID} in sample_table should be the smallest unit of sample collection without any repetition in it.}

\item{\code{order_x}}{default NULL; a \code{sample_table} column name or a vector containg sample names; if provided, order samples by using \code{factor}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{data_alpha} and \code{data_stat} stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
data(dataset)
t1 <- trans_alpha$new(dataset = dataset, group = "Group")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_alpha-cal_diff"></a>}}
\if{latex}{\out{\hypertarget{method-trans_alpha-cal_diff}{}}}
\subsection{Method \code{cal_diff()}}{
Test the difference of alpha diversity.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$cal_diff(
  method = c("KW", "KW_dunn", "wilcox", "t.test", "anova", "scheirerRayHare", "lme",
    "betareg")[1],
  measure = NULL,
  p_adjust_method = "fdr",
  formula = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{default "KW"; see the following available options:
\describe{
  \item{\strong{'KW'}}{KW: Kruskal-Wallis Rank Sum Test for all groups (>= 2)}
  \item{\strong{'KW_dunn'}}{Dunn's Kruskal-Wallis Multiple Comparisons, see \code{dunnTest} function in \code{FSA} package}
  \item{\strong{'wilcox'}}{Wilcoxon Rank Sum and Signed Rank Tests for all paired groups }
  \item{\strong{'t.test'}}{Student's t-Test for all paired groups}
  \item{\strong{'anova'}}{Duncan's new multiple range test for one-way anova; see \code{duncan.test} function of \code{agricolae} package.
        For multi-factor anova, see \code{\link{aov}}}
  \item{\strong{'scheirerRayHare'}}{Scheirer Ray Hare test for nonparametric test used for a two-way factorial experiment; 
        see \code{scheirerRayHare} function of \code{rcompanion} package}
  \item{\strong{'lme'}}{lme: Linear Mixed Effect Model based on the \code{lmerTest} package}
  \item{\strong{'betareg'}}{Beta Regression for Rates and Proportions based on the \code{betareg} package}
}}

\item{\code{measure}}{default NULL; a vector; if null, all indexes will be calculated; see names of \code{microtable$alpha_diversity}, 
e.g. Observed, Chao1, ACE, Shannon, Simpson, InvSimpson, Fisher, Coverage, PD.}

\item{\code{p_adjust_method}}{default "fdr"; p.adjust method; see method parameter of \code{p.adjust} function for available options; 
NULL can disuse the p value adjustment.}

\item{\code{formula}}{default NULL; applied to two-way or multi-factor anova analysis when 
method = \code{"anova"} or \code{"scheirerRayHare"} or \code{"lme"} or \code{"betareg"}; 
specified set for independent variables, i.e. the latter part of the formula in \code{\link{aov}}, 
such as \code{'block + N*P*K'}.}

\item{\code{...}}{parameters passed to \code{kruskal.test} or \code{wilcox.test} function (\code{method = "KW"}) or \code{dunnTest} function of \code{FSA} package 
(\code{method = "KW_dunn"}) or \code{agricolae::duncan.test} (\code{method = "anova"}, one-way) or \code{lmerTest::lmer} (\code{method = "lme"}) or 
\code{rcompanion::scheirerRayHare} (\code{method = "scheirerRayHare"}) or
\code{betareg::betareg} (\code{method = "betareg"}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_diff} in object with the format \code{data.frame}.
  In the data frame, 'Group' column means that the group has the maximum median or mean value across the test groups;
  For non-parametric methods, maximum median value; For t.test, maximum mean value.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_diff(method = "KW")
t1$cal_diff(method = "anova")
t1 <- trans_alpha$new(dataset = dataset, group = "Type", by_group = "Group")
t1$cal_diff(method = "anova")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_alpha-plot_alpha"></a>}}
\if{latex}{\out{\hypertarget{method-trans_alpha-plot_alpha}{}}}
\subsection{Method \code{plot_alpha()}}{
Plotting the alpha diversity.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$plot_alpha(
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  measure = "Shannon",
  group = NULL,
  add_sig = TRUE,
  add_sig_label = "Significance",
  add_sig_text_size = 3.88,
  use_boxplot = TRUE,
  boxplot_add = "jitter",
  order_x_mean = FALSE,
  y_start = 1.01,
  y_increase = 0.05,
  xtext_angle = NULL,
  xtext_size = 15,
  ytitle_size = 17,
  barwidth = 0.9,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_values}}{default \code{RColorBrewer::brewer.pal}(8, "Dark2"); color pallete for groups.}

\item{\code{measure}}{default Shannon; alpha diversity measurement; see names of alpha_diversity of dataset, 
e.g., Observed, Chao1, ACE, Shannon, Simpson, InvSimpson, Fisher, Coverage, PD.}

\item{\code{group}}{default NULL; group name used for the plot.}

\item{\code{add_sig}}{default TRUE; wheter add significance label using the result of cal_diff function, i.e. \code{object$res_diff};
This is manily designed to add post hoc test of anova or Dunn's Kruskal-Wallis Multiple Comparisons to make the label adding easy.}

\item{\code{add_sig_label}}{default "Significance"; select a colname of \code{object$res_diff} for the label text, such as 'P.adj' or 'Significance'.}

\item{\code{add_sig_text_size}}{default 3.88; the size of text in added label.}

\item{\code{use_boxplot}}{default TRUE; TRUE: boxplot; FALSE: mean-se plot.}

\item{\code{boxplot_add}}{default "jitter"; points type, see the add parameter in \code{ggpubr::ggboxplot}.}

\item{\code{order_x_mean}}{default FALSE; whether order x axis by the means of groups from large to small.}

\item{\code{y_start}}{default 1.01; the y axis value from which to add the label; the default 1.01 means \code{1.01 * max(values)}.}

\item{\code{y_increase}}{default 0.05; the increasing y axia space to add label; the default 0.05 means \code{0.05 * y_start}; 
this parameter is also used to label the letters of anova result with the fixed \code{(1 + y_increase) * y_start space}.}

\item{\code{xtext_angle}}{default NULL; number (e.g. 30) used to make x axis text generate angle.}

\item{\code{xtext_size}}{default 15; x axis text size.}

\item{\code{ytitle_size}}{default 17; y axis title size.}

\item{\code{barwidth}}{default 0.9; the bar width in plot; applied when by_group is not NULL.}

\item{\code{...}}{parameters pass to \code{ggpubr::ggboxplot} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1 <- trans_alpha$new(dataset = dataset, group = "Group")
t1$cal_diff(method = "wilcox")
t1$plot_alpha(measure = "Shannon", add_sig = TRUE)
t1 <- trans_alpha$new(dataset = dataset, group = "Type", by_group = "Group")
t1$cal_diff(method = "wilcox")
t1$plot_alpha(measure = "Shannon", add_sig = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_alpha-print"></a>}}
\if{latex}{\out{\hypertarget{method-trans_alpha-print}{}}}
\subsection{Method \code{print()}}{
Print the trans_alpha object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_alpha-clone"></a>}}
\if{latex}{\out{\hypertarget{method-trans_alpha-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
