% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{richness}
\alias{richness}
\title{calculat the richness for the phyloseq object}
\usage{
richness(physeq, method = c("Observed", "Simpson", "Shannon"))
}
\arguments{
\item{physeq}{A \code{phyloseq} object containing merged information of abundance,
taxonomic assignment, sample data including the measured variables and categorical information
of the samples, and / or phylogenetic tree if available.}

\item{method}{A list of character strings specifying \code{method} to be used to calculate for alpha diversity
in the data. Available methods are: "Observed","Chao1","ACE","Richness", "Fisher", "Simpson", "Shannon", "Evenness","InvSimpson".}
}
\value{
data.frame of alpha diversity
}
\description{
calculat the richness for the phyloseq object
}
\examples{
{
data("Physeq")
rich <-richness(physeq,method=c("Simpson", "Shannon"))
}
}
\author{
Kai Guo
}
