% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CV_iterative_clustering.R
\name{CV_iterative_clustering}
\alias{CV_iterative_clustering}
\title{Cross validation of the iterative Hartigan-Wong k-means clustering.}
\usage{
CV_iterative_clustering(data, results, common, k = 1L, parallel = TRUE)
}
\arguments{
\item{data}{input matrix with paired times, i.e. samples to be stressed to multiple iterations.}

\item{results}{the \code{\link[=stabilitas]{stabilitas()}} output for the concrete paired times used for validation.}

\item{common}{pattern that separates the ID and the sampling time.}

\item{k}{integer; number of individuals to subset from the data for each time running \code{\link[=iterative_clustering]{iterative_clustering()}}.}

\item{parallel}{logical; FALSE to sequentially run the internal loop or TRUE to do it by parallel computing (number of cores = 4).}
}
\value{
Multiple lists with multiple objects of class "kmeans".
}
\description{
Perform cross validation in the way of leave-one-out (LOO) or k-fold of the stability results from \code{\link[=iterative_clustering]{iterative_clustering()}}.
}
\examples{
\donttest{
t1_t2 <- paired_times(data = clr, first = "_1",
                      second = "_25", common = "_0_")
klist_t1_t2 <- iterative_clustering(data = t1_t2, parallel = FALSE)
result_t1_t2 <- stabilitas(klist_t1_t2, common = "_0_")
cv_klist_t1_t2_k2 <- CV_iterative_clustering(data = t1_t2, results = result_t1_t2,
                                             common = "_0_", k = 2L, parallel = FALSE)
}
}
