% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinePathsFuncDefault.R
\name{combinePathsFuncDefault}
\alias{combinePathsFuncDefault}
\alias{combinePathsFunc}
\title{Combine microbial growth on different pathways by one microbe}
\usage{
combinePathsFuncDefault(strainName, groupName, growthRate, num.paths,
  pathNames)
}
\arguments{
\item{strainName}{Name of the strain that is being looped through in the ODE solver}

\item{groupName}{Name of microbial group that is being looped through in the ODE solver}

\item{growthRate}{(vector) microbial growth rate (mass per unit time) on each pathway}

\item{num.paths}{(integer) is the number of paths for the given strain}

\item{pathNames}{Vector of names of all metabolic paths e.g. c('path1','path2')}
}
\value{
vector specifying the fraction of the total microbial growth on each pathway
}
\description{
Returns a vector specifying the fraction of the total microbial growth on each pathway.
This function is needed to ensure that groups which have the most paths do not automatically have the most growth - i.e. need to weight the growth on each pathway.
}
