% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{resourceSysInfo}
\alias{resourceSysInfo}
\title{resourceSysInfo}
\format{A dataframe with the row names in the itemised list below and a column for units (optional) and for each resource in the system to be simulated.}
\usage{
resourceSysInfo
}
\description{
Data frame describing the system information for the state variables that are resources (i.e. substrates or metabolic products).
}
\details{
Each resource (substrate, metabolic product or biomass if microbes are a resource e.g. in the case of viruses) has a column. The first column can be used for describing the units of each variable. This is optional and just for clarity - it is not used within microPop (note, the units column must be labelled 'units').
The data frame must contain the following rows:
\itemize{
\item startValue The value of each resource at the start time of the simulation (e.g. units are g/l)
\item inflowRate The value of the rate of inflow of each resource (e.g. units are g/l/d)
\item washOut The specific washout rate of each resource (e.g. units are /d)
\item molarMass The mass in grams of one mole of the resource (units are g/mol) 
}
}
\keyword{data}
\keyword{datasets}
