% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micomp.R
\name{print.assumptions_micomp}
\alias{print.assumptions_micomp}
\title{Print information about the assumptions concerning the parametric tests
performed on multiple comparisons of outputs}
\usage{
\method{print}{assumptions_micomp}(x, ...)
}
\arguments{
\item{x}{Object of class \code{assumptions_micomp}.}

\item{...}{Currently ignored.}
}
\value{
The argument \code{x}, invisibly, as for all \code{\link{print}}
methods.
}
\description{
Print information about objects of class \code{assumptions_micomp}, which
represent the assumptions concerning the parametric tests performed on
multiple comparisons of outputs.
}
\examples{
\donttest{
# Create a micomp object, use provided dataset
mic <- micomp(c("SheepPop", "WolfPop", "GrassQty"), 0.7,
              list(list(name = "NLOKvsJEXOK", grpout = pphpc_ok),
                   list(name = "NLOKvsJEXNOSHUFF", grpout = pphpc_noshuff),
                   list(name = "NLOKvsJEXDIFF", grpout = pphpc_diff)))

# Print the results (p-values) of the statistic tests evaluating the
# assumptions of the comparisons performed in the mic object
assumptions(mic)
}
}
